/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.application;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.application.utils.LicenseUtil;
import com.kms.katalon.core.application.ApplicationWorkbenchWindowAdvisor;
import com.kms.katalon.plugin.dialog.FirstTimeUseDialog;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.WorkbenchErrorHandler;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static final String GREPCLIPSE_PACKAGE_NAME_PREFIX = "org.codehaus.groovy.eclipse";
    private AbstractStatusHandler workbenchErrorHandler;

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new ApplicationWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return "com.kms.katalon.composer.perspective.keyword";
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        IDE.registerAdapters();
        configurer.setSaveAndRestore(true);
    }

    public synchronized AbstractStatusHandler getWorkbenchErrorHandler() {
        if (this.workbenchErrorHandler != null) {
            return this.workbenchErrorHandler;
        }
        this.workbenchErrorHandler = new WorkbenchErrorHandler(){

            public void handle(StatusAdapter statusAdapter, int style) {
                if (this.isGroovyEditorError(statusAdapter)) {
                    this.handleGroovyEditorError(statusAdapter);
                    return;
                }
                super.handle(statusAdapter, style);
            }

            private void handleGroovyEditorError(StatusAdapter statusAdapter) {
                super.handle(statusAdapter, 1);
            }

            private boolean isGroovyEditorError(StatusAdapter statusAdapter) {
                IStatus status = statusAdapter.getStatus();
                if (!(status.getException() instanceof StringIndexOutOfBoundsException)) {
                    return false;
                }
                StackTraceElement[] stackTraces = status.getException().getStackTrace();
                if (stackTraces.length < 2) {
                    return false;
                }
                return stackTraces[1].getClassName().startsWith(ApplicationWorkbenchAdvisor.GREPCLIPSE_PACKAGE_NAME_PREFIX);
            }
        };
        return this.workbenchErrorHandler;
    }

    public boolean preShutdown() {
        this.showFirstTimeUseSurvey();
        return true;
    }

    private void showFirstTimeUseSurvey() {
        String userEmail = ApplicationContext.getInstance().getUserId();
        UserProfile userProfile = UserProfileHelper.getOrCreateProfile((String)userEmail);
        if (StringUtils.isBlank((CharSequence)userEmail) || userProfile.isDoneFirstTimeUseSurvey()) {
            return;
        }
        if (LicenseUtil.isNonPaidLicense()) {
            FirstTimeUseDialog dialog = new FirstTimeUseDialog(Display.getCurrent().getActiveShell());
            dialog.open();
            userProfile = UserProfileHelper.getCurrentProfile();
            userProfile.setDoneFirstTimeUseSurvey(true);
            UserProfileHelper.saveProfile((UserProfile)userProfile);
        }
    }
}

