/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.application;

import com.kms.katalon.addons.CommandBindingRemover;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.composer.components.ComponentBundleActivator;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.editors.extensions.OpenEditorActionFactory;
import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.handlers.CloseHandler;
import com.kms.katalon.composer.handlers.QuitHandler;
import com.kms.katalon.composer.handlers.ResetPerspectiveHandler;
import com.kms.katalon.composer.handlers.SaveHandler;
import com.kms.katalon.composer.handlers.SearchHandler;
import com.kms.katalon.composer.handlers.WorkbenchSaveHandler;
import com.kms.katalon.composer.initializer.CommandBindingInitializer;
import com.kms.katalon.composer.initializer.ContentAssistProposalInitializer;
import com.kms.katalon.composer.initializer.CucumberEditorColorInitializer;
import com.kms.katalon.composer.initializer.DefaultLineNumberInitializer;
import com.kms.katalon.composer.initializer.DefaultTextFontInitializer;
import com.kms.katalon.composer.initializer.DisplayInitializer;
import com.kms.katalon.composer.initializer.ProblemViewImageInitializer;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.application.ApplicationStaupHandler;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.tracking.core.TrackingManager;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.OpenEditorAction;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.PartSite;
import org.osgi.framework.BundleException;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class LifeCycleManager {
    private static boolean WORKSPACE_CREATED = false;

    public static boolean isWorkspaceCreated() {
        return WORKSPACE_CREATED;
    }

    private void startUpGUIMode() throws Exception {
        ProjectController.cleanWorkspace();
        this.setUpDefaultTheme();
        this.setupHandlers();
        this.setupPreferences();
        EventBrokerSingleton.getInstance().getEventBroker().post("WORKSPACE/CREATED", (Object)"");
        WORKSPACE_CREATED = true;
    }

    protected void setupHandlers() throws BundleException {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.file.save", (IHandler)new SaveHandler());
        handlerService.activateHandler("org.eclipse.ui.file.close", (IHandler)new CloseHandler());
        handlerService.activateHandler("org.eclipse.ui.file.exit", (IHandler)new QuitHandler());
        handlerService.activateHandler("org.eclipse.search.ui.openSearchDialog", (IHandler)new SearchHandler());
        handlerService.activateHandler("com.kms.katalon.composer.menu.handler.resetPerspective", (IHandler)new ResetPerspectiveHandler());
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        contextService.activateContext("katalonContext");
        MTrimmedWindow model = (MTrimmedWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(MTrimmedWindow.class);
        IEclipseContext context = model.getContext();
        context.set(ISaveHandler.class, (Object)new WorkbenchSaveHandler());
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        final IWorkbenchPage page = workbenchWindow.getActivePage();
        workbenchWindow.getPartService().addPartListener(new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                EventBrokerSingleton.getInstance().getEventBroker().post("EDITORS_CLOSED", (Object)partRef.getPart(true));
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
                if ("org.eclipse.search.ui.views.SearchView".equals(partRef.getId())) {
                    SearchHandler.openSearchView();
                    return;
                }
                if ("org.codehaus.groovy.eclipse.editor.GroovyEditor".equals(partRef.getId())) {
                    IEditorPart editor = page.getActiveEditor();
                    if (editor != null && editor instanceof GroovyEditor) {
                        OpenEditorActionFactory.fixOpenDeclarationEditor((GroovyEditor)((GroovyEditor)editor));
                    }
                    EventUtil.post((String)"PROPERTIES/ENTITY", null);
                    new CommandBindingInitializer().resetDeleteKeyBinding();
                }
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                IEditorInput input;
                IFile file;
                IEditorPart replacedEditor;
                IEditorPart editor;
                IEditorSite site;
                String eleId;
                if ("org.eclipse.ui.console.ConsoleView".equals(partRef.getId())) {
                    Trackings.trackOpenConsoleView();
                }
                if ("org.codehaus.groovy.eclipse.editor.GroovyEditor".equals(partRef.getId()) && !(eleId = ((PartSite)(site = (editor = page.getActiveEditor()).getEditorSite())).getModel().getElementId()).contains("com.kms.katalon.composer.content.testcase") && !eleId.contains("com.kms.katalon.composer.content.testobject") && !eleId.contains("com.kms.katalon.composer.content.testsuite") && editor != null && (replacedEditor = LifeCycleManager.this.replaceEditor(file = ((IFileEditorInput)(input = editor.getEditorInput())).getFile(), page)) != null) {
                    Display.getDefault().asyncExec(() -> page.hideEditor((IEditorReference)page.getReference((IWorkbenchPart)editor)));
                }
            }
        });
        new CommandBindingInitializer().setup();
        new CommandBindingRemover().setup();
        new ContentAssistProposalInitializer().setup();
        new ProblemViewImageInitializer().setup();
        new DefaultTextFontInitializer().setup();
        new DisplayInitializer().setup();
        new CucumberEditorColorInitializer().setup();
        new DefaultLineNumberInitializer().setup();
    }

    private void setupPreferences() {
        this.setupResourcePlugin();
        this.setupGroovyTemplatePlugin();
    }

    private void setupGroovyTemplatePlugin() {
        try {
            ScopedPreferenceStore prefStore = PreferenceStoreManager.getPreferenceStore((String)"org.codehaus.groovy.eclipse.quickfix");
            if (!prefStore.getBoolean("groovy.first.setup")) {
                prefStore.setDefault("groovy", "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><templates><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Checkpoint\" enabled=\"true\" name=\"cp\">${Checkpoint:newType(com.kms.katalon.core.checkpoint.Checkpoint)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Checkpoint Factory\" enabled=\"true\" name=\"cpf\">${CheckpointFactory:newType(com.kms.katalon.core.checkpoint.CheckpointFactory)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Failure Handling\" enabled=\"true\" name=\"fh\">${FailureHandling:newType(com.kms.katalon.core.model.FailureHandling)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Find Checkpoint\" enabled=\"true\" name=\"fcp\">${findCheckpoint:importStatic(com.kms.katalon.core.checkpoint.CheckpointFactory.findCheckpoint)}findCheckpoint(${word_selection}${null})${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Find Test Case\" enabled=\"true\" name=\"ftc\">${findTestCase:importStatic(com.kms.katalon.core.testcase.TestCaseFactory.findTestCase)}findTestCase(${word_selection}${null})${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Find Test Data\" enabled=\"true\" name=\"ftd\">${findTestData:importStatic(com.kms.katalon.core.testdata.TestDataFactory.findTestData)}findTestData(${word_selection}${null})${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Find Test Object\" enabled=\"true\" name=\"fto\">${findTestObject:importStatic(com.kms.katalon.core.testobject.ObjectRepository.findTestObject)}findTestObject(${word_selection}${null})${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Global Variables\" enabled=\"true\" name=\"gv\">${GlobalVariable:newType(internal.GlobalVariable)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Object Repository\" enabled=\"true\" name=\"tof\">${ObjectRepository:newType(com.kms.katalon.core.testobject.ObjectRepository)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Test Case\" enabled=\"true\" name=\"tc\">${TestCase:newType(com.kms.katalon.core.testcase.TestCase)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Test Case Factory\" enabled=\"true\" name=\"tcf\">${TestCaseFactory:newType(com.kms.katalon.core.testcase.TestCaseFactory)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Test Data\" enabled=\"true\" name=\"td\">${TestData:newType(com.kms.katalon.core.testdata.TestData)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Test Data Factory\" enabled=\"true\" name=\"tdf\">${TestDataFactory:newType(com.kms.katalon.core.testdata.TestDataFactory)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Test Object\" enabled=\"true\" name=\"to\">${TestObject:newType(com.kms.katalon.core.testobject.TestObject)}${cursor}</template></templates>");
                prefStore.setToDefault("groovy");
                prefStore.setValue("groovy.first.setup", true);
            }
            prefStore.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void setupResourcePlugin() {
        try {
            ScopedPreferenceStore runtimePrefStore = PreferenceStoreManager.getPreferenceStore((String)"org.eclipse.core.resources");
            if (!runtimePrefStore.getBoolean("description.autobuilding")) {
                runtimePrefStore.setValue("description.autobuilding", true);
            }
            if (!runtimePrefStore.getBoolean("refresh.lightweight.enabled")) {
                runtimePrefStore.setValue("refresh.lightweight.enabled", true);
            }
            runtimePrefStore.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void setUpDefaultTheme() {
        IThemeEngine engine = ComponentBundleActivator.getThemeEngine((Display)Display.getCurrent());
        if (engine.getActiveTheme() == null) {
            engine.setTheme("com.kms.katalon.theme.default", true);
        }
    }

    @PostContextCreate
    void postContextCreate(final IEventBroker eventBroker) {
        eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/appStartupComplete", new EventHandler(){

            public void handleEvent(Event event) {
                block7: {
                    if (LifeCycleManager.isTestMode()) {
                        return;
                    }
                    try {
                        LifeCycleManager.this.startUpGUIMode();
                        LifeCycleManager.scheduleCollectingStatistics();
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError((Throwable)e);
                    }
                    try {
                        if (ApplicationStaupHandler.checkActivation(true)) {
                            eventBroker.post("ACTIVATION/CHECKED", null);
                        }
                        if (ActivationInfoCollector.isActivated()) {
                            eventBroker.post("ACTIVATION/WEBVIEW_PAGE", null);
                        }
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError((Throwable)e);
                        if (PlatformUI.getWorkbench() == null || PlatformUI.getWorkbench().isClosing()) break block7;
                        PlatformUI.getWorkbench().close();
                    }
                }
            }
        });
    }

    private static void scheduleCollectingStatistics() {
        int trackingTime = TrackingManager.getInstance().getTrackingTime();
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> Trackings.trackProjectStatistics((ProjectEntity)ProjectController.getInstance().getCurrentProject(), (!ActivationInfoCollector.isActivated() ? 1 : 0) != 0, (String)"gui"), trackingTime, trackingTime, TimeUnit.SECONDS);
    }

    private static boolean isTestMode() {
        List<String> args = Arrays.asList(Platform.getCommandLineArgs());
        return args.contains("-testproperties") || args.contains("-testLoaderClass");
    }

    private IEditorPart replaceEditor(IFile file, IWorkbenchPage page) {
        String fileName = FilenameUtils.getBaseName((String)file.getFullPath().toString());
        String fileExtension = "." + file.getFileExtension();
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        try {
            if (fileExtension.equals(".groovy")) {
                TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByScriptName(fileName);
                if (testCase != null) {
                    return OpenEditorAction.openTestCase(testCase);
                }
                String testSuiteId = file.getFullPath().toString().replace(String.valueOf(file.getProject().getFullPath().toString()) + "/", "").replace(".groovy", "");
                TestSuiteEntity testSuite = TestSuiteController.getInstance().getTestSuiteByDisplayId(testSuiteId, project);
                if (testSuite != null) {
                    return OpenEditorAction.openTestSuite(testSuite);
                }
                String testObjectId = file.getFullPath().toString().replace(String.valueOf(file.getProject().getFullPath().toString()) + "/", "").replace(".groovy", "");
                WebElementEntity testObject = ObjectRepositoryController.getInstance().getWebElementByScriptName(testObjectId, project);
                if (testObject != null) {
                    return OpenEditorAction.openTestObject(testObject);
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return null;
    }
}

