/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.plugin.dialog;

import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.tracking.service.Trackings;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FirstTimeUseDialog
extends AbstractDialog {
    private static final String ACTION_YES = "Yes";
    private static final String ACTION_NO = "No";
    private static final String ACTION_CLOSE = "Close";
    private boolean isDirectCloseAtFirstStage = true;
    private boolean isDirectCloseAtSecondStage = true;
    private Composite leavingComposite;
    private Composite confirmComposite;
    private List<Button> answerBtns;
    private Button btnSend;
    private LinkedHashMap<String, String> answers = new LinkedHashMap<String, String>(){
        {
            this.put("ks-not-need", "Katalon Studio is not what I'm looking for. (Then tell us what you're looking for)");
            this.put("AUT-not-supported", "My Application Under Test is not supported. (May we know what technology also needs automated test?) ");
            this.put("bugs", MessageFormat.format("I encountered bugs. (Report it {0}!)", ComponentUtil.wrapLink((String)"here", (String)"https://forum.katalon.com/c/katalon-studio/katalon-studio-bug-reports")));
            this.put("onboarding", "I don't know what to do or where to start.");
            this.put("documents", "You guys need to improve the tutorials and documents.\r\n(Our technical writer would be grateful if she knows where to edit. Please leave a comment below the document.)");
            this.put("ks-not-good", "Katalon Studio is not good enough. Your thoughts and feelings need to be heard. Please share it with us.");
            this.put("others", "Others.");
        }
    };

    public FirstTimeUseDialog(Shell parentShell) {
        super(parentShell, false);
    }

    public String getDialogTitle() {
        return "It's sad you're leaving...";
    }

    protected Control createDialogContainer(Composite parent) {
        Trackings.trackQuitSurvey2Open();
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).margin(0).build();
        this.createConfirmComposite(container);
        Composite leavingReasonComposite = this.createLeaveReasonComposite(container);
        container.pack();
        ComponentUtil.setWidth((Control)leavingReasonComposite, (int)container.getSize().x);
        return container;
    }

    private Composite createConfirmComposite(Composite parent) {
        this.confirmComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent).margin(0).build();
        ComponentBuilder.label((Composite)this.confirmComposite).margin(30, 30).text("Hey! You're about to close this app. Are you leaving us for good? Or, will we meet again?").build();
        Composite buttonsComposite = this.createButtonsComposite(this.confirmComposite, 2, 20);
        ComponentBuilder.button((Composite)buttonsComposite).text("No, I won't be back").fillHorizontal().right().onClick(event -> {
            this.isDirectCloseAtFirstStage = false;
            Trackings.trackQuitSurvey2Action((String)ACTION_NO);
            ComponentUtil.hide((Control)this.confirmComposite);
            ComponentUtil.show((Control)this.leavingComposite);
            this.getShell().pack();
            this.getShell().setLocation(DialogUtil.computeCenterLocation((Point)this.getShell().getSize(), null));
            this.getShell().setDefaultButton(this.btnSend);
        }).build();
        ComponentBuilder.button((Composite)buttonsComposite).text("Yes, I will be back").right().noFill().onClick(event -> {
            this.isDirectCloseAtFirstStage = false;
            this.isDirectCloseAtSecondStage = false;
            Trackings.trackQuitSurvey2Action((String)ACTION_YES);
            Trackings.trackInAppSurveyWillContinueToUse((boolean)true, null);
            this.close();
        }).build();
        return this.confirmComposite;
    }

    private Composite createLeaveReasonComposite(Composite parent) {
        this.leavingComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent).margin(20, 20, 0).fill().hide().build();
        ComponentBuilder.label((Composite)this.leavingComposite).text("Thank you for using Katalon Studio. Before your departure, please let us know how your experience has been so far. We'd love to be better.").fillHorizontal().build();
        ComponentBuilder.label((Composite)this.leavingComposite).text("You can select multiple answers:").marginTop(10).marginBottom(20).build();
        Composite answersComposite = (Composite)ComponentBuilder.gridContainer((Composite)this.leavingComposite).fillHorizontal().build();
        this.answerBtns = new ArrayList<Button>();
        this.answers.forEach((key, answer) -> this.answerBtns.add(this.createAnswer(answersComposite, (String)key, (String)answer)));
        ComponentBuilder.label((Composite)this.leavingComposite).text("Please elaborate on your answer.").marginVertical(10).build();
        Text txtComment = (Text)ComponentBuilder.text((Composite)this.leavingComposite, (int)2880).fill().minHeight(100).placeholder("Your thoughts and fellings need to be heard.").forceFocus().build();
        Composite buttonsComposite = this.createButtonsComposite(this.leavingComposite, 1, 0);
        this.btnSend = (Button)ComponentBuilder.button((Composite)buttonsComposite).text(GlobalMessageConstants.SEND).minWidth(100).right().onClick(event -> {
            this.isDirectCloseAtSecondStage = false;
            String comment = txtComment.getText();
            String selectedAnswers = this.answerBtns.stream().map(button -> button.getSelection() ? (String)button.getData() : "").filter(answerI -> StringUtils.isNotBlank((CharSequence)answerI)).collect(Collectors.joining(","));
            Trackings.trackQuitSurvey2SendAnswer((String)selectedAnswers, (String)comment);
            this.close();
        }).disable().build();
        return this.leavingComposite;
    }

    private Button createAnswer(Composite parent, String key, String answer) {
        Composite answerComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).fillHorizontal().build();
        Button checkbox = (Button)ComponentBuilder.checkBox((Composite)answerComposite).cursorPointer().top().data((Object)key).onSelection(event -> this.updateButtonStates()).build();
        ComponentBuilder.linkOrLabel((Composite)answerComposite, (String)answer).text(answer).fillHorizontal().cursorPointer().onMouseUp(event -> {
            ComponentUtil.toggle((Widget)checkbox);
            this.updateButtonStates();
        }).stopPropagationOnSelection().build();
        return checkbox;
    }

    private void updateButtonStates() {
        boolean selectAnyAnswer = this.answerBtns.stream().anyMatch(answerBtn -> answerBtn.getSelection());
        this.btnSend.setEnabled(selectAnyAnswer);
    }

    private Composite createButtonsComposite(Composite parent, int numButtons, int marginX) {
        ComponentBuilder.separator((Composite)parent).build();
        Composite buttonsComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)numButtons).margin(5, marginX, 10).fillHorizontal().build();
        return buttonsComposite;
    }

    public boolean close() {
        if (this.isDirectCloseAtFirstStage) {
            Trackings.trackQuitSurvey2Action((String)ACTION_CLOSE);
        } else if (this.isDirectCloseAtSecondStage) {
            Trackings.trackQuitSurvey2Close();
        }
        return super.close();
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
    }
}

