/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.plugin.dialog;

import com.kms.katalon.activation.plugin.models.KStoreApiKeyCredentials;
import com.kms.katalon.activation.plugin.models.KStoreClientAuthException;
import com.kms.katalon.activation.plugin.models.KStoreClientException;
import com.kms.katalon.activation.plugin.models.KStoreCredentials;
import com.kms.katalon.activation.plugin.models.KStorePlugin;
import com.kms.katalon.activation.plugin.models.Plugin;
import com.kms.katalon.activation.plugin.models.ReloadItem;
import com.kms.katalon.activation.plugin.models.TrialExpiredException;
import com.kms.katalon.activation.plugin.service.KStoreRestClient;
import com.kms.katalon.application.helper.LicenseHelperFactory;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.providers.HyperLinkColumnLabelProvider;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.handlers.RequireAuthorizationHandler;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class ReloadPluginsResultDialog
extends Dialog {
    private static final int CLMN_PLUGIN_NAME_IDX = 0;
    private static final int CLMN_REVIEW_IDX = 3;
    private static final int KRE_CLMN_REVIEW_IDX = 2;
    private static final int CLMN_PURCHASE_IDX = 4;
    private static final int CLMN_ERROR_IDX = 5;
    private static final int KRE_CLMN_ERROR_IDX = 3;
    private List<ReloadItem> results;
    private Label lblWarning;

    protected ReloadPluginsResultDialog(Shell parentShell) {
        super(parentShell);
    }

    public ReloadPluginsResultDialog(Shell shell, List<ReloadItem> results) {
        this(shell);
        this.results = results;
    }

    protected Control createDialogArea(Composite parent) {
        boolean isKRELicense = LicenseHelperFactory.get().isNotFreeLicense();
        Composite body = new Composite(parent, 2048);
        body.setLayout((Layout)new GridLayout(1, false));
        GridData gdBody = new GridData(4, 4, true, true);
        body.setLayoutData((Object)gdBody);
        this.lblWarning = new Label(body, 64);
        GridData gdWarning = new GridData(4, 4, true, false);
        gdWarning.widthHint = 430;
        this.lblWarning.setLayoutData((Object)gdWarning);
        this.lblWarning.setText(StringConstants.KStorePluginsDialog_LBL_WARNING);
        ControlUtils.setFontStyle((Control)this.lblWarning, (int)2, (int)-1);
        boolean visible = !isKRELicense && this.shouldShowExpiryWarningMessage();
        gdWarning.exclude = !visible;
        this.lblWarning.setVisible(visible);
        this.lblWarning.setForeground(ColorUtil.getWarningForegroudColor());
        Composite tableComposite = new Composite(body, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        tableComposite.setLayout((Layout)new FillLayout());
        TableViewer pluginTableViewer = new TableViewer(tableComposite, 67586);
        pluginTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table pluginTable = pluginTableViewer.getTable();
        pluginTable.setHeaderVisible(true);
        pluginTable.setLinesVisible(true);
        TableViewerColumn tableViewerColumnPluginName = new TableViewerColumn(pluginTableViewer, 16384);
        TableColumn tableColumnPluginName = tableViewerColumnPluginName.getColumn();
        tableColumnPluginName.setText(StringConstants.KStorePluginsDialog_COL_PLUGIN);
        tableViewerColumnPluginName.setLabelProvider((CellLabelProvider)new PluginNameColumnLabelProvider(0));
        TableColumn tableColumnLicense = null;
        if (!isKRELicense) {
            TableViewerColumn tableViewerColumnLicense = new TableViewerColumn(pluginTableViewer, 16384);
            tableColumnLicense = tableViewerColumnLicense.getColumn();
            tableColumnLicense.setText(StringConstants.KStorePluginsDialog_COL_LICENSE);
            tableViewerColumnLicense.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    ReloadItem item = (ReloadItem)element;
                    Plugin plugin = item.getPlugin();
                    if (plugin.isOnline()) {
                        KStorePlugin onlinePlugin = plugin.getOnlinePlugin();
                        if (onlinePlugin.isFree()) {
                            return StringConstants.KStorePluginsDialog_LICENSE_FREE;
                        }
                        if (onlinePlugin.isExpired()) {
                            return StringConstants.KStorePluginsDialog_LICENSE_EXPIRED;
                        }
                        if (onlinePlugin.isPaid()) {
                            return StringConstants.KStorePluginsDialog_LICENSE_PAID;
                        }
                        if (onlinePlugin.isTrial()) {
                            return StringConstants.KStorePluginsDialog_LICENSE_TRIAL;
                        }
                    }
                    return "";
                }

                public Color getForeground(Object element) {
                    ReloadItem item = (ReloadItem)element;
                    Plugin plugin = item.getPlugin();
                    if (plugin.isOnline()) {
                        Color colorWarning = ColorUtil.getWarningForegroudColor();
                        if (ReloadPluginsResultDialog.this.checkExpire(plugin.getOnlinePlugin())) {
                            return colorWarning;
                        }
                    }
                    return super.getForeground(element);
                }
            });
        }
        TableViewerColumn tableViewerColumnVersion = new TableViewerColumn(pluginTableViewer, 16384);
        TableColumn tableColumnVersion = tableViewerColumnVersion.getColumn();
        tableColumnVersion.setText(StringConstants.KStorePluginsDialog_COL_VERSION);
        tableViewerColumnVersion.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ReloadItem item = (ReloadItem)element;
                Plugin plugin = item.getPlugin();
                if (plugin.isOnline()) {
                    KStorePlugin onlinePlugin = plugin.getOnlinePlugin();
                    return onlinePlugin.getLatestCompatibleVersion().getNumber();
                }
                return "";
            }
        });
        TableViewerColumn tableViewerColumnReview = new TableViewerColumn(pluginTableViewer, 16384);
        TableColumn tableColumnReview = tableViewerColumnReview.getColumn();
        tableViewerColumnReview.setLabelProvider((CellLabelProvider)new ReviewColumnLabelProvider(!isKRELicense ? 3 : 2));
        TableColumn tableColumnPurchase = null;
        if (!isKRELicense) {
            TableViewerColumn tableViewerColumnPurchase = new TableViewerColumn(pluginTableViewer, 16384);
            tableColumnPurchase = tableViewerColumnPurchase.getColumn();
            tableViewerColumnPurchase.setLabelProvider((CellLabelProvider)new PurchaseColumnLabelProvider(4));
        }
        TableViewerColumn tableViewerColumnError = new TableViewerColumn(pluginTableViewer, 16384);
        TableColumn tableColumnStatus = tableViewerColumnError.getColumn();
        tableColumnStatus.setText(GlobalStringConstants.STATUS);
        tableViewerColumnError.setLabelProvider((CellLabelProvider)new ErrorColumnLabelProvider(!isKRELicense ? 5 : 3));
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)tableColumnPluginName, (ColumnLayoutData)new ColumnWeightData(30, 40));
        if (tableColumnLicense != null) {
            tableLayout.setColumnData((Widget)tableColumnLicense, (ColumnLayoutData)new ColumnWeightData(15, 10));
        }
        tableLayout.setColumnData((Widget)tableColumnVersion, (ColumnLayoutData)new ColumnWeightData(10, 20));
        tableLayout.setColumnData((Widget)tableColumnReview, (ColumnLayoutData)new ColumnWeightData(10, 30));
        if (tableColumnPurchase != null) {
            tableLayout.setColumnData((Widget)tableColumnPurchase, (ColumnLayoutData)new ColumnWeightData(10, 40));
        }
        tableLayout.setColumnData((Widget)tableColumnStatus, (ColumnLayoutData)new ColumnWeightData(15, 140));
        tableComposite.setLayout((Layout)tableLayout);
        pluginTableViewer.setInput(this.results);
        Composite bottomComposite = new Composite(body, 0);
        bottomComposite.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        bottomComposite.setLayout((Layout)new GridLayout(2, false));
        Label lblUsername = new Label(bottomComposite, 0);
        lblUsername.setText(ApplicationContext.getInstance().getUserId());
        lblUsername.setLayoutData((Object)new GridData(16384, 128, true, false));
        Button btnClose = new Button(bottomComposite, 0);
        btnClose.setLayoutData((Object)new GridData(131072, 128, false, false));
        btnClose.setText(IDialogConstants.CLOSE_LABEL);
        btnClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReloadPluginsResultDialog.this.setReturnCode(1);
                ReloadPluginsResultDialog.this.close();
            }
        });
        return body;
    }

    private boolean shouldShowExpiryWarningMessage() {
        return this.results.stream().filter(r -> r.getPlugin().isOnline() && this.checkExpire(r.getPlugin().getOnlinePlugin())).findAny().isPresent();
    }

    private boolean checkExpire(KStorePlugin plugin) {
        return plugin.isExpired() || plugin.isTrial() && plugin.getRemainingDay() <= 14;
    }

    protected Control createButtonBar(Composite parent) {
        return parent;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(StringConstants.KStorePluginsDialog_DIA_TITLE);
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        return new Point(Math.max(800, initialSize.x), Math.max(300, initialSize.y));
    }

    protected boolean isResizable() {
        return true;
    }

    private KStoreApiKeyCredentials getCredential() {
        try {
            return RequireAuthorizationHandler.getApiKeyCredential();
        }
        catch (KStoreClientAuthException error) {
            LoggerSingleton.logError((Throwable)error);
            return null;
        }
    }

    private class ErrorColumnLabelProvider
    extends HyperLinkColumnLabelProvider<ReloadItem> {
        public ErrorColumnLabelProvider(int columnIndex) {
            super(columnIndex);
        }

        protected void handleMouseDown(MouseEvent e, ViewerCell cell) {
            ReloadItem reloadItem = (ReloadItem)cell.getElement();
            if (reloadItem.getException() != null) {
                Exception exception = reloadItem.getException();
                MultiStatusErrorDialog.showErrorDialog((String)"Failed to reload plugin", (String)exception.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)exception));
            }
        }

        protected Class<ReloadItem> getElementType() {
            return ReloadItem.class;
        }

        protected Image getImage(ReloadItem element) {
            return null;
        }

        protected String getText(ReloadItem element) {
            if (element.getException() != null) {
                if (element.getException() instanceof TrialExpiredException) {
                    return StringConstants.KStorePluginsDialog_LNK_TRIAL_EXPIRED;
                }
                return StringConstants.KStorePluginsDialog_LNK_ERROR;
            }
            return StringConstants.KStorePluginsDialog_LBL_SUCCESS;
        }

        public void update(ViewerCell cell) {
            super.update(cell);
            cell.setStyleRanges(new StyleRange[]{this.getStyleRange(cell)});
        }

        private StyleRange getStyleRange(ViewerCell cell) {
            Color color;
            boolean isWarning = StringUtils.equals((CharSequence)cell.getText(), (CharSequence)StringConstants.KStorePluginsDialog_LNK_TRIAL_EXPIRED);
            boolean isError = !StringUtils.equals((CharSequence)cell.getText(), (CharSequence)StringConstants.KStorePluginsDialog_LBL_SUCCESS);
            StyleRange hyperLinkStyle = new StyleRange();
            hyperLinkStyle.foreground = color = isWarning ? ColorUtil.getWarningForegroudColor() : (isError ? ColorUtil.getTextErrorColor() : ColorUtil.getTextSuccessfulColor());
            hyperLinkStyle.underline = isError;
            hyperLinkStyle.start = 0;
            hyperLinkStyle.length = cell.getText().length();
            return hyperLinkStyle;
        }
    }

    private class PluginNameColumnLabelProvider
    extends HyperLinkColumnLabelProvider<ReloadItem> {
        public PluginNameColumnLabelProvider(int columnIndex) {
            super(columnIndex);
        }

        protected void handleMouseDown(MouseEvent e, ViewerCell cell) {
            try {
                ReloadItem resultItem = (ReloadItem)cell.getElement();
                Plugin plugin = resultItem.getPlugin();
                if (plugin.isOnline()) {
                    KStoreApiKeyCredentials credentials = ReloadPluginsResultDialog.this.getCredential();
                    KStoreRestClient restClient = new KStoreRestClient((KStoreCredentials)credentials);
                    restClient.goToProductPage(plugin.getOnlinePlugin().getProduct());
                }
            }
            catch (KStoreClientException ex) {
                LoggerSingleton.logError((Throwable)ex);
            }
        }

        protected Class<ReloadItem> getElementType() {
            return ReloadItem.class;
        }

        protected Image getImage(ReloadItem element) {
            return null;
        }

        protected String getText(ReloadItem element) {
            return element.getPlugin().getName();
        }
    }

    private class PurchaseColumnLabelProvider
    extends HyperLinkColumnLabelProvider<ReloadItem> {
        public PurchaseColumnLabelProvider(int columnIndex) {
            super(columnIndex);
        }

        protected void handleMouseDown(MouseEvent e, ViewerCell cell) {
            try {
                ReloadItem resultItem = (ReloadItem)cell.getElement();
                Plugin plugin = resultItem.getPlugin();
                if (plugin.isOnline()) {
                    KStoreApiKeyCredentials credentials = ReloadPluginsResultDialog.this.getCredential();
                    KStoreRestClient restClient = new KStoreRestClient((KStoreCredentials)credentials);
                    restClient.goToProductPricingPage(plugin.getOnlinePlugin().getProduct());
                }
            }
            catch (KStoreClientException ex) {
                LoggerSingleton.logError((Throwable)ex);
            }
        }

        protected Class<ReloadItem> getElementType() {
            return ReloadItem.class;
        }

        protected Image getImage(ReloadItem element) {
            return null;
        }

        protected String getText(ReloadItem element) {
            KStorePlugin onlinePlugin;
            Plugin plugin = element.getPlugin();
            if (plugin.isOnline() && ((onlinePlugin = plugin.getOnlinePlugin()).isTrial() || onlinePlugin.isExpired())) {
                return StringConstants.KStorePluginsDialog_LNK_PURCHASE;
            }
            return "";
        }
    }

    private class ReviewColumnLabelProvider
    extends HyperLinkColumnLabelProvider<ReloadItem> {
        public ReviewColumnLabelProvider(int columnIndex) {
            super(columnIndex);
        }

        protected void handleMouseDown(MouseEvent e, ViewerCell cell) {
            try {
                ReloadItem resultItem = (ReloadItem)cell.getElement();
                Plugin plugin = resultItem.getPlugin();
                if (plugin.isOnline()) {
                    KStoreApiKeyCredentials credentials = ReloadPluginsResultDialog.this.getCredential();
                    KStoreRestClient restClient = new KStoreRestClient((KStoreCredentials)credentials);
                    restClient.goToProductReviewPage(plugin.getOnlinePlugin().getProduct());
                }
            }
            catch (KStoreClientException ex) {
                LoggerSingleton.logError((Throwable)ex);
            }
        }

        protected Class<ReloadItem> getElementType() {
            return ReloadItem.class;
        }

        protected Image getImage(ReloadItem element) {
            return null;
        }

        protected String getText(ReloadItem element) {
            Plugin plugin = element.getPlugin();
            if (plugin.isOnline()) {
                return StringConstants.KStorePluginsDialog_LNK_REVIEW;
            }
            return "";
        }
    }
}

