/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.util;

import com.kms.katalon.activation.dialog.AuthenRequestOptions;
import com.kms.katalon.activation.dialog.GitLoginDialog;
import com.kms.katalon.activation.dialog.ModernActivationDialog;
import com.kms.katalon.activation.dialog.RetryCloningSampleProjectDialog;
import com.kms.katalon.application.KatalonApplicationActivator;
import com.kms.katalon.application.constants.ApplicationMessageConstants;
import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.preference.ProjectSettingPreference;
import com.kms.katalon.application.userprofile.UserExperienceLevel;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.MachineUtil;
import com.kms.katalon.application.utils.ServerAPICommunicationUtil;
import com.kms.katalon.composer.components.dialogs.MessageDialogWithLink;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.helpers.DialogBuilder;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.helpers.AuthenticationController;
import com.kms.katalon.composer.project.dialog.OpenProjectDialog;
import com.kms.katalon.composer.project.handlers.GitHandler;
import com.kms.katalon.composer.project.sample.SampleRemoteProject;
import com.kms.katalon.composer.project.sample.SampleRemoteProjectProvider;
import com.kms.katalon.composer.quickstart.QuickStartDialogV2;
import com.kms.katalon.composer.quickstart.QuickStartPlatformDialog;
import com.kms.katalon.composer.tour.QuickStartTourType;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.ObjectUtil;
import com.kms.katalon.core.util.internal.NamingUtil;
import com.kms.katalon.dal.fileservice.manager.ProjectFileServiceManager;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.entity.project.QuickStartProjectType;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.GitRepositoryEntity;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.handler.AnalyticsAuthorizationHandler;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.license.models.CombinedAuthenticationToken;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.TourUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ComposerActivationInfoCollector
extends ActivationInfoCollector {
    private static SecureRandom random = new SecureRandom();
    private static final long RANDOM_MIN = 78364164096L;
    private static final long RANDOM_MAX = 2821109907455L;
    private static final String ANALYTICS_PROJECT = "AnalyticsProject";
    private static final String ANALYTICS_GIT = "Git";
    private static final String NOT_AUTHORIZED = "not authorized";
    private static final EnumMap<QuickStartProjectType, ProjectType> PROJECT_TYPE_MAP = new EnumMap(QuickStartProjectType.class);
    private static boolean isActivated;
    private static AuthenticationController.AuthenRequestedListener authenRequestedListener;

    static {
        PROJECT_TYPE_MAP.put(QuickStartProjectType.WEBUI, ProjectType.WEBUI);
        PROJECT_TYPE_MAP.put(QuickStartProjectType.MOBILE, ProjectType.MOBILE);
        PROJECT_TYPE_MAP.put(QuickStartProjectType.API, ProjectType.WEBSERVICE);
        PROJECT_TYPE_MAP.put(QuickStartProjectType.DESKTOP, ProjectType.DESKTOP);
        PROJECT_TYPE_MAP.put(QuickStartProjectType.BDD, ProjectType.GENERIC);
        authenRequestedListener = options -> UISynchronizeService.syncExec(() -> ComposerActivationInfoCollector.checkActivationDialog(options));
    }

    private ComposerActivationInfoCollector() {
    }

    public static boolean checkActivation(final boolean isStartup) throws InvocationTargetException, InterruptedException {
        UserProfile userProfile;
        if (isStartup) {
            ComposerActivationInfoCollector.setUpAuthentication();
        }
        Shell shell = Display.getCurrent().getActiveShell();
        new ProgressMonitorDialog(shell).run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (isStartup) {
                    monitor.beginTask(StringConstants.MSG_ACTIVATING, -1);
                } else {
                    monitor.beginTask(StringConstants.MSG_CLEANING, -1);
                    try {
                        ActivationInfoCollector.postEndSession();
                        monitor.setTaskName(StringConstants.MSG_RELEASING_LICENSE);
                        ActivationInfoCollector.releaseLicense();
                    }
                    catch (Exception e) {
                        LogUtil.logError((Throwable)e);
                    }
                    EventBrokerSingleton.getInstance().getEventBroker().post("ACTIVATION/DEACTIVATED", null);
                    ApplicationInfo.cleanAll();
                }
                LogUtil.logInfo((String)"Start checking and mark activated for GUI mode");
                isActivated = ActivationInfoCollector.checkAndMarkActivatedForGUIMode();
                LogUtil.logInfo((String)"End checking and mark activated for GUI mode");
                LogUtil.logInfo((String)MessageFormat.format(ApplicationMessageConstants.LICENSE_EXPIRATION_DATE, ActivationInfoCollector.getExpirationDate()));
                monitor.done();
            }
        });
        if (!isActivated) {
            Trackings.trackOpenFirstTime();
        }
        if (StringUtils.isEmpty((CharSequence)(userProfile = UserProfileHelper.getCurrentProfile()).getFirstTimeActivate())) {
            UserProfileHelper.updateUserProfiles();
        }
        if (!isActivated) {
            if (ComposerActivationInfoCollector.requestAuthen()) {
                ComposerActivationInfoCollector.showQuickStartDialogV2ForTheFirstTime();
                ComposerActivationInfoCollector.showOpenProjectDialog(shell);
                return true;
            }
            return false;
        }
        ComposerActivationInfoCollector.showQuickStartDialogV2ForTheFirstTime();
        ComposerActivationInfoCollector.showOpenProjectDialog(shell);
        return true;
    }

    private static void showOpenProjectDialog(Shell shell) {
        if (ApplicationInfo.isPlatformStudio()) {
            ProjectSettingPreference projectPreferences = new ProjectSettingPreference();
            try {
                List recentProjects = projectPreferences.getRecentProjects();
                if ((recentProjects == null || recentProjects.isEmpty()) && ProjectController.getInstance().getCurrentProject() == null) {
                    OpenProjectDialog dialog = new OpenProjectDialog(shell);
                    dialog.open();
                }
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    private static boolean requestAuthen() {
        return AuthenticationController.getInstance().requestAuthen();
    }

    private static void setUpAuthentication() {
        MachineUtil.getMachineId();
        ((TestOpsService)TestOpsService.getInstance().setAdminServer(ApplicationInfo.getAdminServer())).setTestOpsServer(ApplicationInfo.getTestOpsServer());
        ComposerActivationInfoCollector.setUpAuthenListener();
        TestOpsService.getInstance().onTokenRenewed(combinedToken -> ApplicationInfo.setAuthenticationInfo((CombinedAuthenticationToken)combinedToken));
    }

    private static void setUpAuthenListener() {
        AuthenticationController authenController = AuthenticationController.getInstance();
        authenController.offAuthenRequested(authenRequestedListener);
        authenController.onAuthenRequested(authenRequestedListener);
    }

    private static boolean checkActivationDialog(AuthenRequestOptions options) {
        Shell parentShell = (Shell)ObjectUtil.valueOrDefault((Object)(options != null ? options.getParentShell() : null), (Object)ShellManager.getMainShell());
        ModernActivationDialog activationDialog = new ModernActivationDialog(parentShell, options);
        return activationDialog.open() == 0;
    }

    private static void showQuickStartDialogV2ForTheFirstTime() {
        boolean isSkipQuickStart;
        boolean bl = isSkipQuickStart = StringUtils.equals((CharSequence)System.getProperty("skipQuickStart"), (CharSequence)Boolean.TRUE.toString()) || StringUtils.equals((CharSequence)System.getenv("skipQuickStart"), (CharSequence)Boolean.TRUE.toString());
        if (isSkipQuickStart) {
            UserProfile currentProfile = UserProfileHelper.getCurrentProfile();
            currentProfile.setExperienceLevel(UserExperienceLevel.EXPERIENCED);
            UserProfileHelper.saveProfile((UserProfile)currentProfile);
            return;
        }
        UserProfile currentProfile = UserProfileHelper.getCurrentProfile();
        if (currentProfile.isDoneQuickStart()) {
            return;
        }
        ProjectController.getInstance().setOpenning(true);
        if (ApplicationInfo.isPlatformStudio()) {
            AnalyticsProject selectedProject = new AnalyticsProject();
            try {
                List projectList = AnalyticsAuthorizationHandler.getProjectsList((TestOpsService)TestOpsService.getActiveInstance());
                if (projectList.size() == 0) {
                    Shell shell = Display.getCurrent().getActiveShell();
                    MessageDialogWithLink dialog = new MessageDialogWithLink(shell, GlobalMessageConstants.ERROR_TITLE, null, MessageConstants.MSG_NO_GIT_TESTOPS_PROJECT, 4, new String[]{"Go to TestOps", GlobalStringConstants.DIA_CLOSE}, 0);
                    switch (dialog.open()) {
                        case 0: {
                            String serverUrl = ApplicationInfo.getTestOpsServer();
                            Program.launch((String)serverUrl);
                            break;
                        }
                        default: {
                            dialog.close();
                        }
                    }
                    return;
                }
                boolean gitLinked = false;
                for (AnalyticsProject project : projectList) {
                    if (project.getGitRepositories().size() <= 0) continue;
                    gitLinked = true;
                    selectedProject = project;
                    break;
                }
                if (!gitLinked) {
                    new DialogBuilder().error().message(MessageConstants.MSG_EMPTY_GIT_REPO).title(GlobalMessageConstants.ERROR_TITLE).buttonBar(builder -> builder.gridHorizontalSpacing(10)).button(buttonBuilder -> buttonBuilder.text("Go to TestOps").onClick(event -> {
                        String serverUrl = ApplicationInfo.getTestOpsServer();
                        Program.launch((String)serverUrl);
                        ((Button)event.widget).getShell().close();
                    }).right()).button(buttonBuilder -> buttonBuilder.text(GlobalMessageConstants.CLOSE).onClick(event -> ((Button)event.widget).getShell().close()).width(80)).build().open();
                    return;
                }
            }
            catch (AnalyticsApiException e) {
                LoggerSingleton.logError((Throwable)e);
                MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)MessageConstants.MSG_UNABLE_TO_CREATE_FIRST_PROJECT, (String)e.getLocalizedMessage(), (Shell)ShellManager.getLastActiveAliveShell());
                return;
            }
            QuickStartPlatformDialog quickStartPlatformDialog = new QuickStartPlatformDialog(ShellManager.getMainShell());
            quickStartPlatformDialog.open();
            currentProfile.setExperienceLevel(quickStartPlatformDialog.getUserLevel());
            currentProfile.setPreferredTestingType(quickStartPlatformDialog.getProjectType());
            currentProfile.setGitUsername("");
            currentProfile.setGitPersonalAccessToken("");
            UserProfileHelper.saveProfile((UserProfile)currentProfile);
            if (!currentProfile.isDoneCreateFirstProject()) {
                try {
                    switch (quickStartPlatformDialog.getProjectType()) {
                        case WEBUI: 
                        case MOBILE: 
                        case API: 
                        case DESKTOP: {
                            ComposerActivationInfoCollector.quickCreateFirstPlatformProject(selectedProject, quickStartPlatformDialog.getProjectType());
                            break;
                        }
                    }
                }
                catch (Exception error) {
                    MultiStatusErrorDialog.showErrorDialog((Throwable)error, (String)MessageConstants.MSG_UNABLE_TO_CREATE_FIRST_PROJECT, (String)error.getLocalizedMessage(), (Shell)ShellManager.getLastActiveAliveShell());
                    return;
                }
            }
            currentProfile = UserProfileHelper.getCurrentProfile();
            currentProfile.setDoneQuickStart(true);
            UserProfileHelper.saveProfile((UserProfile)currentProfile);
        } else {
            QuickStartDialogV2 quickStartDialog = new QuickStartDialogV2(ShellManager.getMainShell());
            quickStartDialog.open();
            currentProfile.setExperienceLevel(quickStartDialog.getUserLevel());
            currentProfile.setPreferredTestingType(quickStartDialog.getProjectType());
            UserProfileHelper.saveProfile((UserProfile)currentProfile);
            if (currentProfile.isOldUser()) {
                currentProfile = UserProfileHelper.getCurrentProfile();
                currentProfile.setDoneQuickStart(true);
                UserProfileHelper.saveProfile((UserProfile)currentProfile);
                return;
            }
            if (!currentProfile.isDoneCreateFirstProject()) {
                try {
                    switch (quickStartDialog.getProjectType()) {
                        case WEBUI: 
                        case MOBILE: 
                        case API: 
                        case DESKTOP: {
                            currentProfile = UserProfileHelper.getCurrentProfile();
                            currentProfile.addCompletedTour(QuickStartTourType.CREATE_FIRST_PROJECT.name());
                            UserProfileHelper.saveProfile((UserProfile)currentProfile);
                            ComposerActivationInfoCollector.quickCreateFirstProject(quickStartDialog.getProjectType());
                            break;
                        }
                        case BDD: {
                            TourUtil.setIsUsingBDDSampleProject(true);
                            ComposerActivationInfoCollector.quickCreateFirstBDDSampleProject();
                            break;
                        }
                    }
                }
                catch (Exception error) {
                    MultiStatusErrorDialog.showErrorDialog((Throwable)error, (String)MessageConstants.MSG_UNABLE_TO_CREATE_FIRST_PROJECT, (String)error.getLocalizedMessage(), (Shell)ShellManager.getLastActiveAliveShell());
                    return;
                }
            }
            currentProfile = UserProfileHelper.getCurrentProfile();
            currentProfile.setDoneQuickStart(true);
            UserProfileHelper.saveProfile((UserProfile)currentProfile);
        }
    }

    private static void quickCreateFirstProject(QuickStartProjectType quickStartProjectType) throws Exception {
        ProjectController projectController = ProjectController.getInstance();
        String name = ComposerActivationInfoCollector.getFirstProjectName(quickStartProjectType);
        String location = GlobalStringConstants.DEFAULT_PROJECT_LOCATION;
        ProjectEntity newProject = projectController.addNewProject(name, "", location, true, true);
        newProject.setType(ComposerActivationInfoCollector.convertToProjectType(quickStartProjectType));
        ProjectController.getInstance().updateProject(newProject);
        ProjectController.getInstance().openProjectForUI(newProject.getLocation(), false, null);
        EventBrokerSingleton.getInstance().getEventBroker().post("PROJECT/OPEN", (Object)newProject.getId());
        EventBrokerSingleton.getInstance().getEventBroker().post("ANALYTIC/AUTO_ENABLE_INTEGRATION", null);
    }

    private static void quickCreateFirstPlatformProject(AnalyticsProject project, QuickStartProjectType quickStartProjectType) throws Exception {
        ProjectEntity newProject = new ProjectEntity();
        String location = GlobalStringConstants.DEFAULT_PROJECT_LOCATION;
        HashMap<String, Object> options = new HashMap<String, Object>();
        GitRepositoryEntity gitRepo = (GitRepositoryEntity)project.getGitRepositories().get(0);
        StringBuilder errorMessage = new StringBuilder();
        File directory = ComposerActivationInfoCollector.createPlatformProjectFolder(location, gitRepo.getName());
        newProject = GitHandler.cloneGitProject((String)gitRepo.getRepository(), (String)gitRepo.getBranch(), (File)directory, (StringBuilder)errorMessage);
        boolean failedCloneProject = false;
        while (newProject == null && errorMessage.toString().contains(NOT_AUTHORIZED)) {
            GitLoginDialog gitLoginDiaLog = new GitLoginDialog(Display.getCurrent().getActiveShell(), gitRepo, true);
            Trackings.trackGitLogin();
            if (gitLoginDiaLog.open() != 0) {
                failedCloneProject = true;
                break;
            }
            errorMessage = new StringBuilder();
            try {
                FileUtils.forceDelete((File)directory);
                directory.mkdirs();
            }
            catch (IOException exception) {
                LoggerSingleton.logError((Throwable)exception);
            }
            newProject = GitHandler.cloneGitProject((String)gitRepo.getRepository(), (String)gitRepo.getBranch(), (File)directory, (StringBuilder)errorMessage);
        }
        if (failedCloneProject) {
            new DialogBuilder().error().message(MessageConstants.MSG_CLONE_PROJECT_FAILED).title(GlobalMessageConstants.ERROR_TITLE).buttonBar(builder -> builder.gridHorizontalSpacing(10)).button(buttonBuilder -> buttonBuilder.text(GlobalMessageConstants.CLOSE).onClick(event -> ((Button)event.widget).getShell().close()).width(80)).build().open();
            Trackings.trackOpenProjectFailed();
            return;
        }
        if (newProject == null) {
            try {
                newProject = ProjectController.getInstance().addNewTestOpsProjectWithoutNewFolder(gitRepo.getName(), "", directory.getPath());
                TimeUnit.SECONDS.sleep(1L);
                EventBrokerSingleton.getInstance().getEventBroker().send("PROJECT/CREATED", (Object)newProject);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GlobalMessageConstants.ERROR, (String)e.getMessage());
                LoggerSingleton.logError((Throwable)e);
                Trackings.trackOpenProjectFailed();
                return;
            }
        }
        options.put(ANALYTICS_PROJECT, project);
        options.put(ANALYTICS_GIT, gitRepo);
        if (newProject != null) {
            ProjectFileServiceManager.updateProjectLocation((String)newProject.getId());
            newProject.setType(ComposerActivationInfoCollector.convertToProjectType(quickStartProjectType));
            ProjectController.getInstance().updateProject(newProject);
            ProjectController.getInstance().openProjectForUI(newProject.getLocation(), false, null);
            String projectId = newProject.getId();
            UISynchronizeService.syncExec(() -> {
                EventBrokerSingleton.getInstance().getEventBroker().post("PROJECT/OPEN", (Object)projectId);
                Trackings.trackOpenProjectSucceeded();
                KatalonApplicationActivator.getTestOpsConfiguration().testOpsPlatformIntergration(options);
            });
        }
    }

    public static boolean quickCreateFirstBDDSampleProject() throws Exception {
        List sampleProjects = null;
        Optional<SampleRemoteProject> sampleBDDProject = null;
        if (!ComposerActivationInfoCollector.checkInternetConection("http://download.katalon.com/resources/sample_projects.json")) {
            return false;
        }
        sampleProjects = SampleRemoteProjectProvider.getSampleProjects();
        sampleBDDProject = sampleProjects.stream().filter(project -> project.getSourceUrl().contains("calculator-bdd-tests")).findFirst();
        if (!sampleBDDProject.isPresent()) {
            ComposerActivationInfoCollector.quickCreateFirstProject(QuickStartProjectType.BDD);
            return true;
        }
        ProjectEntity projectEntity = new ProjectEntity();
        projectEntity.setName(ComposerActivationInfoCollector.getFirstProjectName(QuickStartProjectType.BDD));
        projectEntity.setFolderLocation(new File(GlobalStringConstants.DEFAULT_PROJECT_LOCATION, projectEntity.getName()).getAbsolutePath());
        projectEntity.setType(ProjectType.GENERIC);
        ProjectController.getInstance().setOpenning(true);
        if (!ComposerActivationInfoCollector.checkInternetConection(sampleBDDProject.get().getSourceUrl())) {
            return false;
        }
        boolean isAutoIntegrate = true;
        EventBrokerSingleton.getInstance().getEventBroker().send("GIT/CLONE_REMOTE_PROJECT", (Object)new Object[]{sampleBDDProject.get(), projectEntity, isAutoIntegrate});
        return true;
    }

    private static boolean checkInternetConection(String urlString) {
        NullPointerException e = null;
        String pageContent = "";
        try {
            pageContent = ServerAPICommunicationUtil.getInformation((String)urlString);
        }
        catch (NullPointerException ex) {
            e = ex;
        }
        if (pageContent == null || e != null) {
            RetryCloningSampleProjectDialog dialog = new RetryCloningSampleProjectDialog(ShellManager.getMainShell());
            int rs = dialog.open();
            if (rs == RetryCloningSampleProjectDialog.RETRY) {
                return ComposerActivationInfoCollector.checkInternetConection(urlString);
            }
            return false;
        }
        return true;
    }

    private static String getFirstProjectName(QuickStartProjectType testingType) {
        String projectName = ComposerActivationInfoCollector.getProjectNameByType(testingType);
        File firstProjectFolder = new File(GlobalStringConstants.DEFAULT_PROJECT_LOCATION);
        firstProjectFolder.mkdirs();
        return NamingUtil.getUniqueFileName((String)projectName, (String)firstProjectFolder.getAbsolutePath());
    }

    private static String getProjectNameByType(QuickStartProjectType testingType) {
        switch (testingType) {
            case WEBUI: {
                return "My First Web UI Project";
            }
            case MOBILE: {
                return "My First Mobile Project";
            }
            case API: {
                return "My First API Project";
            }
            case DESKTOP: {
                return "My First Desktop Project";
            }
            case BDD: {
                return "My First BDD Project";
            }
        }
        return null;
    }

    private static ProjectType convertToProjectType(QuickStartProjectType quickStartProjectType) {
        return PROJECT_TYPE_MAP.get(quickStartProjectType);
    }

    public static String genRequestActivationInfo() {
        String requestCodePropName = "activatedRequestCode";
        String requestActivationCode = ApplicationInfo.getAppProperty((String)requestCodePropName);
        if (requestActivationCode == null || requestActivationCode.trim().length() < 1) {
            requestActivationCode = ComposerActivationInfoCollector.genRequestActivateOfflineCode();
            ApplicationInfo.setAppProperty((String)requestCodePropName, (String)requestActivationCode, (boolean)true);
        }
        return requestActivationCode;
    }

    private static String genRequestActivateOfflineCode() {
        long num = 78364164096L + (long)(2.7427458E12f * random.nextFloat());
        return Long.toString(num, 36).toUpperCase();
    }

    private static File createPlatformProjectFolder(String location, String projectName) {
        int number = 1;
        File directory = new File(String.valueOf(location) + File.separator + projectName);
        while (directory.exists()) {
            directory = new File(String.valueOf(location) + File.separator + projectName + " (" + number + ")");
            ++number;
        }
        directory.mkdirs();
        return directory;
    }
}

