/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.util;

import com.kms.katalon.addons.QuickStartController;
import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.tour.QuickStartTourType;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.entity.project.QuickStartProjectType;
import java.util.EnumMap;
import java.util.List;

public class TourUtil {
    private static boolean isUsingBDDSample = false;
    private static final EnumMap<ProjectType, QuickStartTourType> QUICK_START_TYPE_MAP = new EnumMap(ProjectType.class);

    static {
        QUICK_START_TYPE_MAP.put(ProjectType.WEBUI, QuickStartTourType.WEB_TESTING);
        QUICK_START_TYPE_MAP.put(ProjectType.WEBSERVICE, QuickStartTourType.API_TESTING);
        QUICK_START_TYPE_MAP.put(ProjectType.MOBILE, QuickStartTourType.MOBILE_TESTING);
        QUICK_START_TYPE_MAP.put(ProjectType.DESKTOP, QuickStartTourType.DESKTOP_TESTING);
        QUICK_START_TYPE_MAP.put(ProjectType.GENERIC, QuickStartTourType.WEB_TESTING);
    }

    public static QuickStartTourType getCurProjectTourType() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project != null) {
            ProjectType projectType = project.getType();
            return QUICK_START_TYPE_MAP.get(projectType);
        }
        return QuickStartTourType.CREATE_FIRST_PROJECT;
    }

    public static QuickStartTourType getNextTour() {
        QuickStartTourType targetTour = QuickStartTourType.CREATE_FIRST_PROJECT;
        UserProfile curProfile = UserProfileHelper.getCurrentProfile();
        QuickStartTourType projectTour = QuickStartController.getCurProjectTourType();
        List completedTours = curProfile.getCompletedTours();
        if (completedTours.contains(QuickStartTourType.CREATE_FIRST_PROJECT.name()) && (targetTour = QuickStartController.getCurProjectTourType()).equals((Object)QuickStartTourType.CREATE_FIRST_PROJECT)) {
            targetTour = QuickStartTourType.WEB_TESTING;
        }
        if (!projectTour.equals((Object)QuickStartTourType.CREATE_FIRST_PROJECT) && completedTours.contains(projectTour.name())) {
            targetTour = QuickStartTourType.TEST_PLANNING;
        }
        if (completedTours.contains(QuickStartTourType.TEST_PLANNING.name())) {
            targetTour = QuickStartTourType.ANALYZE_TEST_ACTIVITIES;
        }
        if (completedTours.contains(QuickStartTourType.ANALYZE_TEST_ACTIVITIES.name())) {
            targetTour = QuickStartTourType.TEST_CLOUD_TESTING;
        }
        if (completedTours.contains(QuickStartTourType.TEST_CLOUD_TESTING.name())) {
            targetTour = QuickStartTourType.SET_UP_KRE;
        }
        return targetTour;
    }

    public static QuickStartTourType getProjectTourType(QuickStartProjectType quickStartProjectType) {
        switch (quickStartProjectType) {
            case WEBUI: {
                return QuickStartTourType.WEB_TESTING;
            }
            case API: {
                return QuickStartTourType.API_TESTING;
            }
            case MOBILE: {
                return QuickStartTourType.MOBILE_TESTING;
            }
            case DESKTOP: {
                return QuickStartTourType.DESKTOP_TESTING;
            }
            case BDD: {
                return QuickStartTourType.BDD_TESTING;
            }
        }
        return QuickStartTourType.WEB_TESTING;
    }

    public static boolean isUsingBDDSampleProject() {
        return isUsingBDDSample;
    }

    public static void setIsUsingBDDSampleProject(boolean isUsingBDD) {
        isUsingBDDSample = isUsingBDD;
    }
}

