/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver.handlers;

import com.kms.katalon.application.KatalonApplicationActivator;
import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentFinder;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.composer.handlers.CheckForUpdatesHandler;
import com.kms.katalon.composer.handlers.OpenQuickStartPageHandler;
import com.kms.katalon.composer.helpers.PartHelper;
import com.kms.katalon.composer.tour.APITestingTourHandler;
import com.kms.katalon.composer.tour.AnalyzeTestingTourHandler;
import com.kms.katalon.composer.tour.BDDTestingDefineStepsTourHandler;
import com.kms.katalon.composer.tour.BDDTestingRunTourHandler;
import com.kms.katalon.composer.tour.CreateAFeatureFileTourHandler;
import com.kms.katalon.composer.tour.DesktopTestingTourHandler;
import com.kms.katalon.composer.tour.GenericTestingTourHandler;
import com.kms.katalon.composer.tour.KatalonRuntimeEngineTourHandler;
import com.kms.katalon.composer.tour.KatalonWorkspaceTourHandler;
import com.kms.katalon.composer.tour.LearnMoreAboutCICDPipelineHandler;
import com.kms.katalon.composer.tour.MobileTestingTourHandler;
import com.kms.katalon.composer.tour.OpenFirstProjectTourHandler;
import com.kms.katalon.composer.tour.QuickStartTourType;
import com.kms.katalon.composer.tour.TestCloudTestingTourHandler;
import com.kms.katalon.composer.tour.TestPlanningTourHandler;
import com.kms.katalon.composer.tour.TourAction;
import com.kms.katalon.composer.tour.WebTestingTourHandler;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeam;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.webserver.CustomHttpHandler;
import com.kms.katalon.webserver.CustomRequest;
import com.kms.katalon.webserver.types.WebViewAction;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;

public class KatalonActionHandler
extends CustomHttpHandler {
    private static final String REPLAY_QUICK_START = "Replay Quick Start";
    private static final String CONFIG_INTEGRATION_OPTION_FOR_FIRST_QUICK_START = "isForFirstQuickStart";
    private static String testSuiteName = "";
    private TestPlanningTourHandler planningTourHandler;

    @Override
    public void customHandle(CustomRequest req) throws IOException {
        String rawAction = req.query("action");
        if (StringUtils.isNotBlank((CharSequence)rawAction)) {
            WebViewAction action = WebViewAction.valueOf(rawAction);
            block1 : switch (action) {
                case START_TOUR: {
                    UISynchronizeService.syncExec(() -> {
                        Shell quickStartOverviewShell = ComponentFinder.findShell((String)"QuickStartTourOverview");
                        DialogUtil.close((Shell)quickStartOverviewShell);
                    });
                    QuickStartTourType type = QuickStartTourType.valueOf(req.query("id"));
                    Trackings.trackTourAction((String)type.name(), (String)TourAction.START.name());
                    switch (type) {
                        case SKIP_TOUR: {
                            UISynchronizeService.asyncExec(() -> {
                                Shell quickStartOverviewShell = ComponentFinder.findShell((String)"QuickStartTourOverview");
                                DialogUtil.close((Shell)quickStartOverviewShell);
                            });
                            this.setDoneFirstQuickStartTour();
                            break block1;
                        }
                        case KATALON_WORKSPACE: {
                            new KatalonWorkspaceTourHandler().execute();
                            break block1;
                        }
                        case CREATE_FIRST_PROJECT: {
                            try {
                                new OpenFirstProjectTourHandler().execute();
                            }
                            catch (Exception e) {
                                LoggerSingleton.logError((Throwable)e);
                            }
                            break block1;
                        }
                        case WEB_TESTING: {
                            if (!this.openDocLinkWhenNotOpenProject(MessageConstants.FIRST_TEST_CASE_DOCS_LINK)) break block1;
                            new WebTestingTourHandler().execute();
                            break block1;
                        }
                        case API_TESTING: {
                            if (!this.openDocLinkWhenNotOpenProject(MessageConstants.FIRST_TEST_CASE_DOCS_LINK)) break block1;
                            new APITestingTourHandler().execute();
                            break block1;
                        }
                        case MOBILE_TESTING: {
                            if (!this.openDocLinkWhenNotOpenProject(MessageConstants.FIRST_TEST_CASE_DOCS_LINK)) break block1;
                            new MobileTestingTourHandler().execute();
                            break block1;
                        }
                        case DESKTOP_TESTING: {
                            if (!this.openDocLinkWhenNotOpenProject(MessageConstants.FIRST_TEST_CASE_DOCS_LINK)) break block1;
                            new DesktopTestingTourHandler().execute();
                            break block1;
                        }
                        case GENERIC_TESTING: {
                            if (!this.openDocLinkWhenNotOpenProject(MessageConstants.FIRST_TEST_CASE_DOCS_LINK)) break block1;
                            new GenericTestingTourHandler().execute();
                            break block1;
                        }
                        case BDD_TESTING_STEP_DEFINITION: {
                            new BDDTestingDefineStepsTourHandler().execute();
                            break block1;
                        }
                        case TEST_PLANNING: {
                            if (!this.openDocLinkWhenNotOpenProject(MessageConstants.FIRST_TEST_SUITE_DOCS_LINK)) break block1;
                            this.planningTourHandler = new TestPlanningTourHandler();
                            this.planningTourHandler.execute();
                            break block1;
                        }
                        case ANALYZE_TEST_ACTIVITIES: {
                            if (!this.openDocLinkWhenNotOpenProject(MessageConstants.ANALYZE_TEST_DOCS_LINK)) break block1;
                            new AnalyzeTestingTourHandler().execute();
                            break block1;
                        }
                        case TEST_CLOUD_TESTING: {
                            if (!this.openDocLinkWhenNotOpenProject(MessageConstants.TEST_CLOUD_DOCS_LINK)) break block1;
                            new TestCloudTestingTourHandler().execute();
                            break block1;
                        }
                        case BDD_TESTING_FEATURE_FILE: {
                            new CreateAFeatureFileTourHandler().execute();
                            break block1;
                        }
                        case BDD_TESTING_ADDING_TO_TEST_CASE: {
                            new BDDTestingRunTourHandler().execute();
                            break block1;
                        }
                        case SET_UP_KRE: {
                            if (!this.openDocLinkWhenNotOpenProject(MessageConstants.LEARN_KRE_DOCS_LINK)) break block1;
                            if (this.planningTourHandler != null) {
                                testSuiteName = this.planningTourHandler.getTestSuiteName();
                            }
                            UISynchronizeService.asyncExec(() -> new KatalonRuntimeEngineTourHandler(testSuiteName).execute());
                            break block1;
                        }
                    }
                    break;
                }
                case CHECK_FOR_UPDATE: {
                    new CheckForUpdatesHandler().checkForUpdate(false);
                    break;
                }
                case REVIEW_BEST_PRACTICE: {
                    String bestPracticeUrl = req.query("url");
                    String rawBestPracticeReview = req.query("review");
                    boolean bestPracticeReview = Boolean.parseBoolean(rawBestPracticeReview);
                    UserProfile curUser = UserProfileHelper.getCurrentProfile();
                    curUser.addBestPracticeReview(bestPracticeUrl, bestPracticeReview);
                    UserProfileHelper.saveProfile((UserProfile)curUser);
                    break;
                }
                case I_GOT_IT_BTN_CLICKED: {
                    Trackings.trackTourStep((String)QuickStartTourType.SET_UP_KRE.name(), (String)"i_got_it_clicked");
                    break;
                }
                case SEND_STUDIOASSIST_FEEDBACK: {
                    this.trackStudioAssistFeedback(req);
                    this.closeFeedbackDialogAfterDelay();
                    break;
                }
                case LEARN_MORE_ABOUT_CI_CD: {
                    new LearnMoreAboutCICDPipelineHandler().execute();
                    break;
                }
                case OPEN_STUDIO_WALKTHROUGH: {
                    this.handleOnClickStudioWalkthrough();
                    break;
                }
                case OPEN_PLATFORM_WALKTHROUGH: {
                    this.handleOnClickPlatformWalkthrough();
                    break;
                }
                case INTEGRATE_WITH_PLATFORM: {
                    this.openIntegrateWithPlatform();
                    break;
                }
            }
        }
        req.end();
    }

    private void trackStudioAssistFeedback(CustomRequest request) {
        Map<String, Object> object = request.getRequestObject();
        Trackings.trackStudioAssistFeedback((int)((Integer)object.get("numOfStars")), (String)((String)object.get("feedback")));
    }

    private void closeFeedbackDialogAfterDelay() {
        UISynchronizeService.asyncExec(() -> {
            Shell quickStartOverviewShell = ComponentFinder.findShell((String)"Share Your Feedback");
            UITimeUtil.setTimeout(() -> DialogUtil.close((Shell)quickStartOverviewShell), (long)3000L);
        });
    }

    private void enableTestOpsIntegration() {
        try {
            if (!ApplicationInfo.isPlatformStudio()) {
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put(CONFIG_INTEGRATION_OPTION_FOR_FIRST_QUICK_START, true);
                KatalonApplicationActivator.getTestOpsConfiguration().testOpsQuickIntergration(options);
            }
        }
        catch (Exception exception) {}
    }

    private void setDoneFirstQuickStartTour() {
        UserProfile userProfile = UserProfileHelper.getCurrentProfile();
        if (!userProfile.isDoneFirstQuickStartTour() && userProfile.isNewUser()) {
            userProfile.setDoneFirstQuickStartTour(true);
            UserProfileHelper.saveProfile((UserProfile)userProfile);
        } else {
            LoggerSingleton.logInfo((String)REPLAY_QUICK_START);
        }
    }

    private boolean openDocLinkWhenNotOpenProject(String docLink) {
        if (ProjectController.getInstance().getCurrentProject() != null) {
            return true;
        }
        Program.launch((String)docLink);
        return false;
    }

    private void handleOnClickStudioWalkthrough() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project != null) {
            UISynchronizeService.asyncExec(() -> new OpenQuickStartPageHandler().execute(PartHelper.getPartService()));
        } else {
            Program.launch((String)MessageConstants.LINK_OPEN_STUDIO_WALKTHROUGHS_DOCS);
        }
    }

    private void handleOnClickPlatformWalkthrough() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        String url = ApplicationInfo.getTestOpsServer();
        AnalyticsSettingStore store = AnalyticsSettingStore.getStore();
        if (project != null && store != null && store.isIntegrationEnabled()) {
            AnalyticsTeam team = store.getTeam();
            AnalyticsProject platformProject = store.getProject();
            if (team != null && platformProject != null) {
                String patternUrl = String.valueOf(url) + "/team/{0}/project/{1}";
                url = MessageFormat.format(patternUrl, String.valueOf(team.getId()), String.valueOf(platformProject.getId()));
            }
        }
        Program.launch((String)url);
    }

    private void openIntegrateWithPlatform() {
        KatalonApplicationActivator.getTestOpsConfiguration().quickIntegrateWithPlatform();
    }
}

