/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver.handlers;

import com.kms.katalon.application.KatalonApplicationActivator;
import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.composer.parts.QuickStartPart;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.ApplicationEdition;
import com.kms.katalon.core.util.JsonBuilder;
import com.kms.katalon.entity.integration.analytics.AnalyticsOrganization;
import com.kms.katalon.integration.analytics.constants.IntegrationAnalyticsMessages;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeam;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import com.kms.katalon.license.models.LicenseType;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.webserver.CustomHttpHandler;
import com.kms.katalon.webserver.CustomRequest;
import com.kms.katalon.webserver.types.KatalonInfo;
import com.kms.katalon.webserver.types.ProjectConfiguration;
import com.kms.katalon.webview.util.WebviewLicenseUtil;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.text.ParseException;

public class KatalonInfoHandler
extends CustomHttpHandler {
    @Override
    public void customHandle(CustomRequest req) throws IOException {
        String rawRequestedInfo = req.query("info");
        KatalonInfo requestedInfo = KatalonInfo.valueOf(rawRequestedInfo);
        switch (requestedInfo) {
            case TRIAL_STATUS: {
                req.send(ApplicationContext.getInstance().getExpirationTrial());
                break;
            }
            case VERSION: {
                req.send(this.getVersion());
                break;
            }
            case LICENSE_TYPE: {
                req.send(this.getLicenseType());
                break;
            }
            case BUILD_NUMBER: {
                req.send(this.getBuildNumber());
                break;
            }
            case USER_PROFILE: {
                req.send(UserProfileHelper.getCurrentProfile());
                break;
            }
            case PROJECT_CONFIGURATION: {
                req.send(this.getProjectConfiguration(req));
                break;
            }
            case LICENSE_EXPIRATION_DATE: {
                req.send(this.getLicenseExpirationDate());
                break;
            }
            case STUDIO_WALKTHROUGH: {
                req.send(this.getStudioWalkthrough());
                break;
            }
            case IS_OPENED_PROJECT: {
                req.send(this.isOpenedProject());
                break;
            }
            case IS_ON_PREM_ACTIVATION: {
                req.send(TestOpsService.getInstance().isOnPremUser());
                break;
            }
            case KATALON_EDITION: {
                req.send(ApplicationEdition.get().name());
            }
        }
        req.end();
    }

    private String getVersion() {
        return ApplicationInfo.versionNo();
    }

    private int getBuildNumber() {
        return VersionUtil.getCurrentVersion().getBuildNumber();
    }

    private String getLicenseType() {
        return ActivationInfoCollector.getLicenseType().name();
    }

    private String getLicenseExpirationDate() {
        try {
            if (ActivationInfoCollector.getLicenseType() == LicenseType.ENTERPRISE) {
                return WebviewLicenseUtil.getLicenseExpirationDate();
            }
        }
        catch (AnalyticsApiException | IOException | GeneralSecurityException | ParseException exception) {
            if (exception instanceof AnalyticsApiException) {
                try {
                    String message = KatalonApplicationActivator.getFeatureActivator().getTestOpsMessage(exception.getMessage());
                    LogUtil.logError((String)MessageFormat.format(IntegrationAnalyticsMessages.MSG_ERROR_WITH_REASON, message));
                }
                catch (Exception exception2) {
                    LogUtil.logError((Throwable)exception);
                }
            }
            LogUtil.logError((Throwable)exception);
        }
        return null;
    }

    private ProjectConfiguration getProjectConfiguration(CustomRequest req) {
        ProjectConfiguration projectConfiguration = new ProjectConfiguration();
        AnalyticsSettingStore analyticsSettingStore = AnalyticsSettingStore.getStore();
        boolean isIntegrationEnabled = false;
        boolean isInKsProject = false;
        ProjectConfiguration.TestOpsProject testOpsProject = null;
        String testOpsServerUrl = null;
        if (analyticsSettingStore != null) {
            isInKsProject = true;
            isIntegrationEnabled = analyticsSettingStore.isIntegrationEnabled();
            if (isIntegrationEnabled) {
                AnalyticsTeam analyticsTeam;
                AnalyticsOrganization analyticsOrganization;
                testOpsProject = new ProjectConfiguration.TestOpsProject();
                AnalyticsProject analyticsProject = analyticsSettingStore.getProject();
                if (analyticsProject != null) {
                    testOpsProject.setId(analyticsProject.getId());
                    testOpsProject.setName(analyticsProject.getName());
                }
                if ((analyticsOrganization = analyticsSettingStore.getOrganization()) != null) {
                    testOpsProject.setOrganizationId(analyticsOrganization.getId());
                    testOpsProject.setOrganizationName(analyticsOrganization.getName());
                }
                if ((analyticsTeam = analyticsSettingStore.getTeam()) != null) {
                    testOpsProject.setTeamId(analyticsTeam.getId());
                    testOpsProject.setTeamName(analyticsTeam.getName());
                }
            }
            testOpsServerUrl = TestOpsService.getActiveInstance().getDetectedTestOpsServer();
        }
        projectConfiguration.setTestOpsProject(testOpsProject);
        projectConfiguration.setTestOpsServerUrl(testOpsServerUrl);
        projectConfiguration.setIntegrationEnabled(isIntegrationEnabled);
        projectConfiguration.setInKsProject(isInKsProject);
        return projectConfiguration;
    }

    private String getStudioWalkthrough() {
        JsonBuilder jsonBuilder = JsonBuilder.object();
        jsonBuilder.property("tourType", (Object)QuickStartPart.getCurrentQuickStartTourType());
        jsonBuilder.property("completedTours", (Object)UserProfileHelper.getCurrentProfile().getCompletedTours());
        return jsonBuilder.toJson();
    }

    private boolean isOpenedProject() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }
}

