/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver.handlers;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.feature.TestOpsMessageError;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.providers.FeatureFlagService;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.webserver.CustomHttpHandler;
import com.kms.katalon.webserver.CustomRequest;
import com.kms.katalon.webserver.types.TestOpsSearchRequest;
import java.io.IOException;

public class TestOpsProjectInfoHandler
extends CustomHttpHandler {
    @Override
    public void customHandle(CustomRequest req) throws IOException {
        String rawRequestedInfo = req.query("info");
        TestOpsSearchRequest requestedInfo = TestOpsSearchRequest.valueOf(rawRequestedInfo);
        TestOpsService testOpsService = TestOpsService.getActiveInstance();
        AnalyticsSettingStore settingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        AnalyticsProject project = settingStore.getProject();
        try {
            FeatureFlagService.getInstance().checkKsOnboardingEnabled();
            switch (requestedInfo) {
                case GET_3_LATEST_EXECUTIONS: {
                    req.send(testOpsService.getCompletedExecutions(project.getId(), 3));
                    break;
                }
                case GET_PROJECT_STATISTICS_IN_LAST_7_DAYS: {
                    req.send(testOpsService.getProjectStatisticsInLast7Days(project.getId()));
                    break;
                }
                case GET_TOTAL_EXECUTIONS_STATISTICS_IN_LAST_7_DAYS: {
                    req.send(testOpsService.getTotalExecutionsStatistics(project.getId()));
                    break;
                }
                case GET_6_LATEST_EXECUTIONS_TEST_SUITE: {
                    String testSuitePath = req.query("testSuitePath");
                    String testSuiteName = req.query("testSuiteName");
                    if (testSuitePath == null || testSuiteName == null) break;
                    req.send(testOpsService.getCompletedExecutionTestSuite(project.getId(), testSuitePath, testSuiteName, 6));
                    break;
                }
            }
            req.end();
        }
        catch (Exception error) {
            LogUtil.logError((Throwable)error);
            TestOpsMessageError testOpsMessageError = new TestOpsMessageError();
            testOpsMessageError.setMessage(error.getMessage());
            testOpsMessageError.setException(error);
            testOpsMessageError.setHasError(true);
            req.send(testOpsMessageError);
        }
    }
}

