/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.plugin.smart_xpath.part.composites;

import com.katalon.platform.ui.viewer.HyperLinkColumnLabelProvider;
import com.katalon.plugin.smart_xpath.constant.SmartXPathMessageConstants;
import com.katalon.plugin.smart_xpath.entity.BrokenTestObject;
import com.katalon.plugin.smart_xpath.part.provider.ApproveCheckBoxColumnEditingSupport;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.entity.project.ProjectEntity;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class BrokenTestObjectsTableComposite
extends Composite {
    private final int SCREENSHOT_COLUMN_INDEX = 4;
    private final int APRROVE_COLUMN_INDEX = 5;
    private ProjectEntity project;
    private boolean acceptAll = false;
    private TableColumn cApproveNewLocator;
    private TableViewer tbViewer;
    private TableColumnLayout tableColumnLayout;
    private Table table;

    public ProjectEntity getProject() {
        return this.project;
    }

    public void setProject(ProjectEntity project) {
        this.project = project;
    }

    public BrokenTestObjectsTableComposite(Composite parent, int style) {
        super(parent, style);
        this.createContents(this);
    }

    private void createContents(Composite container) {
        GridData ldTableComposite = new GridData(4, 4, true, true);
        ldTableComposite.widthHint = 1200;
        ldTableComposite.heightHint = 380;
        container.setLayoutData((Object)ldTableComposite);
        this.tableColumnLayout = new TableColumnLayout();
        container.setLayout((Layout)this.tableColumnLayout);
        this.tbViewer = new TableViewer(container, 67586);
        this.createColumns();
        this.tbViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.table = this.tbViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                if (event.index == 5) {
                    BrokenTestObject data = (BrokenTestObject)((TableItem)event.item).getData();
                    Image tmpImage = BrokenTestObjectsTableComposite.this.getCheckboxSymbol(data.getApproved());
                    int tmpX = tmpImage.getBounds().x + 5;
                    int tmpY = tmpImage.getBounds().y;
                    tmpX = tmpX <= 0 ? event.x : (tmpX += event.x);
                    tmpY = tmpY <= 0 ? event.y : (tmpY += event.y);
                    event.gc.drawImage(tmpImage, tmpX, tmpY);
                }
            }
        });
    }

    private void createColumns() {
        TableViewerColumn colObjectId = new TableViewerColumn(this.tbViewer, 0);
        colObjectId.getColumn().setText(SmartXPathMessageConstants.LBL_COL_TEST_OBJECT_ID);
        colObjectId.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String testObjectId = ((BrokenTestObject)element).getTestObjectId();
                return testObjectId;
            }
        });
        TableViewerColumn colBrokenLocator = new TableViewerColumn(this.tbViewer, 0);
        colBrokenLocator.getColumn().setText(SmartXPathMessageConstants.LBL_COL_BROKEN_LOCATOR);
        colBrokenLocator.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                BrokenTestObject brokenTestObject = (BrokenTestObject)element;
                String brokenLocator = MessageFormat.format("{0}: {1}", brokenTestObject.getBrokenLocatorMethod().getName(), brokenTestObject.getBrokenLocator());
                return brokenLocator;
            }
        });
        TableViewerColumn colProposedLocator = new TableViewerColumn(this.tbViewer, 0);
        colProposedLocator.getColumn().setText(SmartXPathMessageConstants.LBL_COL_PROPOSED_LOCATOR);
        colProposedLocator.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                BrokenTestObject brokenTestObject = (BrokenTestObject)element;
                String proposedLocator = MessageFormat.format("{0}: {1}", brokenTestObject.getProposedLocatorMethod().getName(), brokenTestObject.getProposedLocator());
                return proposedLocator;
            }
        });
        TableViewerColumn colRecoveredBy = new TableViewerColumn(this.tbViewer, 0);
        colRecoveredBy.getColumn().setText(SmartXPathMessageConstants.LBL_COL_RECOVERED_BY);
        colRecoveredBy.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String recoveryMethod = ((BrokenTestObject)element).getRecoveryMethod().getName();
                return recoveryMethod;
            }
        });
        TableViewerColumn colScreenshot = new TableViewerColumn(this.tbViewer, 0);
        colScreenshot.getColumn().setText(SmartXPathMessageConstants.LBL_COL_SCREENSHOT);
        colScreenshot.setLabelProvider((CellLabelProvider)new HyperLinkColumnLabelProvider<BrokenTestObject>(4){

            protected void handleMouseDown(MouseEvent e, ViewerCell cell) {
                BrokenTestObject brokenTestObject = (BrokenTestObject)cell.getElement();
                if (Desktop.isDesktopSupported()) {
                    try {
                        String filePath = FilenameUtils.separatorsToSystem((String)brokenTestObject.getPathToScreenshot());
                        File myFile = new File(filePath);
                        if (!myFile.isAbsolute()) {
                            String absoluteFilePath = FilenameUtils.concat((String)BrokenTestObjectsTableComposite.this.project.getFolderLocation(), (String)filePath);
                            myFile = new File(absoluteFilePath);
                        }
                        Desktop.getDesktop().open(myFile);
                    }
                    catch (NullPointerException nullPointerException) {
                        MessageDialog.openError(null, (String)GlobalMessageConstants.ERROR, (String)SmartXPathMessageConstants.MSG_DOES_NOT_HAVE_SCREENSHOT);
                    }
                    catch (IOException ioEx) {
                        MessageDialog.openError(null, (String)GlobalMessageConstants.ERROR, (String)ioEx.getMessage());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        MessageDialog.openError(null, (String)GlobalMessageConstants.ERROR, (String)SmartXPathMessageConstants.MSG_SCREENSHOT_DOES_NOT_EXIST);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        MessageDialog.openError(null, (String)GlobalMessageConstants.ERROR, (String)SmartXPathMessageConstants.MSG_PLATFORM_DOES_NOT_SUPPORT_OPEN);
                    }
                    catch (SecurityException securityException) {
                        MessageDialog.openError(null, (String)GlobalMessageConstants.ERROR, (String)SmartXPathMessageConstants.MSG_READ_ACCESS_DENIED);
                    }
                }
            }

            protected Class<BrokenTestObject> getElementType() {
                return BrokenTestObject.class;
            }

            protected Image getImage(BrokenTestObject element) {
                return null;
            }

            protected String getText(BrokenTestObject element) {
                return SmartXPathMessageConstants.LBL_PREVIEW_SCREENSHOT;
            }

            public String getToolTipText(Object element) {
                BrokenTestObject brokenTestObject = (BrokenTestObject)element;
                return brokenTestObject.getPathToScreenshot();
            }
        });
        TableViewerColumn colApproveNewLocator = new TableViewerColumn(this.tbViewer, 0);
        this.cApproveNewLocator = colApproveNewLocator.getColumn();
        this.setAcceptAllBrokenTestObjectsImage(this.acceptAll);
        colApproveNewLocator.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object property = cell.getElement();
                if (!(property instanceof BrokenTestObject)) {
                    return;
                }
                Boolean isSelected = ((BrokenTestObject)property).getApproved();
                ((TableItem)cell.getViewerRow().getItem()).setChecked(isSelected.booleanValue());
            }
        });
        colApproveNewLocator.setEditingSupport((EditingSupport)new ApproveCheckBoxColumnEditingSupport(this.tbViewer){

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(element, value);
                BrokenTestObjectsTableComposite.this.tbViewer.update(element, null);
                BrokenTestObjectsTableComposite.this.handleSelectionChange(null);
                if (!((Boolean)value).booleanValue()) {
                    BrokenTestObjectsTableComposite.this.acceptAll = false;
                    BrokenTestObjectsTableComposite.this.setAcceptAllBrokenTestObjectsImage(BrokenTestObjectsTableComposite.this.acceptAll);
                }
            }
        });
        this.cApproveNewLocator.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BrokenTestObjectsTableComposite.this.toggleAcceptAllBrokenTestObjects();
            }
        });
        this.tableColumnLayout.setColumnData((Widget)colObjectId.getColumn(), (ColumnLayoutData)new ColumnWeightData(30, 100));
        this.tableColumnLayout.setColumnData((Widget)colBrokenLocator.getColumn(), (ColumnLayoutData)new ColumnWeightData(30, 100));
        this.tableColumnLayout.setColumnData((Widget)colProposedLocator.getColumn(), (ColumnLayoutData)new ColumnWeightData(30, 100));
        this.tableColumnLayout.setColumnData((Widget)colRecoveredBy.getColumn(), (ColumnLayoutData)new ColumnWeightData(7, 90));
        this.tableColumnLayout.setColumnData((Widget)colScreenshot.getColumn(), (ColumnLayoutData)new ColumnWeightData(5, 70));
        this.tableColumnLayout.setColumnData((Widget)colApproveNewLocator.getColumn(), (ColumnLayoutData)new ColumnWeightData(3, 30));
    }

    public boolean toggleAcceptAllBrokenTestObjects() {
        this.acceptAll = !this.acceptAll;
        Set<BrokenTestObject> brokenTestObjects = this.getInput();
        for (BrokenTestObject element : brokenTestObjects) {
            element.setApproved(this.acceptAll);
        }
        this.setAcceptAllBrokenTestObjectsImage(this.acceptAll);
        this.setInput(brokenTestObjects);
        return this.acceptAll;
    }

    private void setAcceptAllBrokenTestObjectsImage(boolean value) {
        Image toggleApproveAllImage = this.getCheckboxSymbol(value);
        this.cApproveNewLocator.setImage(toggleApproveAllImage);
    }

    protected Image getCheckboxSymbol(boolean isChecked) {
        return isChecked ? ImageManager.getImage((String)"checkbox_checked_16.png") : ImageManager.getImage((String)"checkbox_unchecked_16.png");
    }

    public void refresh() {
        this.tbViewer.refresh();
    }

    public void setInput(Set<BrokenTestObject> brokenTestObjects) {
        if (brokenTestObjects == null) {
            this.tbViewer.setInput(null);
            return;
        }
        Set<BrokenTestObject> currentBrokenTestObjects = this.getInput();
        if (currentBrokenTestObjects != null) {
            brokenTestObjects.stream().forEach(brokenTestObject -> {
                BrokenTestObject existedBrokenTestObject = currentBrokenTestObjects.stream().filter(currentBrokenTestObject -> currentBrokenTestObject.equals(brokenTestObject)).findAny().orElse(null);
                if (existedBrokenTestObject != null) {
                    brokenTestObject.setApproved(existedBrokenTestObject.getApproved());
                }
            });
        }
        this.tbViewer.setInput(brokenTestObjects);
    }

    public Set<BrokenTestObject> getInput() {
        Set brokenTestObjects = (Set)this.tbViewer.getInput();
        return brokenTestObjects;
    }

    public Set<BrokenTestObject> getSelectedTestObjects() {
        Set brokenTestObjects = (Set)this.tbViewer.getInput();
        return brokenTestObjects.stream().filter(brokenTestObject -> brokenTestObject.getApproved()).collect(Collectors.toSet());
    }

    public Set<BrokenTestObject> getDeselectedTestObjects() {
        Set brokenTestObjects = (Set)this.tbViewer.getInput();
        return brokenTestObjects.stream().filter(brokenTestObject -> brokenTestObject.getApproved() == false).collect(Collectors.toSet());
    }

    private void handleSelectionChange(TypedEvent selectionEvent) {
        this.dispatchSelectionEvent(selectionEvent);
    }

    private void dispatchSelectionEvent(TypedEvent selectionEvent) {
        this.notifyListeners(13, null);
        this.notifyListeners(14, null);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void setMouseEventListener(MouseTrackListener listener) {
        this.table.addMouseTrackListener(listener);
    }
}

