/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.plugin.smart_xpath.settings;

import com.katalon.plugin.smart_xpath.constant.SmartXPathMessageConstants;
import com.katalon.plugin.smart_xpath.logger.LoggerSingleton;
import com.katalon.plugin.smart_xpath.settings.AbstractSettingPage;
import com.katalon.plugin.smart_xpath.settings.composites.ExcludeObjectsUsedWithKeywordsComposite;
import com.katalon.plugin.smart_xpath.settings.composites.HelpCompositeForExecutionDialog;
import com.katalon.plugin.smart_xpath.settings.composites.PrioritizeSelectionMethodsComposite;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.execution.webui.setting.WebUiExecutionSettingStore;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.util.collections.Pair;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SelfHealingWebUISettingPage
extends AbstractSettingPage {
    private IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
    private static final String LBL_TOGGLE_SELF_HEALING_EXECUTION_METHOD = SmartXPathMessageConstants.LBL_TOGGLE_SELF_HEALING_EXECUTION_METHOD;
    private Button checkboxEnableSelfHealing;
    private ExcludeObjectsUsedWithKeywordsComposite excludeObjectsUsedWithKeywordsComposite;
    private PrioritizeSelectionMethodsComposite prioritizeSelectionMethodsComposite;
    private final String documentationUrl = SmartXPathMessageConstants.SELF_HEALING_DOCUMENT_LINK;
    private List<Pair<SelectorMethod, Boolean>> methodsPriorityOrder = Collections.emptyList();
    private List<String> excludeKeywordNames = Collections.emptyList();
    private WebUiExecutionSettingStore preferenceStore = WebUiExecutionSettingStore.getStore();

    private void setInput() {
        try {
            this.excludeKeywordNames = this.preferenceStore.getExcludeKeywordList();
            this.methodsPriorityOrder = this.preferenceStore.getMethodsPriorityOrder();
        }
        catch (IOException exception) {
            LoggerSingleton.logError(exception);
        }
        this.excludeObjectsUsedWithKeywordsComposite.setInput(this.excludeKeywordNames);
        this.prioritizeSelectionMethodsComposite.setInput(this.methodsPriorityOrder);
        boolean isEnableSelfHealing = this.getEnableSelfHealingFromPluginPreference();
        this.checkboxEnableSelfHealing.setSelection(this.canUseSelfHealing() && isEnableSelfHealing);
    }

    @Override
    protected void createSettingsArea(Composite parent) {
        Composite mainContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        mainContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        layout.verticalSpacing = 10;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainContainer.setLayout((Layout)layout);
        this.createCheckboxEnableSelfHealing(mainContainer);
        this.createMethodsPriorityOrderComposite(mainContainer);
        this.createExcludeWithKeywordsComposite(mainContainer);
    }

    private void createCheckboxEnableSelfHealing(Composite parent) {
        this.checkboxEnableSelfHealing = new Button(parent, 32);
        this.checkboxEnableSelfHealing.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.checkboxEnableSelfHealing.setText(LBL_TOGGLE_SELF_HEALING_EXECUTION_METHOD);
        this.checkboxEnableSelfHealing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!SelfHealingWebUISettingPage.this.canUseSelfHealing()) {
                    SelfHealingWebUISettingPage.this.checkboxEnableSelfHealing.setSelection(false);
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.SELF_HEALING);
                }
                SelfHealingWebUISettingPage.this.handleInputChanged((Control)SelfHealingWebUISettingPage.this.checkboxEnableSelfHealing, null);
            }
        });
        new HelpCompositeForExecutionDialog(parent, this.documentationUrl);
    }

    private List<Pair<SelectorMethod, Boolean>> createMethodsPriorityOrderComposite(Composite parent) {
        if (this.prioritizeSelectionMethodsComposite == null) {
            this.prioritizeSelectionMethodsComposite = new PrioritizeSelectionMethodsComposite(parent, 0);
            this.prioritizeSelectionMethodsComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelfHealingWebUISettingPage.this.handleInputChanged((Control)SelfHealingWebUISettingPage.this.prioritizeSelectionMethodsComposite, null);
                }
            });
            this.prioritizeSelectionMethodsComposite.addNavigateToWebUITestDesignListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelfHealingWebUISettingPage.this.navigateToWebUITestDesignPage();
                }
            });
        }
        return this.methodsPriorityOrder;
    }

    private void navigateToWebUITestDesignPage() {
        this.eventBroker.post("SETTINGS/PAGE_CHANGE", (Object)"com.kms.katalon.composer.webui.setting.testdesign.webui");
    }

    private Composite createExcludeWithKeywordsComposite(Composite parent) {
        if (this.excludeObjectsUsedWithKeywordsComposite == null) {
            this.excludeObjectsUsedWithKeywordsComposite = new ExcludeObjectsUsedWithKeywordsComposite(parent, 0, this.preferenceStore);
            this.excludeObjectsUsedWithKeywordsComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SelfHealingWebUISettingPage.this.handleInputChanged((Control)SelfHealingWebUISettingPage.this.excludeObjectsUsedWithKeywordsComposite, null);
                }
            });
        }
        return this.excludeObjectsUsedWithKeywordsComposite;
    }

    private boolean getEnableSelfHealingFromPluginPreference() {
        return this.preferenceStore.getSelfHealingEnabled(this.canUseSelfHealing());
    }

    private List<Pair<SelectorMethod, Boolean>> getMethodsPriorityOrderFromPluginPreference() {
        List value = null;
        try {
            value = this.preferenceStore.getMethodsPriorityOrder();
        }
        catch (IOException exception) {
            LoggerSingleton.logError(exception);
            return null;
        }
        return value;
    }

    private List<String> getExcludeKeywordsFromPluginPreference() {
        List value = null;
        try {
            value = this.preferenceStore.getExcludeKeywordList();
        }
        catch (IOException exception) {
            LoggerSingleton.logError(exception);
        }
        return value;
    }

    @Override
    protected void initialize() throws IOException {
        this.setInput();
    }

    @Override
    protected void performDefaults() {
        try {
            this.preferenceStore.setEnableSelfHealing(this.canUseSelfHealing());
            this.preferenceStore.setDefaultMethodsPriorityOrder();
            this.preferenceStore.setDefaultExcludeKeywordList();
            this.initialize();
        }
        catch (IOException e) {
            LoggerSingleton.logError(e);
        }
        super.performDefaults();
    }

    @Override
    protected boolean saveSettings() {
        try {
            this.preferenceStore.setExcludeKeywordList(this.excludeObjectsUsedWithKeywordsComposite.getInput());
            this.preferenceStore.setMethodsPritorityOrder(this.prioritizeSelectionMethodsComposite.getInput());
            if (this.canUseSelfHealing()) {
                this.preferenceStore.setEnableSelfHealing(this.checkboxEnableSelfHealing.getSelection());
            }
        }
        catch (IOException exception) {
            LoggerSingleton.logError(exception);
            return false;
        }
        return true;
    }

    @Override
    protected boolean hasChanged() {
        if (!this.isValid()) {
            return false;
        }
        boolean isEnableSelfHealing = this.checkboxEnableSelfHealing.getSelection();
        if (isEnableSelfHealing != this.getEnableSelfHealingFromPluginPreference()) {
            return true;
        }
        List<String> excludeKeywordNamesBeforeSetting = this.getExcludeKeywordsFromPluginPreference();
        if (!this.excludeObjectsUsedWithKeywordsComposite.compareInput(excludeKeywordNamesBeforeSetting)) {
            return true;
        }
        List<Pair<SelectorMethod, Boolean>> methodsPriorityOrderSetting = this.getMethodsPriorityOrderFromPluginPreference();
        return !this.prioritizeSelectionMethodsComposite.compareInput(methodsPriorityOrderSetting);
    }

    @Override
    public boolean hasDocumentation() {
        return false;
    }

    private boolean canUseSelfHealing() {
        IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
        return featureService.canUse(KSEFeature.SELF_HEALING);
    }
}

