/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.validation.datasource.impl;

import com.kms.katalon.application.preference.ProxyPreferences;
import com.kms.katalon.core.network.HttpClientProxyBuilder;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.validation.datasource.adapter.IGetSpecificationFileDataSource;
import com.kms.katalon.validation.exception.DataSourceException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class GetSpecificationDataSource
implements IGetSpecificationFileDataSource {
    @Override
    public File getSpecificationFile(String url, String token, String fileLocation) throws DataSourceException {
        try {
            this.fetchSpecificationFileFromUrl(url, fileLocation);
        }
        catch (Exception e) {
            throw new DataSourceException(e);
        }
        return new File(fileLocation);
    }

    private void fetchSpecificationFileFromUrl(String url, String fileLocation) throws Exception {
        URI uri = new URIBuilder().setPath(url).build();
        HttpGet httpPost = new HttpGet(uri);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-type", "application/json");
        String responseString = GetSpecificationDataSource.executeRequest((HttpUriRequest)httpPost);
        Files.write(Paths.get(fileLocation, new String[0]), responseString.getBytes(), new OpenOption[0]);
    }

    private static String executeRequest(HttpUriRequest httpRequest) throws DataSourceException {
        try {
            HttpClientProxyBuilder httpClientProxyBuilder = HttpClientProxyBuilder.create((ProxyInformation)ProxyPreferences.getAuthProxyInformation(), (String)httpRequest.getURI().toURL().toString());
            CloseableHttpClient httpClient = httpClientProxyBuilder.getClientBuilder().build();
            HttpResponse httpResponse = httpClient.execute(httpRequest);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            HttpEntity entity = httpResponse.getEntity();
            String responseString = "";
            if (entity != null) {
                responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
            }
            if (statusCode == 200 || statusCode == 201 || statusCode == 204) {
                return responseString;
            }
        }
        catch (IOException | URISyntaxException | GeneralSecurityException e) {
            throw new DataSourceException(e);
        }
        return "";
    }
}

