/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.validation.datasource.provider;

import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.validation.datasource.adapter.IFilterSurveysDataSource;
import com.kms.katalon.validation.datasource.adapter.IGetSpecificationFileDataSource;
import com.kms.katalon.validation.datasource.adapter.IInsertEventIntoDatabaseDataSource;
import com.kms.katalon.validation.datasource.adapter.IParseSpecificationFileToSurveysDataSource;
import com.kms.katalon.validation.datasource.impl.FilterSurveyFileDataSource;
import com.kms.katalon.validation.datasource.impl.GetSpecificationDataSource;
import com.kms.katalon.validation.datasource.impl.InsertEventIntoDatabaseDataSource;
import com.kms.katalon.validation.datasource.impl.ParseSpecificationFileToSurveysDataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class ValidationDataSourceProvider {
    private static final String EMBED_DRIVER_CLASS_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    private Properties validationProperties;
    private static ValidationDataSourceProvider _instance;
    private IInsertEventIntoDatabaseDataSource insertEventIntoDatabaseDataSource;
    private IGetSpecificationFileDataSource getSpecificationFileDataSource;
    private IFilterSurveysDataSource filterSurveysDataSource;
    private IParseSpecificationFileToSurveysDataSource parseSpecificationFileToSurveysDataSource;
    private String validationPropertiesFilePath = "";
    private Connection conn;

    public static ValidationDataSourceProvider getInstance() {
        if (_instance == null) {
            _instance = new ValidationDataSourceProvider();
        }
        return _instance;
    }

    private ValidationDataSourceProvider() {
    }

    public void initializeDataSources(String absolutePathToFolder) {
        try {
            File databaseFolderFile = this.createDatabaseFolder(absolutePathToFolder);
            this.conn = this.initializeDatabase(databaseFolderFile);
            this.validationPropertiesFilePath = String.valueOf(absolutePathToFolder) + "/validation.properties";
            this.validationProperties = this.createValidationProperties(this.validationPropertiesFilePath);
            this.insertEventIntoDatabaseDataSource = new InsertEventIntoDatabaseDataSource(this.conn);
            this.getSpecificationFileDataSource = new GetSpecificationDataSource();
            this.filterSurveysDataSource = new FilterSurveyFileDataSource(this.conn, this.validationProperties);
            this.parseSpecificationFileToSurveysDataSource = new ParseSpecificationFileToSurveysDataSource();
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            LogUtil.printAndLogError((Throwable)e);
        }
    }

    private Connection initializeDatabase(File databaseFolderFile) throws ClassNotFoundException, SQLException {
        Class.forName(EMBED_DRIVER_CLASS_NAME);
        String URL2 = this.getDatabaseURL(databaseFolderFile);
        System.out.println(URL2);
        Connection conn = DriverManager.getConnection(URL2);
        return conn;
    }

    private String getDatabaseURL(File databaseFolderFile) {
        return "jdbc:derby:" + databaseFolderFile.getAbsolutePath() + "/katalon-db;create=true";
    }

    private Properties createValidationProperties(String validationPropertiesFilePath) throws IOException {
        File validationPropertiesFile = new File(validationPropertiesFilePath);
        if (!validationPropertiesFile.exists()) {
            validationPropertiesFile.createNewFile();
        }
        Properties validationProperties = new Properties();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (FileInputStream in = new FileInputStream(validationPropertiesFile);){
                validationProperties = new Properties();
                validationProperties.load(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            validationProperties = null;
        }
        return validationProperties;
    }

    private File createDatabaseFolder(String absolutePathToFolder) {
        String databaseFolder = String.valueOf(absolutePathToFolder) + "/derby";
        File databaseFolderFile = new File(databaseFolder);
        if (!databaseFolderFile.exists()) {
            databaseFolderFile.mkdir();
        }
        return databaseFolderFile;
    }

    public IInsertEventIntoDatabaseDataSource insertEventIntoDatabaseDataSource() {
        return this.insertEventIntoDatabaseDataSource;
    }

    public IGetSpecificationFileDataSource getSpecificationFileDataSource() {
        return this.getSpecificationFileDataSource;
    }

    public IFilterSurveysDataSource filterSurveysDataSource() {
        return this.filterSurveysDataSource;
    }

    public IParseSpecificationFileToSurveysDataSource parseSpecificationFileToSurveysDataSource() {
        return this.parseSpecificationFileToSurveysDataSource;
    }

    public void close() throws IOException, SQLException {
        if (this.validationProperties == null) {
            return;
        }
        FileOutputStream out = new FileOutputStream(new File(this.validationPropertiesFilePath));
        this.validationProperties.store(out, "");
        if (this.conn != null) {
            this.conn.close();
        }
    }

    public Properties getValidationProperties() {
        return this.validationProperties;
    }
}

