/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.validation.usecase.impl;

import com.kms.katalon.validation.domain.IValidationSurvey;
import com.kms.katalon.validation.domain.ValidationSurveyOption;
import com.kms.katalon.validation.domain.ValidationSurveyQuestion;
import com.kms.katalon.validation.exception.UseCaseException;
import com.kms.katalon.validation.usecase.adapter.IGatherMultipleChoiceSurveyResultUseCase;
import com.kms.katalon.validation.usecase.adapter.input.GatherMultiplechoiceSurveyResultInput;
import com.kms.katalon.validation.usecase.adapter.output.GatherMultiplechoiceSurveyResultOutput;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;

public class GatherMultipleChoiceSurveyResultUseCase
implements IGatherMultipleChoiceSurveyResultUseCase {
    private int surveyDepth;
    private Object[] multipleChoiceResult;
    private IValidationSurvey survey;

    public GatherMultipleChoiceSurveyResultUseCase(IValidationSurvey survey) {
        this.surveyDepth = this.calculateSurveyDepth(survey);
        this.multipleChoiceResult = new Object[this.surveyDepth * 2 + 1];
        this.survey = survey;
    }

    @Override
    public int calculateSurveyDepth(IValidationSurvey survey) {
        int max = -1;
        for (ValidationSurveyQuestion question : survey.getQuestions()) {
            int depth = this.recursivelyCalculateSurveyDepth(question, 1);
            if (depth <= max) continue;
            max = depth;
        }
        return max;
    }

    private int recursivelyCalculateSurveyDepth(ValidationSurveyQuestion question, int currentDepth) {
        int maxDepth = currentDepth;
        for (ValidationSurveyOption option : question.getOptions()) {
            int temp;
            ValidationSurveyQuestion subquestion;
            if (option.getSubQuestions() == null || (subquestion = option.getSubQuestions()) == null || (temp = this.recursivelyCalculateSurveyDepth(subquestion, currentDepth + 1)) <= maxDepth) continue;
            maxDepth = temp;
        }
        return maxDepth;
    }

    @Override
    public void computeResult(GatherMultiplechoiceSurveyResultInput input) throws UseCaseException {
        Integer level = input.getLevel();
        Integer optionNumber = input.getOptionNumber();
        String userElaboratedtext = input.getUserElaboratedText();
        if (level < 1 || level > this.surveyDepth + 1) {
            throw new UseCaseException("Level must be from 1 to " + this.surveyDepth);
        }
        if (this.multipleChoiceResult[level] == null) {
            this.multipleChoiceResult[level.intValue()] = optionNumber;
        } else if (this.multipleChoiceResult[level] != optionNumber) {
            int i = level + 1;
            while (i < this.surveyDepth * 2 + 1) {
                this.multipleChoiceResult[i] = null;
                ++i;
            }
            this.multipleChoiceResult[level.intValue()] = optionNumber;
        }
        if (!StringUtils.isEmpty((CharSequence)userElaboratedtext)) {
            this.multipleChoiceResult[this.surveyDepth + level.intValue()] = userElaboratedtext;
        }
    }

    @Override
    public GatherMultiplechoiceSurveyResultOutput getMultipleChoiceSurveyResult() throws UseCaseException {
        if (this.multipleChoiceResult == null) {
            throw new UseCaseException("No multiple choice survey was given to use case");
        }
        try {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            int i = 1;
            while (i < this.surveyDepth + 1) {
                result.put("level_" + i, this.multipleChoiceResult[i]);
                ++i;
            }
            i = 1;
            while (i < this.surveyDepth + 1) {
                Object strValue = this.multipleChoiceResult[this.surveyDepth + i];
                result.put("text_" + i, strValue == null ? "" : strValue);
                ++i;
            }
            return new GatherMultiplechoiceSurveyResultOutput(result, this.survey.getSurveyId(), this.survey.getVersion());
        }
        catch (NullPointerException e) {
            throw new UseCaseException(e);
        }
    }
}

