/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.validation.usecase.impl;

import com.kms.katalon.validation.datasource.adapter.IParseSpecificationFileToSurveysDataSource;
import com.kms.katalon.validation.domain.IValidationSurvey;
import com.kms.katalon.validation.domain.ValidationSurvey;
import com.kms.katalon.validation.exception.DataSourceException;
import com.kms.katalon.validation.exception.UseCaseException;
import com.kms.katalon.validation.usecase.adapter.IParseSpecificationFileToSurveysUseCase;
import com.kms.katalon.validation.usecase.adapter.input.ParseSpecificationFileToSurveysInput;
import com.kms.katalon.validation.usecase.adapter.output.ParseSpecificationFileToSurveysOutput;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ParseSpecificationFileToSurveysUseCase
implements IParseSpecificationFileToSurveysUseCase {
    private IParseSpecificationFileToSurveysDataSource datasource;

    public ParseSpecificationFileToSurveysUseCase(IParseSpecificationFileToSurveysDataSource datasource) {
        this.datasource = datasource;
    }

    @Override
    public ParseSpecificationFileToSurveysOutput parseSpecificationFileToSurveys(ParseSpecificationFileToSurveysInput input) throws UseCaseException {
        String absolutePathToSpecificationFile = input.getSpecificationFileLocation();
        File specificationFile = new File(absolutePathToSpecificationFile);
        if (!specificationFile.exists()) {
            throw new UseCaseException("Specification file does not exist at the provided location !");
        }
        try {
            List<ValidationSurvey> surveys = this.datasource.parseSpecificationFileToSurveys(absolutePathToSpecificationFile);
            if (surveys.size() == 0) {
                return new ParseSpecificationFileToSurveysOutput(false, "The specification file does not contain any survey", Collections.emptyList());
            }
            return new ParseSpecificationFileToSurveysOutput(true, "Successfully parse specification file to surveys", surveys.stream().filter(survey -> survey instanceof IValidationSurvey).map(survey -> survey).collect(Collectors.toList()));
        }
        catch (DataSourceException e) {
            return new ParseSpecificationFileToSurveysOutput(false, e.getMessage(), Collections.emptyList());
        }
    }
}

