/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.util.ArrayList;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;

public final class Strings {
    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String quote(String s) {
        return s != null ? Strings.concat("'", s, "'") : null;
    }

    public static Object quote(Object o) {
        return o instanceof String ? Strings.quote(o.toString()) : o;
    }

    public static String concat(Object ... objects) {
        if (Arrays.isNullOrEmpty(objects)) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (Object o : objects) {
            b.append(o);
        }
        return b.toString();
    }

    public static String formatIfArgs(String message, Object ... args) {
        return Arrays.isNullOrEmpty(args) ? String.format(Strings.escapePercentExceptWhenFollowedBy_n(message), new Object[0]) : String.format(message, args);
    }

    public static String escapePercent(String value) {
        return value == null ? null : value.replace("%", "%%");
    }

    public static StringsToJoin join(String ... strings) {
        return new StringsToJoin(strings);
    }

    public static StringsToJoin join(Iterable<?> toStringable) {
        ArrayList<String> strings = Lists.newArrayList();
        for (Object o : toStringable) {
            strings.add(String.valueOf(o));
        }
        return new StringsToJoin(strings.toArray(new String[strings.size()]));
    }

    public static StringToAppend append(String toAppend) {
        return new StringToAppend(toAppend);
    }

    private static String escapePercentExceptWhenFollowedBy_n(String message) {
        return Strings.revertEscapingPercent_n(Strings.escapePercent(message));
    }

    private static String revertEscapingPercent_n(String value) {
        return value == null ? null : value.replace("%%n", "%n");
    }

    private Strings() {
    }

    public static class StringToAppend {
        private final String toAppend;

        StringToAppend(String toAppend) {
            this.toAppend = toAppend;
        }

        public String to(String s) {
            if (!s.endsWith(this.toAppend)) {
                return Strings.concat(s, this.toAppend);
            }
            return s;
        }
    }

    public static class StringsToJoin {
        private final String[] strings;

        StringsToJoin(String ... strings) {
            this.strings = strings;
        }

        public String with(String delimiter) {
            return this.with(delimiter, null);
        }

        public String with(String delimiter, String escapeString) {
            Preconditions.checkArgument(delimiter != null, "Delimiter should not be null", new Object[0]);
            if (Arrays.isNullOrEmpty(this.strings)) {
                return "";
            }
            String escape = escapeString == null ? "" : escapeString;
            StringBuilder b = new StringBuilder();
            int stringCount = this.strings.length;
            for (int i = 0; i < stringCount; ++i) {
                String s = this.strings[i];
                if (s != null) {
                    b.append(escape);
                    b.append(s);
                    b.append(escape);
                }
                if (i >= stringCount - 1) continue;
                b.append(delimiter);
            }
            return b.toString();
        }
    }
}

