/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics.providers;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.core.util.Strings;
import com.kms.katalon.core.util.TimeUtil;
import com.kms.katalon.integration.analytics.constants.IntegrationAnalyticsMessages;
import com.kms.katalon.integration.analytics.dialog.TokenExpiredNotificationDialog;
import com.kms.katalon.integration.analytics.entity.AnalyticsTokenInfo;
import com.kms.katalon.integration.analytics.entity.KatOneJwtTokenInfo;
import com.kms.katalon.integration.analytics.exceptions.AccessTokenExpiredException;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.exceptions.TokenExpiredException;
import com.kms.katalon.integration.analytics.providers.BaseTestOpsService;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.license.models.AuthenticationToken;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Timer;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.widgets.Display;

public class AuthenticationService
extends BaseTestOpsService<AuthenticationService> {
    private static final long LOG_OUT_AFTER_MILISECONDS = 300000L;
    private static final String SSO_SERVER_PROPERTY_NAME = "ssoServerUrl";
    private static final String DEFAULT_SSO_SERVER = "https://login.katalon.com";
    private static AuthenticationService _instance;
    private String keyCloakServerURL = "";
    private Timer logoutTimer;
    private ApplicationContext appContext = ApplicationContext.getInstance();

    private AuthenticationService() {
    }

    public static AuthenticationService getInstance() {
        if (_instance == null) {
            _instance = new AuthenticationService();
        }
        return _instance;
    }

    public void showTokenExpiredDialog(String message) {
        if (this.appContext.isLogoutAck()) {
            return;
        }
        TokenExpiredNotificationDialog dialog = new TokenExpiredNotificationDialog(Display.getCurrent().getActiveShell(), message);
        this.appContext.setLogoutAck(true);
        dialog.open();
        this.logoutKSAfter(300000L);
    }

    private void logoutKSAfter(long miliseconds) {
        TimeUtil.cancel((Timer)this.logoutTimer);
        this.logoutTimer = UITimeUtil.setTimeout(() -> {
            IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
            eventBroker.post("TOKEN_EXPIRED", null);
        }, (long)miliseconds);
    }

    public AuthenticationToken getKatOneTokenPair(AuthenticationToken currentKatOneToken) {
        AuthenticationToken newKatOneToken = null;
        try {
            newKatOneToken = this.requestNewKatOneTokenPairs(currentKatOneToken);
        }
        catch (TokenExpiredException e) {
            LogUtil.logError((Throwable)e);
            this.showTokenExpiredDialog(e.getMessage());
        }
        catch (AccessTokenExpiredException e) {
            LogUtil.logError((Throwable)e);
            this.showTokenExpiredDialog(e.getMessage());
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
        return newKatOneToken;
    }

    public AuthenticationToken requestNewKatOneTokenPairs(AuthenticationToken currentKatOneToken) throws Exception {
        if (currentKatOneToken.getAccessToken() == null || currentKatOneToken.getRefreshToken() == null) {
            return currentKatOneToken;
        }
        long currentEpoch = Instant.now().getEpochSecond();
        AuthenticationToken.JwtTokenInfo accessToken = (AuthenticationToken.JwtTokenInfo)currentKatOneToken.parseAccessToken(AuthenticationToken.JwtTokenInfo.class);
        if (accessToken.exp() < currentEpoch) {
            AuthenticationToken.JwtTokenInfo refreshToken = (AuthenticationToken.JwtTokenInfo)currentKatOneToken.parseRefreshToken(AuthenticationToken.JwtTokenInfo.class);
            if (refreshToken.exp() > currentEpoch) {
                AnalyticsTokenInfo refreshedToken = this.refreshKatOneTokenWithRetry(currentKatOneToken);
                if (refreshedToken != null) {
                    AuthenticationToken newKatOneToken = new AuthenticationToken();
                    this.transferTokenInfo(refreshedToken, newKatOneToken, this.getKatOneServer());
                    return newKatOneToken;
                }
                throw new AccessTokenExpiredException(IntegrationAnalyticsMessages.MSD_DIA_ACCESS_TOKEN_EXPIRED);
            }
            throw new TokenExpiredException(IntegrationAnalyticsMessages.MSG_TOKEN_EXPIRED_EXCEPTION);
        }
        return currentKatOneToken;
    }

    public HttpPost buildRequestToGrabKatOneToken(String authUri, String code, String codeVerifier, String clientId, String redirectUri) {
        ArrayList<BasicNameValuePair> body = new ArrayList<BasicNameValuePair>();
        body.add(new BasicNameValuePair("grant_type", "authorization_code"));
        body.add(new BasicNameValuePair("client_id", clientId));
        body.add(new BasicNameValuePair("code", code));
        body.add(new BasicNameValuePair("code_verifier", codeVerifier));
        body.add(new BasicNameValuePair("redirect_uri", redirectUri));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(body, StandardCharsets.UTF_8);
        HttpPost request = new HttpPost(authUri);
        request.setEntity((HttpEntity)entity);
        request.addHeader("Content-Type", "application/x-www-form-urlencoded");
        return request;
    }

    public <T> T sendRequestWithRetry(HttpUriRequest httpRequest, Class<T> returnType, int retryTimes, boolean isSilent) throws ParseException, IOException, URISyntaxException, GeneralSecurityException {
        String responseString = this.sendRequestWithRetry(httpRequest, retryTimes, isSilent);
        if (StringUtils.isNotBlank((CharSequence)responseString)) {
            Gson gson = new GsonBuilder().create();
            return (T)gson.fromJson(responseString, returnType);
        }
        return null;
    }

    private String sendRequestWithRetry(HttpUriRequest request, int retryTimes, boolean isSilent) throws ParseException, IOException, URISyntaxException, GeneralSecurityException {
        HttpResponse httpResponse;
        int statusCode;
        int retryCount = 0;
        while (!AuthenticationService.isClientErrorStatus(statusCode = (httpResponse = this.buildAndExecuteHttpRequest(request)).getStatusLine().getStatusCode())) {
            String responseString = null;
            if (httpResponse.getEntity() != null) {
                responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
            }
            if (AuthenticationService.isOkStatus(statusCode)) {
                return responseString;
            }
            if (!AuthenticationService.isRetryStatus(statusCode)) {
                if (!isSilent) {
                    LogUtil.logError((String)MessageFormat.format("Katalon TestOps: Unexpected response, URL: {0}, Status: {1}, Response: {2}", request.getURI().toString(), statusCode, responseString));
                }
                return null;
            }
            LogUtil.logInfo((String)MessageFormat.format("Send request with status code {0}. Retried {1} time(s).", String.valueOf(statusCode), String.valueOf(retryCount + 1)));
            ++retryCount;
            try {
                TimeUnit.SECONDS.sleep(7L);
            }
            catch (InterruptedException interruptedException) {
                LogUtil.logInfo((String)"No waiting before retrying. Thread intrrupted.");
            }
            if (retryCount < retryTimes) continue;
        }
        return null;
    }

    public AnalyticsTokenInfo refreshKatOneTokenWithRetry(AuthenticationToken katOneToken) throws Exception {
        KatOneJwtTokenInfo tokenInfo = (KatOneJwtTokenInfo)katOneToken.parseAccessToken(KatOneJwtTokenInfo.class);
        String refreshTokenUri = String.valueOf(this.getKeycloakAdminURL()) + "/realms/katalon/protocol/openid-connect/token";
        return this.refreshKatOneTokenWithRetry(katOneToken.getRefreshToken(), refreshTokenUri, tokenInfo.azp);
    }

    public AnalyticsTokenInfo refreshKatOneTokenWithRetry(String refreshToken, String ssoRefreshTokenUri, String clientId) throws Exception {
        block3: {
            try {
                if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{refreshToken, ssoRefreshTokenUri, clientId})) break block3;
                return null;
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e);
                throw new Exception(e);
            }
        }
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("refresh_token", refreshToken));
        nameValuePairs.add(new BasicNameValuePair("client_id", clientId));
        nameValuePairs.add(new BasicNameValuePair("grant_type", "refresh_token"));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nameValuePairs, StandardCharsets.UTF_8);
        HttpPost request = new HttpPost(ssoRefreshTokenUri);
        request.setEntity((HttpEntity)entity);
        request.addHeader("Content-Type", "application/x-www-form-urlencoded");
        return this.sendRequestWithRetry((HttpUriRequest)request, AnalyticsTokenInfo.class, 3, false);
    }

    public <T> T sendRequestWithForceRefresh(HttpUriRequest request, Class<T> returnType, int retryTimes) throws AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        return this.sendRequestWithForceRefresh(request, TypeToken.of(returnType), retryTimes, false);
    }

    public <T> T sendRequestWithForceRefresh(HttpUriRequest httpRequest, TypeToken<T> typeToken, int retryTimes, boolean isSilent) throws ParseException, AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        String responseString = this.sendRequestWithForceRefresh(httpRequest, retryTimes, isSilent);
        Gson gson = new GsonBuilder().create();
        return (T)gson.fromJson(responseString, typeToken.getType());
    }

    public String sendRequestWithForceRefresh(HttpUriRequest request, int retryTimes, boolean isSilent) throws AnalyticsApiException, ParseException, IOException, URISyntaxException, GeneralSecurityException {
        int retryCount = 0;
        int forceRefreshCount = 0;
        String responseString = "";
        do {
            HttpResponse httpResponse = this.buildAndExecuteHttpRequest(request);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            HttpEntity entity = httpResponse.getEntity();
            if (entity != null) {
                responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
            }
            if (AuthenticationService.isOkStatus(statusCode)) {
                return responseString;
            }
            if (statusCode == 401) {
                this.refreshKatOneToken(this.getKatOneToken());
                LogUtil.logInfo((String)MessageFormat.format("Force refreshing KatOne access token 1 time with status code {0}", String.valueOf(statusCode)));
                if (forceRefreshCount != 0) break;
                retryCount = 0;
                ++forceRefreshCount;
                continue;
            }
            if (AuthenticationService.isRetryStatus(statusCode)) {
                LogUtil.logInfo((String)MessageFormat.format("Send request with status code {0}. Retrying {1}.", String.valueOf(statusCode), String.valueOf(retryCount)));
            } else if (!isSilent) {
                LogUtil.logError((String)MessageFormat.format("Katalon TestOps: Unexpected response, URL: {0}, Status: {1}, Response: {2}", request.getURI().toString(), statusCode, responseString));
                break;
            }
            ++retryCount;
            try {
                TimeUnit.SECONDS.sleep(7L);
            }
            catch (InterruptedException interruptedException) {
                LogUtil.logInfo((String)"No waiting before retrying. Thread intrrupted.");
            }
        } while (retryCount < retryTimes);
        throw new AnalyticsApiException(responseString);
    }

    public AnalyticsTokenInfo requestTokenWithForceRefresh(String serverUrl, String username, String password, boolean silent) throws AnalyticsApiException {
        try {
            if (StringUtils.isBlank((CharSequence)password)) {
                throw new AnalyticsApiException("Invalid credential");
            }
            URI uri = this.getApiURI(serverUrl, "/oauth/token");
            URIBuilder uriBuilder = new URIBuilder(uri);
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            nameValuePairs.add(new BasicNameValuePair("username", username));
            nameValuePairs.add(new BasicNameValuePair("password", password));
            nameValuePairs.add(new BasicNameValuePair("grant_type", "password"));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nameValuePairs, StandardCharsets.UTF_8);
            HttpPost httpPost = new HttpPost(uriBuilder.build().toASCIIString());
            httpPost.setEntity((HttpEntity)entity);
            String clientCredentials = "kit:kit";
            httpPost.setHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString(clientCredentials.getBytes()));
            return (AnalyticsTokenInfo)this.sendRequestWithForceRefresh((HttpUriRequest)httpPost, TypeToken.of(AnalyticsTokenInfo.class), 3, silent);
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public <T> T sendRequestWithForceRefresh(HttpUriRequest request, TypeToken<T> returnType, String token, int retryTime, boolean silent) throws AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        this.applyAuthHeaders(request, token);
        return this.sendRequestWithForceRefresh(request, returnType, retryTime, silent);
    }

    public <T> T sendRequestWithKatOneToken(HttpUriRequest request, TypeToken<T> returnType, AuthenticationToken token, int retryTime) throws AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        return this.sendRequestWithKatOneToken(request, returnType, token, retryTime, false);
    }

    public <T> T sendKatOneRequest(HttpUriRequest request, TypeToken<T> returnType, AuthenticationToken katOneToken) throws Exception {
        AuthenticationToken newKatOneToken;
        if (!TestOpsService.isUsingOverridingInstance() && (newKatOneToken = this.getKatOneTokenPair(katOneToken)) != null) {
            katOneToken.updateTokens(newKatOneToken.getAccessToken(), newKatOneToken.getRefreshToken(), newKatOneToken.getServer());
        }
        return this.sendRequestWithKatOneToken(request, returnType, katOneToken, 3);
    }

    public <T> T sendRequestWithKatOneToken(HttpUriRequest request, TypeToken<T> returnType, AuthenticationToken token, int retryTime, boolean silent) throws AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        return this.sendRequestWithForceRefresh(request, returnType, token.getAccessToken(), retryTime, silent);
    }

    public String getKeycloakAdminURL() {
        return (String)Strings.firstNonBlank((CharSequence[])new String[]{System.getProperty(SSO_SERVER_PROPERTY_NAME), this.keyCloakServerURL, DEFAULT_SSO_SERVER});
    }

    public void setKeycloakAdminURL(String authServer) {
        this.keyCloakServerURL = authServer;
    }
}

