/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics.providers;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.core.event.EventEmitter;
import com.kms.katalon.core.network.HttpClientProxyBuilder;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.network.RequestBuilder;
import com.kms.katalon.core.util.JsonBuilder;
import com.kms.katalon.core.util.ObjectUtil;
import com.kms.katalon.core.util.Strings;
import com.kms.katalon.core.util.TimeUtil;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.integration.analytics.entity.AdminTokenInfo;
import com.kms.katalon.integration.analytics.entity.AnalyticsApiKey;
import com.kms.katalon.integration.analytics.entity.AnalyticsPage;
import com.kms.katalon.integration.analytics.entity.AnalyticsTokenInfo;
import com.kms.katalon.integration.analytics.entity.KatOneApiTokenInfo;
import com.kms.katalon.integration.analytics.entity.KatOneJwtTokenInfo;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.providers.AuthenticationService;
import com.kms.katalon.integration.analytics.util.AuthenticationTokenUtils;
import com.kms.katalon.license.models.AuthenticationCredential;
import com.kms.katalon.license.models.AuthenticationInfo;
import com.kms.katalon.license.models.AuthenticationToken;
import com.kms.katalon.license.models.CombinedAuthenticationToken;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Timer;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public abstract class BaseTestOpsService<DerivedType extends BaseTestOpsService> {
    protected static final String HEADER_VALUE_AUTHORIZATION_PREFIX = "Bearer ";
    protected static final String HEADER_AUTHORIZATION = "Authorization";
    protected static final String HEADER_AUTHORIZATION_PREFIX = "Basic ";
    protected static final String LOGIN_PARAM_PW = "password";
    protected static final String LOGIN_PARAM_USERNAME = "username";
    protected static final String LOGIN_PARAM_GRANT_TYPE_NAME = "grant_type";
    protected static final String GRANT_TYPE_PASSWORD = "password";
    protected static final String GRANT_TYPE_REFRESH_TOKEN = "refresh_token";
    protected static final String OAUTH2_CLIENT_ID = "kit";
    protected static final String OAUTH2_CLIENT_SECRET = "kit";
    public static final String KATONE_SERVER_PROP = "katOneServerUrl";
    public static final String TESTOPS_SERVER_PROP = "testOps.serverUrl";
    public static final int DEFAULT_RETRY_TIMES = 3;
    protected static final long DEFAULT_WAIT_TIME = 7L;
    protected static final long MAX_RETRIES = 10L;
    private String katOneServer;
    private AuthenticationToken katOneToken = new AuthenticationToken();
    private String adminServer;
    private AuthenticationToken adminToken = new AuthenticationToken();
    private String testOpsServer;
    private AuthenticationToken testOpsToken = new AuthenticationToken();
    private String username;
    private String password;
    private boolean isFreezeTestOpsServer;
    protected Timer renewDelayTimer;
    protected Timer renewIntervalTimer;
    protected EventEmitter emitter = new EventEmitter();

    public void assign(BaseTestOpsService<DerivedType> from) {
        this.updateKatOneToken(from.katOneToken);
        this.updateAdminToken(from.adminToken);
        this.updateTestOpsToken(from.testOpsToken);
        this.katOneServer = from.katOneServer;
        this.adminServer = from.adminServer;
        this.testOpsServer = from.testOpsServer;
        this.username = from.username;
        this.password = from.password;
    }

    public DerivedType clone() {
        BaseTestOpsService clone = (BaseTestOpsService)ObjectUtil.clone((Object)this);
        clone.setKatOneToken(this.katOneToken.clone());
        clone.setAdminToken(this.adminToken.clone());
        clone.setTestOpsToken(this.testOpsToken.clone());
        clone.renewDelayTimer = null;
        clone.renewIntervalTimer = null;
        clone.emitter = new EventEmitter();
        return (DerivedType)clone;
    }

    public boolean hasAuthenticationInfo() {
        return this.adminToken.isNotEmpty() || this.testOpsToken.isNotEmpty() || this.katOneToken.isNotEmpty() || StringUtils.isNotBlank((CharSequence)this.password);
    }

    public CombinedAuthenticationToken getCombinedToken() {
        return new CombinedAuthenticationToken(this.getAdminToken(), this.getKatOneToken());
    }

    public AuthenticationToken getKatOneToken() {
        return this.katOneToken;
    }

    public String getKatOneAccessToken() {
        return this.katOneToken.getAccessToken();
    }

    public void setKatOneToken(AuthenticationToken newToken) {
        this.katOneToken = newToken;
    }

    public DerivedType updateKatOneToken(String accessToken) {
        return this.updateKatOneToken(accessToken, null);
    }

    public DerivedType updateKatOneToken(String accessToken, String refreshToken) {
        return this.updateKatOneToken(accessToken, refreshToken, this.getKatOneServer());
    }

    public DerivedType updateKatOneToken(String accessToken, String refreshToken, String server) {
        this.katOneToken.updateTokens(accessToken, refreshToken, server);
        return (DerivedType)this;
    }

    public DerivedType updateKatOneToken(AuthenticationToken token) {
        this.katOneToken.assign(token);
        return (DerivedType)this;
    }

    public AuthenticationToken getAdminToken() {
        return this.adminToken;
    }

    public String getAdminAccessToken() {
        return this.adminToken.getAccessToken();
    }

    public void setAdminToken(AuthenticationToken newToken) {
        this.adminToken = newToken;
    }

    public DerivedType updateAdminToken(String accessToken, String refreshToken) {
        return this.updateAdminToken(accessToken, refreshToken, this.getAdminServer());
    }

    public DerivedType updateAdminToken(AuthenticationToken token) {
        this.adminToken.assign(token);
        return (DerivedType)this;
    }

    public DerivedType updateAdminToken(String accessToken, String refreshToken, String server) {
        this.adminToken.updateTokens(accessToken, refreshToken, server);
        return (DerivedType)this;
    }

    public AuthenticationToken getTestOpsToken() {
        return this.testOpsToken;
    }

    public String getTestOpsAccessToken() {
        return this.testOpsToken.getAccessToken();
    }

    public void setTestOpsToken(AuthenticationToken newToken) {
        this.testOpsToken = newToken;
    }

    public DerivedType updateTestOpsToken(String accessToken, String refreshToken) {
        return this.updateTestOpsToken(accessToken, refreshToken, this.getTestOpsServer());
    }

    public DerivedType updateTestOpsToken(AuthenticationToken token) {
        this.testOpsToken.assign(token);
        return (DerivedType)this;
    }

    public DerivedType updateTestOpsToken(String accessToken, String refreshToken, String server) {
        this.testOpsToken.updateTokens(accessToken, refreshToken, server);
        return (DerivedType)this;
    }

    public String getKatOneServer() {
        return (String)Strings.firstNonBlank((CharSequence[])new String[]{System.getProperty(KATONE_SERVER_PROP), this.katOneServer, "https://api.katalon.com"});
    }

    public DerivedType setKatOneServer(String katOneServer) {
        this.katOneServer = katOneServer;
        return (DerivedType)this;
    }

    public String getAdminServer() {
        return this.adminServer;
    }

    public DerivedType setAdminServer(String adminServer) {
        this.adminServer = adminServer;
        return (DerivedType)this;
    }

    public boolean isFreezeTestOpsServer() {
        return this.isFreezeTestOpsServer;
    }

    public DerivedType setFreezeTestOpsServer(boolean isFreezeTestOpsServer) {
        this.isFreezeTestOpsServer = isFreezeTestOpsServer;
        return (DerivedType)this;
    }

    public String getTestOpsServer() {
        return (String)Strings.firstNonBlank((CharSequence[])new String[]{this.testOpsServer, "https://testops.katalon.io"});
    }

    public DerivedType setTestOpsServer(String testOpsServer) {
        this.testOpsServer = testOpsServer;
        return (DerivedType)this;
    }

    public DerivedType setCredential(String apiKey) {
        return this.setCredential(null, apiKey);
    }

    public DerivedType setCredential(String username, String password) {
        boolean isAPIKey;
        boolean bl = isAPIKey = StringUtils.isBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password);
        boolean isUserChanged = isAPIKey ? !StringUtils.equals((CharSequence)this.password, (CharSequence)password) : !StringUtils.equals((CharSequence)this.username, (CharSequence)username) || !StringUtils.equals((CharSequence)this.password, (CharSequence)password);
        this.username = username;
        this.password = password;
        if (isUserChanged) {
            this.katOneToken.clear();
            this.adminToken.clear();
            this.testOpsToken.clear();
        }
        return (DerivedType)this;
    }

    public void clearCredential() {
        this.username = null;
        this.password = null;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isUsingAPIKeyCredential() {
        return StringUtils.isBlank((CharSequence)this.username) && StringUtils.isNotBlank((CharSequence)this.password);
    }

    public DerivedType setAuthorizationInfo(AuthenticationInfo authInfo) {
        if (authInfo == null) {
            return (DerivedType)this;
        }
        if (authInfo instanceof CombinedAuthenticationToken) {
            AuthenticationToken katOneToken;
            CombinedAuthenticationToken combinedToken = (CombinedAuthenticationToken)authInfo;
            AuthenticationToken adminToken = combinedToken.getAdminToken();
            if (adminToken != null) {
                this.setAdminServer((String)Strings.firstNonBlank((CharSequence[])new String[]{adminToken.getServer(), this.getAdminServer()}));
                this.updateAdminToken(adminToken);
            }
            if ((katOneToken = combinedToken.getKatOneToken()) != null) {
                this.setKatOneServer((String)Strings.firstNonBlank((CharSequence[])new String[]{katOneToken.getServer(), this.getKatOneServer()}));
                this.updateKatOneToken(katOneToken);
            }
        }
        if (authInfo instanceof AuthenticationToken) {
            AuthenticationToken token = (AuthenticationToken)authInfo;
            this.setAdminServer((String)Strings.firstNonBlank((CharSequence[])new String[]{token.getServer(), this.getAdminServer()}));
            this.updateAdminToken(token);
        }
        if (authInfo instanceof AuthenticationCredential) {
            AuthenticationCredential credential = (AuthenticationCredential)authInfo;
            this.setAdminServer((String)Strings.firstNonBlank((CharSequence[])new String[]{credential.getServer(), this.getAdminServer()}));
            this.setCredential(credential.getUsername(), credential.getPassword());
        }
        return (DerivedType)this;
    }

    public boolean testKatOneConnection() throws AnalyticsApiException {
        return this.testConnection(this.getKatOneServer());
    }

    public boolean testAdminConnection() throws AnalyticsApiException {
        return this.testConnection(this.getAdminServer());
    }

    public boolean testTestOpsConnection() throws AnalyticsApiException {
        return this.testConnection(this.getTestOpsServer());
    }

    public boolean testConnection(String serverUrl) throws AnalyticsApiException {
        try {
            URI uri = this.getApiURI(serverUrl, "/info");
            URIBuilder uriBuilder = new URIBuilder(uri);
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            this.sendRequest((HttpUriRequest)httpGet, Object.class);
            return true;
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public void renewTokens(long interval) throws Exception {
        long intervalInMs = interval * 1000L;
        if (this.getAdminToken().isEmpty()) {
            this.scheduleNextRenew(intervalInMs);
            return;
        }
        long renewTime = this.getAdminToken().getCreationTime() + intervalInMs;
        long remainingTime = renewTime - System.currentTimeMillis();
        if (remainingTime <= 0L) {
            this.renewTokens();
            this.scheduleNextRenew(intervalInMs);
        } else {
            this.scheduleNextRenew(Math.max(remainingTime, 0L), intervalInMs);
        }
    }

    public void abortRenewingTokens() {
        if (this.renewDelayTimer != null) {
            this.renewDelayTimer.cancel();
        }
        if (this.renewIntervalTimer != null) {
            this.renewIntervalTimer.cancel();
        }
    }

    private void scheduleNextRenew(long interval) {
        this.scheduleNextRenew(interval, interval);
    }

    private void scheduleNextRenew(long delay, long interval) {
        this.abortRenewingTokens();
        this.renewDelayTimer = TimeUtil.setTimeout(() -> {
            this.renewIntervalTimer = TimeUtil.setInterval(timer -> {
                try {
                    this.renewTokens();
                }
                catch (AnalyticsApiException error) {
                    LogUtil.logError((Throwable)error);
                }
                catch (Exception error) {
                    LogUtil.logError((Throwable)error);
                }
            }, (long)interval);
        }, (long)delay);
    }

    public void renewTokens() throws Exception {
        this.requestAdminToken(true, true);
        this.testOpsToken.assignTokens(this.adminToken);
        if (AuthenticationTokenUtils.isValidKatOneSSORefreshToken(this.katOneToken)) {
            this.refreshKatOneToken(this.katOneToken);
        } else {
            this.katOneToken.clear();
        }
        this.notifyTokenRenewed(this.getCombinedToken());
    }

    public void onTokenRenewed(TokenRenewedListener listener) {
        this.emitter.on((Enum)BaseTestOpsEventType.TOKEN_RENEWED, (EventEmitter.CustomEventListener)listener);
    }

    public void offTokenRenewed(TokenRenewedListener listener) {
        this.emitter.off((Enum)BaseTestOpsEventType.TOKEN_RENEWED, (EventEmitter.CustomEventListener)listener);
    }

    public void notifyTokenRenewed(CombinedAuthenticationToken combinedToken) {
        this.emitter.emit((Enum)BaseTestOpsEventType.TOKEN_RENEWED, (Object)combinedToken);
    }

    protected boolean transferTokenInfo(AnalyticsTokenInfo info, AuthenticationToken token, String server) {
        if (info == null || token == null) {
            return false;
        }
        token.updateTokens(info.getAccess_token(), info.getRefresh_token(), server);
        long now = System.currentTimeMillis();
        token.setCreationTime(Long.valueOf(now));
        if (info.getExpires_in() != null) {
            token.setAccessTokenExpirationTime(Long.valueOf(now + info.getExpires_in() * 1000L));
        }
        if (info.getRefresh_expires_in() != null) {
            token.setRefreshTokenExpirationTime(Long.valueOf(now + info.getRefresh_expires_in() * 1000L));
        }
        return true;
    }

    public AuthenticationToken requestKatOneToken() throws AnalyticsApiException {
        return this.requestKatOneToken(false);
    }

    public AuthenticationToken requestKatOneToken(boolean silent) throws AnalyticsApiException {
        return this.requestKatOneToken(false, silent);
    }

    public AuthenticationToken requestKatOneToken(boolean renew, boolean silent) throws AnalyticsApiException {
        if (!renew && this.katOneToken.isAvailable(this.getKatOneServer())) {
            return this.katOneToken;
        }
        if (AuthenticationTokenUtils.isValidKatOneSSORefreshToken(this.katOneToken)) {
            this.refreshKatOneToken(this.katOneToken);
            return this.katOneToken;
        }
        if (this.adminToken.isNotEmpty()) {
            AdminTokenInfo adminAccessToken = (AdminTokenInfo)this.adminToken.parseAccessToken(AdminTokenInfo.class);
            this.katOneToken.assignTokens(this.adminToken);
            this.updateKatOneToken(adminAccessToken.getKatOneJwt());
            return this.katOneToken;
        }
        try {
            String password = StringUtils.defaultString((String)this.password);
            String email = StringUtils.defaultString((String)this.username);
            if (StringUtils.isBlank((CharSequence)password) && this.adminToken.isNotEmpty()) {
                password = this.fetchAPIKey(silent);
            }
            URIBuilder uriBuilder = this.getKatOneUriBuilder("/v1/auth/login");
            String query = JsonBuilder.object().property("email", (Object)email).property("password", (Object)password).toJson();
            HttpRequestBase request = RequestBuilder.post().uri(uriBuilder).body(query).build();
            KatOneApiTokenInfo tokenInfo = this.sendRequest((HttpUriRequest)request, KatOneApiTokenInfo.class, silent);
            this.updateKatOneToken(tokenInfo.getData().getJwt(), null);
            return this.getKatOneToken();
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public AuthenticationToken requestAdminToken() throws Exception {
        return this.requestAdminToken(false);
    }

    public AuthenticationToken requestAdminToken(boolean silent) throws Exception {
        return this.requestAdminToken(false, silent);
    }

    public synchronized AuthenticationToken requestAdminToken(boolean renew, boolean silent) throws Exception {
        if (this.adminToken != null && this.adminToken.getAccessToken() != null) {
            long currentEpoch = Instant.now().getEpochSecond();
            AuthenticationToken.JwtTokenInfo adminAccessToken = (AuthenticationToken.JwtTokenInfo)this.adminToken.parseAccessToken(AuthenticationToken.JwtTokenInfo.class);
            if (!renew && this.adminToken.isAvailable(this.getAdminServer()) && adminAccessToken.exp() > currentEpoch) {
                return this.adminToken;
            }
        }
        AnalyticsTokenInfo tokenInfo = null;
        boolean isCredentialAvailable = StringUtils.isNotBlank((CharSequence)this.password);
        if (isCredentialAvailable) {
            tokenInfo = this.requestToken(this.getAdminServer(), this.username, this.password, silent);
            this.transferTokenInfo(tokenInfo, this.adminToken, this.getAdminServer());
            this.transferTokenInfo(tokenInfo, this.testOpsToken, this.getTestOpsServer());
        } else {
            CombinedAuthenticationToken combinedToken = ApplicationInfo.getAuthenticationInfo();
            if (StringUtils.compare((String)this.adminToken.getAccessToken(), (String)combinedToken.getAdminToken().getAccessToken()) == 0) {
                AuthenticationToken currentKatOneToken = combinedToken.getKatOneToken();
                AuthenticationToken newKatOneToken = AuthenticationService.getInstance().getKatOneTokenPair(currentKatOneToken);
                if (newKatOneToken != currentKatOneToken) {
                    this.updateKatOneToken(newKatOneToken);
                    tokenInfo = AuthenticationService.getInstance().requestTokenWithForceRefresh(this.getAdminServer(), "", "access_token_" + newKatOneToken.getAccessToken(), silent);
                    this.transferTokenInfo(tokenInfo, this.adminToken, this.getAdminServer());
                    this.transferTokenInfo(tokenInfo, this.testOpsToken, this.getTestOpsServer());
                    ApplicationInfo.setAuthenticationInfo((CombinedAuthenticationToken)this.getCombinedToken());
                }
            }
        }
        return this.getAdminToken();
    }

    public AuthenticationToken requestTestOpsToken() throws AnalyticsApiException {
        return this.requestTestOpsToken(false);
    }

    public synchronized AuthenticationToken requestTestOpsToken(boolean renew) throws AnalyticsApiException {
        if (this.testOpsToken != null && this.testOpsToken.getAccessToken() != null) {
            long currentEpoch = Instant.now().getEpochSecond();
            AuthenticationToken.JwtTokenInfo testOpsAccessToken = (AuthenticationToken.JwtTokenInfo)this.testOpsToken.parseAccessToken(AuthenticationToken.JwtTokenInfo.class);
            if (!renew && this.testOpsToken.isAvailable(this.getTestOpsServer()) && testOpsAccessToken.exp() > currentEpoch) {
                return this.testOpsToken;
            }
        }
        String apiKey = this.fetchAPIKey();
        AnalyticsTokenInfo tokenInfo = this.requestToken(this.getAdminServer(), "", apiKey);
        this.transferTokenInfo(tokenInfo, this.testOpsToken, this.getTestOpsServer());
        return this.getTestOpsToken();
    }

    public void grabKatOneToken(String authUri, String code, String codeVerifier, String clientId, String redirectUri) throws AnalyticsApiException {
        try {
            HttpPost request = AuthenticationService.getInstance().buildRequestToGrabKatOneToken(authUri, code, codeVerifier, clientId, redirectUri);
            AnalyticsTokenInfo analyticsTokenInfo = this.sendRequest((HttpUriRequest)request, AnalyticsTokenInfo.class);
            this.transferTokenInfo(analyticsTokenInfo, this.katOneToken, this.getKatOneServer());
        }
        catch (Exception error) {
            throw AnalyticsApiException.wrap(error);
        }
    }

    public AnalyticsTokenInfo requestToken(String serverUrl, String username, String password) throws AnalyticsApiException {
        return this.requestToken(serverUrl, username, password, false);
    }

    public AnalyticsTokenInfo requestToken(String serverUrl, String username, String password, boolean silent) throws AnalyticsApiException {
        try {
            if (StringUtils.isBlank((CharSequence)password)) {
                throw new AnalyticsApiException("Invalid credential");
            }
            URI uri = this.getApiURI(serverUrl, "/oauth/token");
            URIBuilder uriBuilder = new URIBuilder(uri);
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            nameValuePairs.add(new BasicNameValuePair(LOGIN_PARAM_USERNAME, username));
            nameValuePairs.add(new BasicNameValuePair("password", password));
            nameValuePairs.add(new BasicNameValuePair(LOGIN_PARAM_GRANT_TYPE_NAME, "password"));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nameValuePairs, StandardCharsets.UTF_8);
            HttpPost httpPost = new HttpPost(uriBuilder.build().toASCIIString());
            httpPost.setEntity((HttpEntity)entity);
            String clientCredentials = "kit:kit";
            httpPost.setHeader(HEADER_AUTHORIZATION, HEADER_AUTHORIZATION_PREFIX + Base64.getEncoder().encodeToString(clientCredentials.getBytes()));
            return this.sendRequest((HttpUriRequest)httpPost, AnalyticsTokenInfo.class, silent);
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public void revokeAndClearAllTokens() throws AnalyticsApiException {
        try {
            this.revokeKatOneToken(this.getKatOneToken());
        }
        finally {
            this.clearAllTokens();
            this.username = null;
            this.password = null;
        }
    }

    public void clearAllTokens() {
        this.adminToken.clear();
        this.katOneToken.clear();
        this.testOpsToken.clear();
    }

    public void revokeKatOneToken(AuthenticationToken katOneToken) throws AnalyticsApiException {
        if (!AuthenticationTokenUtils.isValidKatOneSSORefreshToken(katOneToken)) {
            return;
        }
        KatOneJwtTokenInfo tokenInfo = (KatOneJwtTokenInfo)katOneToken.parseRefreshToken(KatOneJwtTokenInfo.class);
        String revokeTokenUri = String.valueOf(AuthenticationService.getInstance().getKeycloakAdminURL()) + "/realms/katalon/protocol/openid-connect/logout";
        this.revokeKatOneToken(katOneToken.getRefreshToken(), revokeTokenUri, tokenInfo.azp);
    }

    public void revokeKatOneToken(String refreshToken, String revokeTokenUri, String clientId) throws AnalyticsApiException {
        try {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{refreshToken, revokeTokenUri, clientId})) {
                return;
            }
            ArrayList<BasicNameValuePair> body = new ArrayList<BasicNameValuePair>();
            body.add(new BasicNameValuePair("client_id", clientId));
            body.add(new BasicNameValuePair(GRANT_TYPE_REFRESH_TOKEN, refreshToken));
            body.add(new BasicNameValuePair(LOGIN_PARAM_GRANT_TYPE_NAME, "authorization_code"));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(body, StandardCharsets.UTF_8);
            HttpPost request = new HttpPost(revokeTokenUri);
            request.setEntity((HttpEntity)entity);
            request.addHeader("Content-Type", "application/x-www-form-urlencoded");
            this.sendRequest((HttpUriRequest)request, Object.class, true);
        }
        catch (Exception error) {
            throw AnalyticsApiException.wrap(error);
        }
    }

    public boolean refreshKatOneToken(AuthenticationToken katOneToken) throws AnalyticsApiException {
        KatOneJwtTokenInfo tokenInfo = (KatOneJwtTokenInfo)katOneToken.parseAccessToken(KatOneJwtTokenInfo.class);
        String refreshTokenUri = String.valueOf(AuthenticationService.getInstance().getKeycloakAdminURL()) + "/realms/katalon/protocol/openid-connect/token";
        AnalyticsTokenInfo refreshedToken = this.refreshKatOneToken(katOneToken.getRefreshToken(), refreshTokenUri, tokenInfo.azp);
        return this.transferTokenInfo(refreshedToken, katOneToken, katOneToken.getServer());
    }

    public AnalyticsTokenInfo refreshKatOneToken(String refreshToken, String ssoRefreshTokenUri, String clientId) throws AnalyticsApiException {
        block3: {
            try {
                if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{refreshToken, ssoRefreshTokenUri, clientId})) break block3;
                return null;
            }
            catch (Exception e) {
                throw AnalyticsApiException.wrap(e);
            }
        }
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair(GRANT_TYPE_REFRESH_TOKEN, refreshToken));
        nameValuePairs.add(new BasicNameValuePair("client_id", clientId));
        nameValuePairs.add(new BasicNameValuePair(LOGIN_PARAM_GRANT_TYPE_NAME, GRANT_TYPE_REFRESH_TOKEN));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nameValuePairs, StandardCharsets.UTF_8);
        HttpPost request = new HttpPost(ssoRefreshTokenUri);
        request.setEntity((HttpEntity)entity);
        request.addHeader("Content-Type", "application/x-www-form-urlencoded");
        return this.sendRequest((HttpUriRequest)request, AnalyticsTokenInfo.class);
    }

    public String fetchAPIKey() throws AnalyticsApiException {
        return this.fetchAPIKey(false);
    }

    public String fetchAPIKey(boolean silent) throws AnalyticsApiException {
        List<AnalyticsApiKey> apiKeys = this.fetchApiKeys(silent);
        String firstAPIKey = apiKeys.isEmpty() ? null : apiKeys.get(0).getKey();
        return firstAPIKey;
    }

    public List<AnalyticsApiKey> fetchApiKeys() throws AnalyticsApiException {
        return this.fetchApiKeys(false);
    }

    public List<AnalyticsApiKey> fetchApiKeys(boolean silent) throws AnalyticsApiException {
        try {
            URIBuilder builder = this.getTestOpsUriBuilder("/api/v1/search");
            String query = JsonBuilder.object().property("type", (Object)"ApiKey").array("conditions", new Object[0]).array("functions", new Object[0]).object("pagination", object -> object.property("page", (Object)0).property("size", (Object)1).array("sorts", new Object[]{"createdAt,asc"})).array("groupBys", new Object[0]).toJson();
            builder.setParameter("q", query);
            HttpGet httpGet = new HttpGet(builder.build().toASCIIString());
            AnalyticsPage<AnalyticsApiKey> result = this.sendAdminRequest((HttpUriRequest)httpGet, new TypeToken<AnalyticsPage<AnalyticsApiKey>>(){}, silent);
            return result.getContent();
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    protected ByteArrayEntity asBodyEntity(Object data) {
        Gson gson = new GsonBuilder().create();
        return new ByteArrayEntity(gson.toJson(data).getBytes(StandardCharsets.UTF_8));
    }

    protected URI getApiURI(String host, String path) throws URISyntaxException {
        if (host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return new URI(String.valueOf(host) + path);
    }

    public URIBuilder getKatOneUriBuilder(String path) throws MalformedURLException, URISyntaxException {
        return this.getUriBuilder(this.getKatOneServer(), path);
    }

    public URIBuilder getAdminUriBuilder(String path) throws MalformedURLException, URISyntaxException {
        return this.getUriBuilder(this.getAdminServer(), path);
    }

    public URIBuilder getTestOpsUriBuilder(String path) throws MalformedURLException, URISyntaxException {
        return this.getUriBuilder(this.getTestOpsServer(), path);
    }

    public URIBuilder getUriBuilder(String server, String path) throws MalformedURLException, URISyntaxException {
        URL url = this.getURL(server, path);
        return new URIBuilder(url.toURI());
    }

    public URL getURL(String server, String path) throws MalformedURLException, URISyntaxException {
        return new URI(path).isAbsolute() ? new URL(path) : new URL(new URL(server), path);
    }

    public <T> T sendAdminRequest(HttpUriRequest request, Class<T> returnType) throws Exception {
        return this.sendAdminRequest(request, TypeToken.of(returnType));
    }

    public <T> T sendAdminRequest(HttpUriRequest request, Class<T> returnType, boolean silent) throws Exception {
        return this.sendAdminRequest(request, TypeToken.of(returnType), silent);
    }

    public <T> T sendAdminRequest(HttpUriRequest request, TypeToken<T> returnType) throws Exception {
        return this.sendAdminRequest(request, returnType, false);
    }

    public <T> T sendAdminRequest(HttpUriRequest request, TypeToken<T> returnType, boolean silent) throws Exception {
        return this.sendRequestWithToken(request, returnType, this.requestAdminToken(), silent);
    }

    public <T> T sendTestOpsRequest(HttpUriRequest request, Class<T> returnType) throws AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        return this.sendTestOpsRequest(request, TypeToken.of(returnType));
    }

    public <T> T sendTestOpsRequest(HttpUriRequest request, Class<T> returnType, boolean silent) throws AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        return this.sendTestOpsRequest(request, TypeToken.of(returnType), silent);
    }

    public <T> T sendTestOpsRequest(HttpUriRequest request, TypeToken<T> returnType) throws AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        return this.sendTestOpsRequest(request, returnType, false);
    }

    public <T> T sendTestOpsRequest(HttpUriRequest request, TypeToken<T> returnType, boolean silent) throws AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        return this.sendRequestWithToken(request, returnType, this.requestTestOpsToken());
    }

    public <T> T sendRequest(HttpUriRequest request, Class<T> returnType) throws AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        return this.sendRequest(request, returnType, false);
    }

    public <T> T sendRequest(HttpUriRequest request, Class<T> returnType, boolean silent) throws AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        return this.sendRequest(request, TypeToken.of(returnType), silent);
    }

    public <T> T sendRequest(HttpUriRequest request, TypeToken<T> returnType) throws AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        return this.sendRequest(request, returnType, null);
    }

    public <T> T sendRequestWithToken(HttpUriRequest request, Class<T> returnType, AuthenticationToken token) throws AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        return this.sendRequestWithToken(request, returnType, token, false);
    }

    public <T> T sendRequestWithToken(HttpUriRequest request, Class<T> returnType, AuthenticationToken token, boolean silent) throws AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        return this.sendRequestWithToken(request, TypeToken.of(returnType), token, silent);
    }

    public <T> T sendRequestWithToken(HttpUriRequest request, TypeToken<T> returnType, AuthenticationToken token) throws AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        return this.sendRequestWithToken(request, returnType, token, false);
    }

    public <T> T sendRequestWithToken(HttpUriRequest request, TypeToken<T> returnType, AuthenticationToken token, boolean silent) throws AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        return this.sendRequest(request, returnType, token.getAccessToken(), silent);
    }

    public <T> T sendRequest(HttpUriRequest request, Class<T> returnType, String token) throws AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        return this.sendRequest(request, TypeToken.of(returnType), token);
    }

    public <T> T sendRequest(HttpUriRequest request, Class<T> returnType, String token, boolean silent) throws AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        return this.sendRequest(request, TypeToken.of(returnType), token, silent);
    }

    public <T> T sendRequest(HttpUriRequest request, TypeToken<T> returnType, String token) throws AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        return this.sendRequest(request, returnType, token, false);
    }

    public <T> T sendRequest(HttpUriRequest request, TypeToken<T> returnType, String token, boolean silent) throws AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        this.applyAuthHeaders(request, token);
        return this.sendRequest(request, returnType, silent);
    }

    public <T> T sendRequest(HttpUriRequest httpRequest, TypeToken<T> typeToken, boolean isSilent) throws ParseException, AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        String responseString = this.sendRequest(httpRequest, isSilent);
        Gson gson = new GsonBuilder().create();
        return (T)gson.fromJson(responseString, typeToken.getType());
    }

    public String sendRequest(HttpUriRequest request, boolean isSilent) throws ParseException, AnalyticsApiException, IOException, URISyntaxException, GeneralSecurityException {
        return this.sendRequest(request, 1, isSilent);
    }

    public String sendRequest(HttpUriRequest request, int retry, boolean isSilent) throws AnalyticsApiException, ParseException, IOException, URISyntaxException, GeneralSecurityException {
        HttpResponse httpResponse = this.buildAndExecuteHttpRequest(request);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        HttpEntity entity = httpResponse.getEntity();
        String responseString = "";
        if (entity != null) {
            responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
        }
        if (statusCode == 200 || statusCode == 201 || statusCode == 204) {
            return responseString;
        }
        if (statusCode == 401) {
            try {
                CombinedAuthenticationToken combinedToken = ApplicationInfo.getAuthenticationInfo();
                if (StringUtils.compare((String)this.adminToken.getAccessToken(), (String)combinedToken.getAdminToken().getAccessToken()) == 0) {
                    AnalyticsTokenInfo adminTokenInfo;
                    AuthenticationToken currentKatOneToken = combinedToken.getKatOneToken();
                    AnalyticsTokenInfo katOneTokenInfo = AuthenticationService.getInstance().refreshKatOneTokenWithRetry(currentKatOneToken);
                    if (katOneTokenInfo != null) {
                        this.transferTokenInfo(katOneTokenInfo, this.getKatOneToken(), this.getKatOneServer());
                    }
                    if ((adminTokenInfo = AuthenticationService.getInstance().requestTokenWithForceRefresh(this.getAdminServer(), "", "access_token_" + this.getKatOneToken().getAccessToken(), true)) != null) {
                        this.transferTokenInfo(adminTokenInfo, this.adminToken, this.getAdminServer());
                        this.transferTokenInfo(adminTokenInfo, this.testOpsToken, this.getTestOpsServer());
                        ApplicationInfo.setAuthenticationInfo((CombinedAuthenticationToken)this.getCombinedToken());
                    }
                    if (retry > 0) {
                        return this.sendRequest(request, --retry, isSilent);
                    }
                }
            }
            catch (Exception e) {
                throw new AnalyticsApiException(e);
            }
        }
        if (500 <= statusCode && statusCode <= 599) {
            throw new AnalyticsApiException(String.valueOf(statusCode));
        }
        if (!isSilent) {
            LogUtil.logError((String)MessageFormat.format("Katalon TestOps: Unexpected response, URL: {0}, Status: {1}, Response: {2}", request.getURI().toString(), statusCode, responseString));
        }
        throw new AnalyticsApiException(responseString);
    }

    protected HttpResponse buildAndExecuteHttpRequest(HttpUriRequest request) throws MalformedURLException, URISyntaxException, IOException, GeneralSecurityException {
        HttpClientProxyBuilder httpClientProxyBuilder = HttpClientProxyBuilder.create((ProxyInformation)ProxyPreferences.getAuthProxyInformation(), (String)request.getURI().toURL().toString());
        String host = request.getURI().getHost();
        boolean json = true;
        if (request instanceof HttpPost var5_6 && postRequest.getEntity() instanceof UrlEncodedFormEntity) {
            json = false;
        }
        this.applyCommonHeaders(request, host, json);
        CloseableHttpClient httpClient = httpClientProxyBuilder.getClientBuilder().build();
        return httpClient.execute(request);
    }

    public HttpResponse sendSimpleRequest(HttpUriRequest httpRequest) throws AnalyticsApiException {
        try {
            HttpClientProxyBuilder httpClientProxyBuilder = HttpClientProxyBuilder.create((ProxyInformation)ProxyPreferences.getAuthProxyInformation(), (String)httpRequest.getURI().toURL().toString());
            CloseableHttpClient httpClient = httpClientProxyBuilder.getClientBuilder().build();
            HttpResponse httpResponse = httpClient.execute(httpRequest);
            return httpResponse;
        }
        catch (Exception e) {
            throw new AnalyticsApiException(e);
        }
    }

    public <T> T sendKatOneRequest(HttpUriRequest request, Class<T> returnType) throws Exception {
        Object result = AuthenticationService.getInstance().sendKatOneRequest(request, TypeToken.of(returnType), this.katOneToken);
        ApplicationInfo.setAuthenticationInfo((CombinedAuthenticationToken)this.getCombinedToken());
        return result;
    }

    public void applyTestOpsHeaders(HttpUriRequest request, boolean json) throws AnalyticsApiException {
        this.applyAuthHeaders(request, this.requestTestOpsToken().getAccessToken());
        this.applyCommonHeaders(request, this.getTestOpsServer(), json);
    }

    public void applyAuthHeaders(HttpUriRequest request, String token) {
        if (StringUtils.isNotBlank((CharSequence)token)) {
            request.setHeader(HEADER_AUTHORIZATION, HEADER_VALUE_AUTHORIZATION_PREFIX + token);
        }
    }

    public void applyCommonHeaders(HttpUriRequest request, String host, boolean json) {
        if (json) {
            request.setHeader("Accept", "application/json");
            request.setHeader("Content-type", "application/json");
        }
        if (StringUtils.isNotBlank((CharSequence)host)) {
            request.setHeader("Origin", host);
            request.setHeader("Referer", host);
        }
        request.setHeader("sec-fetch-mode", "cors");
        request.setHeader("sec-fetch-dest", "empty");
        request.setHeader("sec-fetch-site", "same-site");
    }

    public RequestConfig addRequestTimeout() {
        int CONNECTION_TIMEOUT_MS = 15000;
        return RequestConfig.custom().setConnectionRequestTimeout(CONNECTION_TIMEOUT_MS).setConnectTimeout(CONNECTION_TIMEOUT_MS).setSocketTimeout(CONNECTION_TIMEOUT_MS).build();
    }

    protected static boolean isOkStatus(int statusCode) {
        return statusCode == 200 || statusCode == 201 || statusCode == 204;
    }

    protected static boolean isRetryStatus(int statusCode) {
        return 500 <= statusCode && statusCode <= 599;
    }

    protected static boolean isClientErrorStatus(int statusCode) {
        return 400 <= statusCode && statusCode <= 499;
    }

    public static enum BaseTestOpsEventType {
        TOKEN_RENEWED;

    }

    public static interface TokenRenewedListener
    extends EventEmitter.CustomEventListener<CombinedAuthenticationToken> {
        public void call(CombinedAuthenticationToken var1);
    }
}

