/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics.providers;

import com.google.common.base.Objects;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.integration.analytics.AnalyticsOrganization;
import com.kms.katalon.entity.integration.analytics.AnalyticsOrganizations;
import com.kms.katalon.feature.TestOpsFeatureActivator;
import com.kms.katalon.feature.TestOpsMessageError;
import com.kms.katalon.integration.analytics.entity.AdminTokenInfo;
import com.kms.katalon.integration.analytics.entity.AnalyticsActivationNotice;
import com.kms.katalon.integration.analytics.entity.AnalyticsBaseResource;
import com.kms.katalon.integration.analytics.entity.AnalyticsFeature;
import com.kms.katalon.integration.analytics.entity.AnalyticsLicenseKey;
import com.kms.katalon.integration.analytics.entity.AnalyticsPageBaseResource;
import com.kms.katalon.integration.analytics.entity.AnalyticsUser;
import com.kms.katalon.integration.analytics.entity.TestOpsMessage;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.license.models.AuthenticationInfo;
import com.kms.katalon.license.models.AuthenticationToken;
import com.kms.katalon.logging.LogUtil;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TestOpsFeatureActivatorImpl
implements TestOpsFeatureActivator {
    private static final Long DEFAULT_RENEW_INTERVAL = 86400L;
    private static final String RENEW_INTERVAL_PROPERTY = "tokenRenewInterval";
    private static final String OGR_ID_PROPERTY = "organizationId";
    private static final String DEFAULT_ACCOUNT_ID = "1";

    private static long getRenewInterval() {
        try {
            return Long.valueOf(System.getProperty(RENEW_INTERVAL_PROPERTY));
        }
        catch (Exception error) {
            LogUtil.logError((Throwable)error);
            return DEFAULT_RENEW_INTERVAL;
        }
    }

    private Long getOrganizationIdFromLicense(String licenseJwt) {
        String[] chunks = licenseJwt.split("\\.");
        String payload = new String(Base64.getUrlDecoder().decode(chunks[1]));
        JsonObject data = JsonParser.parseString((String)payload).getAsJsonObject();
        if (data.has(OGR_ID_PROPERTY)) {
            return data.get(OGR_ID_PROPERTY).getAsLong();
        }
        return -1L;
    }

    private String getRoleFromOrganization(Long orgId, List<AnalyticsOrganization> orgs) {
        Optional<AnalyticsOrganization> analyticsOrg;
        if (orgId > 0L && (analyticsOrg = orgs.stream().filter(o -> Objects.equal((Object)orgId, (Object)o.getId())).findFirst()).isPresent()) {
            return analyticsOrg.get().getRole();
        }
        return "";
    }

    public Map<String, String> activate(AuthenticationInfo authInfo, Long organizationId, String sessionId, String hostname, String machineId, String type, String subDomain, boolean isSilentLog) throws Exception {
        TestOpsService testOpsService = TestOpsService.getInstance();
        Map<String, String> licenseInfo = null;
        ApplicationContext context = ApplicationContext.getInstance();
        try {
            testOpsService.setAuthorizationInfo(authInfo);
            testOpsService.requestAdminToken();
            testOpsService.clearCredential();
            try {
                testOpsService.renewTokens(TestOpsFeatureActivatorImpl.getRenewInterval());
            }
            catch (Exception error) {
                LogUtil.logError((Throwable)error);
            }
            licenseInfo = this.getLicense(organizationId, sessionId, hostname, machineId, type, subDomain, isSilentLog);
            Long orgId = this.getOrganizationIdFromLicense(licenseInfo.get("license"));
            String testOpsServer = licenseInfo.get("testopsUrl");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{testOpsServer})) {
                testOpsService.setTestOpsServer(testOpsServer);
                ApplicationInfo.setTestOpsServer((String)testOpsServer);
            }
            if (!StringUtils.equals((CharSequence)context.getUserId(), (CharSequence)licenseInfo.get("userId"))) {
                AnalyticsUser user = testOpsService.getUser();
                String orgRole = this.getRoleFromOrganization(orgId, user.getOrganizations());
                if (StringUtils.isNotEmpty((CharSequence)orgRole)) {
                    licenseInfo.put("orgRole", orgRole);
                }
                if (StringUtils.isBlank((CharSequence)testOpsServer) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{testOpsServer = user.getConfigs().getIoServerUrl()}) && !testOpsService.isFreezeTestOpsServer()) {
                    testOpsService.setTestOpsServer(testOpsServer);
                    ApplicationInfo.setTestOpsServer((String)testOpsServer);
                }
                context.setUserId(user.getEmail());
                context.setExpirationTrial(user.getTrialExpirationDate());
                context.setUserFirstName(user.getFirstName());
            }
            AuthenticationToken adminToken = testOpsService.getAdminToken();
            AuthenticationToken testOpsToken = testOpsService.getTestOpsToken();
            testOpsToken.assign(adminToken);
            testOpsToken.setServer(testOpsService.getTestOpsServer());
        }
        catch (Exception ex) {
            boolean hasUserInfo = context.hasUserData();
            if (!hasUserInfo && testOpsService.getAdminToken().isNotEmpty()) {
                AdminTokenInfo adminTokenInfo = (AdminTokenInfo)testOpsService.getAdminToken().parseAccessToken(AdminTokenInfo.class);
                context.setUserId(adminTokenInfo.getUser_name());
            }
            LogUtil.logError((Throwable)ex);
            throw ex;
        }
        try {
            if (TestOpsService.isUsingOverridingInstance()) {
                TestOpsService.getOverridingInstance().renewTokens(TestOpsFeatureActivatorImpl.getRenewInterval());
            }
        }
        catch (Exception error) {
            LogUtil.logError((Throwable)error);
        }
        return licenseInfo;
    }

    public Set<String> getFeatures(long organizationId, String ksVersion) {
        try {
            List<AnalyticsFeature> features = TestOpsService.getInstance().getFeatures(organizationId, ksVersion);
            Set<String> featureKeys = features.stream().map(AnalyticsFeature::getKey).collect(Collectors.toSet());
            return featureKeys;
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
            return new HashSet<String>();
        }
    }

    public Map<String, String> getLicense(Long organizationId, String sessionId, String hostname, String machineId, String type, String subDomain, boolean isSilentLog) throws Exception {
        AnalyticsLicenseKey analyticsLicenseKey = TestOpsService.getInstance().getLicenseKey(organizationId, sessionId, hostname, machineId, type, subDomain, isSilentLog);
        if (analyticsLicenseKey.getValue() != null) {
            String userId;
            HashMap<String, String> respond = new HashMap<String, String>();
            respond.put("license", analyticsLicenseKey.getValue());
            respond.put("errorMessage", analyticsLicenseKey.getErrorMessage());
            AnalyticsActivationNotice activationNotice = analyticsLicenseKey.getActivationNotice();
            if (activationNotice != null) {
                respond.put("noticeCode", activationNotice.getCode());
                respond.put("noticeMessage", activationNotice.getMessage());
            }
            if (StringUtils.isNotBlank((CharSequence)analyticsLicenseKey.getPublicKey())) {
                respond.put("publicKey", analyticsLicenseKey.getPublicKey());
            }
            respond.put("testopsUrl", analyticsLicenseKey.getTestopsUrl());
            respond.put("testopsPlan", analyticsLicenseKey.getTestopsPlan());
            if (analyticsLicenseKey.getUser() != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{userId = analyticsLicenseKey.getUser().getId()})) {
                respond.put("userId", userId);
            }
            if (analyticsLicenseKey.getOrganization() != null) {
                String accountId = analyticsLicenseKey.getOrganization().getAccountId() != null ? analyticsLicenseKey.getOrganization().getAccountId().toString() : DEFAULT_ACCOUNT_ID;
                respond.put("accountId", accountId);
                String subdomainUrl = analyticsLicenseKey.getOrganization().getSubdomainUrl();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{subdomainUrl})) {
                    respond.put("testopsUrl", subdomainUrl);
                }
            }
            return respond;
        }
        return null;
    }

    public void releaseLicense(String machineId, String ksVersion, String sessionId, Long orgId) throws Exception {
        try {
            TestOpsService.getInstance().releaseLicense(machineId, ksVersion, sessionId, orgId);
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
            throw ex;
        }
    }

    public String getOrganization(long orgId) throws Exception {
        AnalyticsOrganization organization = TestOpsService.getInstance().getOrganization(orgId);
        return JsonUtil.toJson((Object)organization);
    }

    public String getTestOpsMessage(String message) {
        Gson gson = new GsonBuilder().create();
        TestOpsMessage testOpsMessage = (TestOpsMessage)gson.fromJson(message, TestOpsMessage.class);
        String reponseMessage = "";
        reponseMessage = !StringUtils.isEmpty((CharSequence)testOpsMessage.getMessage()) ? testOpsMessage.getMessage() : (!StringUtils.isEmpty((CharSequence)testOpsMessage.getError_description()) ? testOpsMessage.getError_description() : testOpsMessage.getError());
        return reponseMessage;
    }

    public void getTestOpsErrorMessage(String message, TestOpsMessageError errorMessage) {
        Gson gson = new GsonBuilder().create();
        TestOpsMessage testOpsMessage = (TestOpsMessage)gson.fromJson(message, TestOpsMessage.class);
        errorMessage.setError(testOpsMessage.getError());
        errorMessage.setStatus(testOpsMessage.getStatus());
        errorMessage.setMessage(this.getTestOpsMessage(message));
        if (!errorMessage.isEmpty()) {
            errorMessage.setHasError(true);
        }
    }

    public String getMostRecentUserSessionId(String machineId, Long orgId) throws Exception {
        AnalyticsPageBaseResource userSession = TestOpsService.getInstance().getUserSession(machineId, orgId);
        AnalyticsBaseResource[] content = userSession.getContent();
        if (content != null && content.length > 0) {
            return userSession.getContent()[0].getSessionId();
        }
        return null;
    }

    public void deactivate(String machineId, Long orgId) throws Exception {
        try {
            TestOpsService testOpsService = TestOpsService.getInstance();
            testOpsService.deactivate(machineId, orgId);
            testOpsService.revokeAndClearAllTokens();
            testOpsService.abortRenewingTokens();
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
            throw ex;
        }
    }

    public boolean testConnection(String serverUrl, StringBuilder errorStatusCode) throws Exception {
        try {
            return TestOpsService.getInstance().testConnection(serverUrl);
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
            if (errorStatusCode != null) {
                try {
                    int statusCode = Integer.parseInt(ex.getMessage());
                    errorStatusCode.append(statusCode);
                }
                catch (NumberFormatException e) {
                    LogUtil.logError((Throwable)e, (String)"Cannot parse status code");
                    errorStatusCode.append(500);
                }
            }
            return false;
        }
    }

    public String getCurrentUserEmail() throws Exception {
        return ApplicationContext.getInstance().getUserId();
    }

    public String getOrganizations() throws Exception {
        List<AnalyticsOrganization> organizations = TestOpsService.getInstance().getOrganizations();
        return JsonUtil.toJson((Object)new AnalyticsOrganizations(organizations));
    }
}

