/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics.report;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.ZipUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.entity.ReportFolder;
import com.kms.katalon.integration.analytics.AnalyticsComponent;
import com.kms.katalon.integration.analytics.constants.IntegrationAnalyticsMessages;
import com.kms.katalon.integration.analytics.entity.AnalyticsExecution;
import com.kms.katalon.integration.analytics.entity.AnalyticsFileInfo;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTestRun;
import com.kms.katalon.integration.analytics.entity.AnalyticsTracking;
import com.kms.katalon.integration.analytics.entity.AnalyticsUploadInfo;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.integration.analytics.report.AnalyticsReportHelper;
import com.kms.katalon.integration.analytics.report.AnalyticsReportIntegration;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import com.kms.katalon.integration.analytics.util.FileUtils;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AnalyticsReportService
implements AnalyticsComponent {
    public boolean isIntegrationEnabled() {
        boolean isIntegrationEnabled = false;
        try {
            isIntegrationEnabled = this.getSettingStore().isIntegrationEnabled();
        }
        catch (Exception exception) {}
        return isIntegrationEnabled;
    }

    public boolean isAutoUploadAllTestReports() {
        boolean isAutoUploadAllTestReports = false;
        try {
            isAutoUploadAllTestReports = this.getSettingStore().isAutoUploadReportEnabled();
        }
        catch (Exception exception) {}
        return isAutoUploadAllTestReports;
    }

    public void upload(ReportFolder reportFolder) throws AnalyticsApiException {
        if (this.isIntegrationEnabled() && this.isAutoUploadAllTestReports() && AnalyticsReportHelper.getInstance().isTestopsIntegrationEnabled()) {
            this.uploadReports(reportFolder, false);
        } else {
            LogUtil.printOutputLine((String)IntegrationAnalyticsMessages.MSG_INTEGRATE_WITH_KA);
        }
    }

    public void uploadManually(ReportFolder reportFolder) throws AnalyticsApiException {
        this.uploadReports(reportFolder, true);
    }

    public void uploadReports(ReportFolder reportFolder, boolean isManually) throws AnalyticsApiException {
        LogUtil.printOutputLine((String)IntegrationAnalyticsMessages.MSG_SEND_TEST_RESULT_START);
        try {
            TestOpsService testOpsService = TestOpsService.getActiveInstance();
            if (testOpsService.hasAuthenticationInfo()) {
                this.perform(reportFolder, isManually);
            } else {
                LogUtil.printOutputLine((String)IntegrationAnalyticsMessages.MSG_REQUEST_TOKEN_ERROR);
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)IntegrationAnalyticsMessages.MSG_SEND_ERROR);
            throw AnalyticsApiException.wrap(e);
        }
        LogUtil.printOutputLine((String)IntegrationAnalyticsMessages.MSG_SEND_TEST_RESULT_END);
    }

    private void perform(ReportFolder reportFolder, boolean isManually) throws Exception {
        if (reportFolder.isRunTestSuite()) {
            LogUtil.printOutputLine((String)"Uploading log files of test suite");
        } else {
            LogUtil.printOutputLine((String)"Uploading log files of test suite collection");
        }
        AnalyticsSettingStore settingStore = this.getSettingStore();
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        Long projectId = null;
        if (ApplicationInfo.isPlatformStudio()) {
            projectId = this.getSettingStore().getProject().getId();
        } else {
            AnalyticsReportIntegration.getConsoleOption("testOpsProjectId").getValue();
            if (projectId == null) {
                AnalyticsProject analyticsProject = isManually ? settingStore.getManualProject() : settingStore.getProject();
                projectId = analyticsProject.getId();
            } else {
                LogUtil.logInfo((String)("TestOps project is overridden to " + projectId));
            }
        }
        List<Path> files = this.scanFiles(reportFolder);
        long timestamp = System.currentTimeMillis();
        Path reportLocation = Paths.get(FolderController.getInstance().getReportRoot(project).getLocation(), new String[0]);
        TestOpsService testOpsService = AnalyticsReportHelper.getInstance().getTestOpsService();
        List<AnalyticsExecution> executions = null;
        if ("s3".equalsIgnoreCase("s3")) {
            List<AnalyticsUploadInfo> uploadInfoList = testOpsService.getMultipleUploadInfo(projectId, files.size());
            ArrayList<AnalyticsFileInfo> fileInfoList = new ArrayList<AnalyticsFileInfo>();
            int i = 0;
            while (i < files.size()) {
                Path filePath = files.get(i);
                String folderPath = reportLocation.relativize(filePath.getParent()).toString();
                boolean isEnd = i == files.size() - 1;
                File file = filePath.toFile();
                LogUtil.printOutputLine((String)("Sending file: " + filePath.toAbsolutePath()));
                AnalyticsUploadInfo uploadInfo = uploadInfoList.get(i);
                TestOpsService.getActiveInstance().uploadFileWithRetry(uploadInfo.getUploadUrl(), file);
                AnalyticsFileInfo fileInfo = new AnalyticsFileInfo();
                fileInfo.setFolderPath(folderPath);
                fileInfo.setFileName(file.getName());
                fileInfo.setUploadedPath(uploadInfo.getPath());
                fileInfo.setEnd(isEnd);
                fileInfoList.add(fileInfo);
                ++i;
            }
            executions = testOpsService.uploadMultipleFileInfo(projectId, timestamp, fileInfoList);
        } else {
            int i = 0;
            while (i < files.size()) {
                Path filePath = files.get(i);
                String folderPath = reportLocation.relativize(filePath.getParent()).toString();
                boolean isEnd = i == files.size() - 1;
                LogUtil.printOutputLine((String)("Sending file: " + filePath.toAbsolutePath()));
                executions = testOpsService.sendLog(projectId, timestamp, folderPath, filePath.toFile(), isEnd);
                ++i;
            }
        }
        if (executions != null && !executions.isEmpty()) {
            executions.stream().filter(execution -> execution != null).forEach(execution -> LogUtil.printOutputLine((String)MessageFormat.format(IntegrationAnalyticsMessages.MSG_EXECUTION_URL, execution.getWebUrl())));
        }
    }

    private List<Path> scanFiles(ReportFolder reportFolder) {
        ArrayList<Path> files = new ArrayList<Path>();
        for (String path : reportFolder.getReportFolders()) {
            this.addToList(files, this.scanHarFiles(path));
            this.addToList(files, this.scanFilesWithFilter(path, true, "(.*(?i)(?<!\\.|\\.zip|\\.har)$)"));
        }
        return files;
    }

    private List<Path> scanHarFiles(String path) {
        List<Path> harFiles = this.scanFilesWithFilter(path, true, "([^\\s]+(\\.(?i)(har))$)");
        if (harFiles == null || harFiles.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Path zipFile = FileUtils.createTemporaryFile(String.valueOf(StringUtils.appendIfMissing((String)path, (CharSequence)File.separator, (CharSequence[])new CharSequence[0])) + "katalon-analytics-tmp", "hars-", ".zip");
            Path harsZipFile = ZipUtil.compress(harFiles, (Path)zipFile);
            return Arrays.asList(harsZipFile);
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e, (String)"Could not compress har files");
            return harFiles;
        }
    }

    private void addToList(List<Path> files, List<Path> other) {
        if (!other.isEmpty()) {
            files.addAll(other);
        }
    }

    private List<Path> scanFilesWithFilter(String path, boolean isScan, String pattern) {
        if (isScan) {
            return FileUtils.scanFiles(path, pattern);
        }
        return new ArrayList<Path>();
    }

    public void updateExecutionProccess(AnalyticsTestRun testRun) throws AnalyticsApiException {
        try {
            TestOpsService testOpsService = AnalyticsReportHelper.getInstance().getTestOpsService();
            if (!testOpsService.hasAuthenticationInfo()) {
                LogUtil.printOutputLine((String)IntegrationAnalyticsMessages.MSG_REQUEST_TOKEN_ERROR);
                return;
            }
            Long projectId = null;
            if (ApplicationInfo.isPlatformStudio()) {
                projectId = this.getSettingStore().getProject().getId();
            } else {
                AnalyticsReportIntegration.getConsoleOption("testOpsProjectId").getValue();
                if (projectId == null) {
                    projectId = this.getSettingStore().getProject().getId();
                }
            }
            testOpsService.updateTestRunResult(projectId, testRun);
        }
        catch (AnalyticsApiException e) {
            LogUtil.logError((Throwable)e, (String)IntegrationAnalyticsMessages.MSG_SEND_ERROR);
            throw AnalyticsApiException.wrap(e);
        }
    }

    public void sendTrackingActivity(AnalyticsTracking trackingInfo) {
        try {
            TestOpsService testOpsService = TestOpsService.getInstance();
            if (!testOpsService.hasAuthenticationInfo()) {
                return;
            }
            testOpsService.sendTrackingActivity(trackingInfo);
        }
        catch (AnalyticsApiException e) {
            LogUtil.logError((Throwable)e, (String)IntegrationAnalyticsMessages.MSG_SEND_ERROR);
        }
    }
}

