/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics.setting;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.TestOpsServerURL;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.integration.analytics.AnalyticsOrganization;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeam;
import com.kms.katalon.integration.analytics.entity.AnalyticsTestProject;
import com.kms.katalon.integration.analytics.entity.GitRepositoryEntity;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.util.CryptoUtil;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class AnalyticsSettingStore
extends BundleSettingStore {
    public AnalyticsSettingStore(String projectDir) {
        super(projectDir, "com.kms.katalon.integration.analytics", false);
    }

    public static AnalyticsSettingStore getStore() {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        if (projectEntity == null) {
            return null;
        }
        return new AnalyticsSettingStore(projectEntity.getFolderLocation());
    }

    public boolean isIntegrationEnabled() {
        try {
            return this.getBoolean("analytics.integration.enable", false);
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return false;
        }
    }

    public void enableIntegration(boolean enabled) throws IOException {
        this.setProperty("analytics.integration.enable", enabled);
    }

    public boolean isTestCloudIntegrationEnabled() {
        try {
            return this.getBoolean("analytics.testcloud.integration.enable", true);
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return false;
        }
    }

    public void enableTestCloudIntegration(boolean enabled) throws IOException {
        this.setProperty("analytics.testcloud.integration.enable", enabled);
    }

    public boolean isAutoUploadReportEnabled() {
        try {
            return this.getBoolean("analytics.testreport.autoupload.enable", true);
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return false;
        }
    }

    public void enableAutoUploadReport(boolean enabled) throws IOException {
        this.setProperty("analytics.testreport.autoupload.enable", enabled);
    }

    public String getServerEndpoint() {
        RunningMode runMode = ApplicationRunningMode.get();
        if (runMode == RunningMode.CONSOLE && StringUtils.isNotBlank((CharSequence)TestOpsServerURL.get())) {
            return ApplicationInfo.getTestOpsServer();
        }
        if (this.isOverrideAuthentication()) {
            return this.getServerEndpointOnPremise();
        }
        return this.getServerEndpointCloud();
    }

    public String getServerEndpointCloud() {
        return ApplicationInfo.getTestOpsServer();
    }

    public String getServerEndpointOnPremise() {
        try {
            return this.getString("analytics.onpremise.server", "");
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            return "";
        }
    }

    public void setServerEndPointOnPremise(String serverEndpoint) throws IOException {
        this.setProperty("analytics.onpremise.server", serverEndpoint);
    }

    public String getAuthenticationEndpoint() {
        if (this.isOverrideAuthentication()) {
            return this.getServerEndpointOnPremise();
        }
        return this.getAuthenticationEndpointCloud();
    }

    public String getAuthenticationEndpointCloud() {
        return ApplicationInfo.getAdminServer();
    }

    public String getEmail() {
        return this.getEmailOnPremise();
    }

    public String getEmailOnPremise() {
        try {
            return this.getString("onpremise.email", "");
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            return "";
        }
    }

    public void setEmailOnPremise(String email) throws IOException {
        this.setProperty("onpremise.email", email);
    }

    public String getPassword() {
        return this.getPasswordOnPremise();
    }

    public String getPasswordOnPremise() {
        try {
            String encryptedPassword = this.getString("onpremise.password", "");
            if (!StringUtils.isEmpty((CharSequence)encryptedPassword)) {
                return CryptoUtil.decode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)encryptedPassword));
            }
        }
        catch (IOException | GeneralSecurityException e) {
            LogUtil.logError((Throwable)e);
        }
        return "";
    }

    public void setPasswordOnPremise(String rawPassword) throws GeneralSecurityException, IOException {
        String encryptedPassword = CryptoUtil.encode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)rawPassword));
        this.setProperty("onpremise.password", encryptedPassword);
    }

    public AnalyticsProject getProject() {
        try {
            String projectJson = this.getString("analytics.project", "");
            if (StringUtils.isNotBlank((CharSequence)projectJson) || !StringUtils.contains((CharSequence)projectJson, (CharSequence)"null")) {
                AnalyticsProject project = new AnalyticsProject();
                project = (AnalyticsProject)JsonUtil.fromJson((String)projectJson, AnalyticsProject.class);
                return project;
            }
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return null;
    }

    public void setProject(AnalyticsProject project) throws IOException {
        this.setProperty("analytics.project", JsonUtil.toJson((Object)project));
    }

    public AnalyticsProject getManualProject() {
        try {
            String projectJson = this.getString("analytics.manual.project", "");
            if (StringUtils.isNotBlank((CharSequence)projectJson) || !StringUtils.contains((CharSequence)projectJson, (CharSequence)"null")) {
                AnalyticsProject project = new AnalyticsProject();
                project = (AnalyticsProject)JsonUtil.fromJson((String)projectJson, AnalyticsProject.class);
                return project;
            }
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return this.getProject();
    }

    public void setManualProject(AnalyticsProject project) throws IOException {
        this.setProperty("analytics.manual.project", JsonUtil.toJson((Object)project));
    }

    public AnalyticsTeam getTeam() {
        try {
            String teamJson = this.getString("analytics.team", "");
            if (StringUtils.isNotBlank((CharSequence)teamJson)) {
                AnalyticsTeam team = new AnalyticsTeam();
                team = (AnalyticsTeam)JsonUtil.fromJson((String)teamJson, AnalyticsTeam.class);
                return team;
            }
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return null;
    }

    public void setTeam(AnalyticsTeam team) throws IOException {
        this.setProperty("analytics.team", JsonUtil.toJson((Object)team));
    }

    public AnalyticsTeam getManualTeam() {
        try {
            String teamJson = this.getString("analytics.manual.team", "");
            if (StringUtils.isNotBlank((CharSequence)teamJson)) {
                AnalyticsTeam team = new AnalyticsTeam();
                team = (AnalyticsTeam)JsonUtil.fromJson((String)teamJson, AnalyticsTeam.class);
                return team;
            }
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return this.getTeam();
    }

    public void setManualTeam(AnalyticsTeam team) throws IOException {
        this.setProperty("analytics.manual.team", JsonUtil.toJson((Object)team));
    }

    public String getToken() throws IOException, GeneralSecurityException {
        return this.getStringProperty("analytics.authentication.token", "", true);
    }

    public void setToken(String token) throws IOException, GeneralSecurityException {
        this.setStringProperty("analytics.authentication.token", token, true);
    }

    public boolean isAutoSubmit() throws IOException {
        return this.getBoolean("analytics.testresult.autosubmit", false);
    }

    public void setAutoSubmit(boolean autoSubmit) throws IOException {
        this.setProperty("analytics.testresult.autosubmit", autoSubmit);
    }

    public boolean isAttachScreenshot() throws IOException {
        return this.getBoolean("analytics.testresult.attach.screenshot", false);
    }

    public void setAttachScreenshot(boolean attachScreenshot) throws IOException {
        this.setProperty("analytics.testresult.attach.screenshot", attachScreenshot);
    }

    public boolean isAttachLog() throws IOException {
        return this.getBoolean("analytics.testresult.attach.log", false);
    }

    public void setAttachLog(boolean attachLog) throws IOException {
        this.setProperty("analytics.testresult.attach.log", attachLog);
    }

    public boolean isAttachCapturedVideos() throws IOException {
        return this.getBoolean("analytics.testresult.attach.capturedvideos", false);
    }

    public void setAttachCapturedVideos(boolean capturedVideos) throws IOException {
        this.setProperty("analytics.testresult.attach.capturedvideos", capturedVideos);
    }

    public AnalyticsOrganization getOrganization() {
        AnalyticsTeam team;
        if (this.isOverrideAuthentication()) {
            return this.getOrganizationOnPremise();
        }
        if (ApplicationRunningMode.get() == RunningMode.CONSOLE && (team = this.getTeam()) != null) {
            return team.getOrganization();
        }
        return this.getOrganizationCloud();
    }

    public AnalyticsOrganization getOrganizationCloud() {
        String jsonObject = ApplicationInfo.getAppProperty((String)"organization");
        if (StringUtils.isNotBlank((CharSequence)jsonObject)) {
            try {
                AnalyticsOrganization org = (AnalyticsOrganization)JsonUtil.fromJson((String)jsonObject, AnalyticsOrganization.class);
                return StringUtils.isNotBlank((CharSequence)org.getName()) ? org : null;
            }
            catch (IllegalArgumentException e) {
                LogUtil.logError((Throwable)e);
            }
        }
        return null;
    }

    public AnalyticsOrganization getOrganizationOnPremise() {
        try {
            String orgJson = this.getString("analytics.onpremise.organization", "");
            if (StringUtils.isNotBlank((CharSequence)orgJson)) {
                AnalyticsOrganization org = new AnalyticsOrganization();
                org = (AnalyticsOrganization)JsonUtil.fromJson((String)orgJson, AnalyticsOrganization.class);
                return org;
            }
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return null;
    }

    public void setOrganizationOnPremise(AnalyticsOrganization organization) throws IOException {
        this.setProperty("analytics.onpremise.organization", JsonUtil.toJson((Object)organization));
    }

    public void removeProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("analytics.server.endpoint");
        properties.add("analytics.authentication.email");
        properties.add("analytics.authentication.password");
        properties.add("analytics.testresult.autosubmit");
        properties.add("analytics.testresult.attach.screenshot");
        properties.add("analytics.testresult.attach.log");
        properties.add("analytics.testresult.attach.capturedvideos");
        properties.add("analytics.authentication.encryptionEnabled");
        try {
            this.removeProperties(properties);
        }
        catch (IOException iOException) {}
    }

    public void setOverrideAuthentication(boolean isEnableOverride) throws IOException {
        this.setProperty("analytics.onpremise.enable", isEnableOverride);
    }

    public boolean isOverrideAuthentication() {
        try {
            return this.getBoolean("analytics.onpremise.enable", false);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void setLastLinkedTestProject(AnalyticsTestProject testProject) throws IOException {
        this.setProperty("analytics.test.project.last.linked", JsonUtil.toJson((Object)testProject));
    }

    public AnalyticsTestProject getLastLinkedTestProject() {
        try {
            return (AnalyticsTestProject)JsonUtil.fromJson((String)this.getString("analytics.test.project.last.linked", null), AnalyticsTestProject.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setGitRepositoryEntity(GitRepositoryEntity gitRepositoryEntity) throws IOException {
        this.setProperty("analytics.git", JsonUtil.toJson((Object)gitRepositoryEntity));
    }

    public GitRepositoryEntity getGitRepositoryEntity() {
        try {
            String gitRepoJson = this.getString("analytics.git", "");
            if (StringUtils.isNotBlank((CharSequence)gitRepoJson) || !StringUtils.contains((CharSequence)gitRepoJson, (CharSequence)"null")) {
                GitRepositoryEntity gitRepo = new GitRepositoryEntity();
                gitRepo = (GitRepositoryEntity)JsonUtil.fromJson((String)gitRepoJson, GitRepositoryEntity.class);
                return gitRepo;
            }
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return null;
    }
}

