/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.util;

import com.kms.katalon.composer.components.ComponentBundleActivator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTColorHelper;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class ColorUtil {
    private static final Map<String, Color> colorMap = new HashMap<String, Color>();
    private static final String DEFAULT_COMPOSITE_BACKGROUND_COLOR_FOR_DARK_THEME = "#2F2E2F";
    private static final String DEFAULT_COMPOSITE_BACKGROUND_COLOR_FOR_DARK_THEME_DIALOG = "#505658";
    private static final String EVEN_TABLE_ITEM_BACKGROUND_COLOR = "#87cefa";
    private static final String ODD_TABLE_ITEM_BACKGROUND_COLOR = "#f3f3f3";
    public static final String PASSED_LOG_BACKGROUND_COLOR = "#5bb135";
    public static final String FAILED_LOG_BACKGROUND_COLOR = "#ce2c2c";
    private static final String ERROR_LOG_BACKGROUND_COLOR = "#ec5c51";
    private static final String SKIPPED_LOG_COLOR = "#696e76";
    private static final String WARNING_LOG_BACKGROUND_COLOR = "#ffd54f";
    private static final String INCOMPLETE_LOG_COLOR = "#997515";
    public static final String FAILED_STATUS_BACKGROUND_COLOR = "#f19696";
    public static final String INCOMPLETE_STATUS_BACKGROUND_COLOR = "#f2bc70";
    private static final String EXTRA_LIGHT_GRAY_COLOR = "#f6f6f6";
    private static final String TEXT_PLACEHOLDER_COLOR = "#dadada";
    private static final String TOOLTIP_TEXT_COLOR = "#645454";
    private static final String DEFAULT_COMPOSITE_BACKGROUND_COLOR = "#f0f0f0";
    private static final String ERROR_BACKGROUND_COLOR = "#f8cbcb";
    private static final String ERROR_TEXT_COLOR = "#d50000";
    private static final String WARNING_TEXT_COLOR = "#ff8000";
    private static final String TOOLBAR_BACKGROUND_COLOR = "#e8e8e8";
    private static final String COMPOSITE_HEADER_BACKGROUND_COLOR = "#43515a";
    private static final String DISABLED_TEXT_COLOR = "#bdbdbd";
    private static final String DISABLED_TEXT_COLOR_FOR_DARK_THEME = "#616161";
    private static final String SELECTED_ITEM_BLUE_COLOR = "#007AFF";
    public static final Color PRIMARY_COLOR = ColorUtil.getColor("#009AFF");
    public static final Color PRIMARY_HOVER_COLOR = ColorUtil.getColor("#00BAFF");
    public static final Color PRIMARY_ACTIVE_COLOR = ColorUtil.getColor("#007ADF");
    public static final Color GRAY_LIGHT_COLOR = ColorUtil.getColor("#F5F5F5");
    public static final Color GRAY_COLOR = ColorUtil.getColor("#F0F0F0");
    public static final Color GRAY_DARK_COLOR = ColorUtil.getColor("#DDDDDD");
    public static final Color BLUE_DARK_COLOR;
    public static final Color GRAY_BADGE_COLOR;
    public static final Color GRAY_BADGE_BACKGROUND;
    public static final Color GRAY_BADGE_HOVER_COLOR;
    public static final Color GRAY_BADGE_ACTIVE_COLOR;
    private static Display display;

    static {
        GRAY_BADGE_COLOR = BLUE_DARK_COLOR = ColorUtil.getColor("#09092E");
        GRAY_BADGE_BACKGROUND = ColorUtil.getColor("#EAEAEA");
        GRAY_BADGE_HOVER_COLOR = ColorUtil.getColor("#d5d5d5");
        GRAY_BADGE_ACTIVE_COLOR = ColorUtil.getColor("#6b6e72");
        display = Display.getCurrent();
    }

    public static Color getColor(int red, int green, int blue) {
        String hexColor = String.format("#%02X%02X%02X", red, green, blue);
        return ColorUtil.getColor(hexColor);
    }

    public static Color getColor(String hexColor) {
        String normalizedHexColor = StringUtils.lowerCase((String)hexColor);
        if (StringUtils.isBlank((String)normalizedHexColor)) {
            return null;
        }
        if (!normalizedHexColor.startsWith("#")) {
            normalizedHexColor = "#" + normalizedHexColor;
        }
        if (normalizedHexColor.length() == 4 || normalizedHexColor.length() == 5) {
            normalizedHexColor = normalizedHexColor.replaceAll("(\\w)", "$1$1");
        }
        if (normalizedHexColor.length() > 7) {
            normalizedHexColor = normalizedHexColor.substring(0, 7);
        }
        if (colorMap.containsKey(normalizedHexColor)) {
            if (!colorMap.get(normalizedHexColor).isDisposed()) {
                return colorMap.get(normalizedHexColor);
            }
            colorMap.remove(normalizedHexColor);
        }
        Color color = new Color((Device)display, CSSSWTColorHelper.getRGBA((String)normalizedHexColor));
        colorMap.put(normalizedHexColor, color);
        return color;
    }

    public static Color getSelectedTableItemBackgroundColor() {
        return ColorUtil.getColor(SELECTED_ITEM_BLUE_COLOR);
    }

    public static Color getEvenTableItemBackgroundColor() {
        return ColorUtil.getColor(EVEN_TABLE_ITEM_BACKGROUND_COLOR);
    }

    public static Color getOddTableItemBackgroundColor() {
        return ColorUtil.getColor(ODD_TABLE_ITEM_BACKGROUND_COLOR);
    }

    public static Color getCompositeBackgroundColor() {
        if (ComponentBundleActivator.isDarkTheme(display)) {
            return ColorUtil.getColor(DEFAULT_COMPOSITE_BACKGROUND_COLOR_FOR_DARK_THEME);
        }
        return ColorUtil.getColor(DEFAULT_COMPOSITE_BACKGROUND_COLOR);
    }

    public static Color getPartBackgroundColor() {
        if (ComponentBundleActivator.isDarkTheme(display)) {
            return ColorUtil.getColor(DEFAULT_COMPOSITE_BACKGROUND_COLOR_FOR_DARK_THEME);
        }
        return ColorUtil.getWhiteBackgroundColor();
    }

    public static Color getCompositeBackgroundColorForDialog() {
        if (ComponentBundleActivator.isDarkTheme(display)) {
            return ColorUtil.getColor(DEFAULT_COMPOSITE_BACKGROUND_COLOR_FOR_DARK_THEME_DIALOG);
        }
        return ColorUtil.getWhiteBackgroundColor();
    }

    public static Color getCompositeBackgroundColorForHoverMenuItem() {
        if (ComponentBundleActivator.isDarkTheme(display)) {
            return ColorUtil.getColor(DEFAULT_COMPOSITE_BACKGROUND_COLOR_FOR_DARK_THEME);
        }
        return ColorUtil.getColor(DEFAULT_COMPOSITE_BACKGROUND_COLOR);
    }

    public static Color getCompositeBackgroundColorForSashform() {
        if (ComponentBundleActivator.isDarkTheme(display)) {
            return ColorUtil.getColor(DEFAULT_COMPOSITE_BACKGROUND_COLOR_FOR_DARK_THEME_DIALOG);
        }
        return ColorUtil.getDefaultBackgroundColor();
    }

    public static Color getCompositeHeaderBackgroundColor() {
        return ColorUtil.getColor(COMPOSITE_HEADER_BACKGROUND_COLOR);
    }

    public static Color getHighlightBackgroundColor() {
        if (ComponentBundleActivator.isDarkTheme(display)) {
            return ColorUtil.getColor("#ef6c00");
        }
        return ColorUtil.getColor("#ffeb3b");
    }

    public static Color getWhiteBackgroundColor() {
        return display.getSystemColor(1);
    }

    public static Color getBlackBackgroundColor() {
        return display.getSystemColor(2);
    }

    public static Color getButtonMouseOverBackgroundColor() {
        return ColorUtil.getColor(TOOLBAR_BACKGROUND_COLOR);
    }

    public static Color getButtonMouseDownBackgroundColor() {
        return ColorUtil.getColor(TEXT_PLACEHOLDER_COLOR);
    }

    public static Color getPassedLogBackgroundColor() {
        return ColorUtil.getColor(PASSED_LOG_BACKGROUND_COLOR);
    }

    public static Color getFailedLogBackgroundColor() {
        return ColorUtil.getColor(FAILED_LOG_BACKGROUND_COLOR);
    }

    public static Color getErrorLogBackgroundColor() {
        return ColorUtil.getColor(ERROR_LOG_BACKGROUND_COLOR);
    }

    public static Color getSkippedLogColor() {
        return ColorUtil.getColor(SKIPPED_LOG_COLOR);
    }

    public static Color getRunningLogBackgroundColor() {
        return ColorUtil.getColor(WARNING_LOG_BACKGROUND_COLOR);
    }

    public static Color getWarningLogBackgroundColor() {
        return ColorUtil.getColor(WARNING_LOG_BACKGROUND_COLOR);
    }

    public static Color getIncompleteLogColor() {
        return ColorUtil.getColor(INCOMPLETE_LOG_COLOR);
    }

    public static Color getFailedStatusBackgroundColor() {
        return ColorUtil.getColor(FAILED_STATUS_BACKGROUND_COLOR);
    }

    public static Color getIncompleteStatusBackgroundColor() {
        return ColorUtil.getColor(INCOMPLETE_STATUS_BACKGROUND_COLOR);
    }

    public static Color getExtraLightGrayBackgroundColor() {
        return ColorUtil.getColor(EXTRA_LIGHT_GRAY_COLOR);
    }

    public static Color getTextPlaceholderColor() {
        return ColorUtil.getColor(TEXT_PLACEHOLDER_COLOR);
    }

    public static Color getDefaultTextColor() {
        if (ComponentBundleActivator.isDarkTheme(display)) {
            return ColorUtil.getColor("#CCCCCC");
        }
        return display.getSystemColor(2);
    }

    public static Color getTextWhiteColor() {
        return display.getSystemColor(1);
    }

    public static Color getTextBlackColor() {
        return display.getSystemColor(2);
    }

    public static Color getTextLinkColor() {
        return display.getSystemColor(36);
    }

    public static Color getTextErrorColor() {
        return ColorUtil.getColor("#DC0A56");
    }

    public static Color getTextWarningColor() {
        return display.getSystemColor(8);
    }

    public static Color getTextSuccessfulColor() {
        return ColorUtil.getColor("#1BBB78");
    }

    public static Color getTextRunningColor() {
        return display.getSystemColor(6);
    }

    public static Color getTooltipPlaceHolderForegroundColor() {
        return ColorUtil.getColor(TOOLTIP_TEXT_COLOR);
    }

    public static Color getDefaultBackgroundColor() {
        return ColorUtil.getColor(DEFAULT_COMPOSITE_BACKGROUND_COLOR);
    }

    public static Color getErrorTableItemBackgroundColor() {
        return ColorUtil.getColor(ERROR_BACKGROUND_COLOR);
    }

    public static Color getErrorTableItemForegroundColor() {
        return JFaceColors.getErrorText((Display)display);
    }

    public static Color getWarningForegroudColor() {
        return ColorUtil.getColor(WARNING_TEXT_COLOR);
    }

    public static Color getDisabledItemBackgroundColor() {
        return display.getSystemColor(15);
    }

    public static Color getUnEditableTableCellBackgroundColor() {
        return display.getSystemColor(15);
    }

    public static Color getHighlightForegroundColor() {
        return display.getSystemColor(36);
    }

    public static Color getToolBarBackgroundColor() {
        return ColorUtil.getColor(TOOLBAR_BACKGROUND_COLOR);
    }

    public static Color getDisabledTextColor() {
        if (ComponentBundleActivator.isDarkTheme(display)) {
            return ColorUtil.getColor(DISABLED_TEXT_COLOR_FOR_DARK_THEME);
        }
        return ColorUtil.getColor(DISABLED_TEXT_COLOR);
    }

    public static Color getHintForegroundColor() {
        return ColorUtil.getColor("#DC923C");
    }

    public static Color getTextColor() {
        if (ComponentBundleActivator.isDarkTheme(display)) {
            return display.getSystemColor(1);
        }
        return display.getSystemColor(2);
    }

    public static Color getToolBarForegroundColor() {
        if (ComponentBundleActivator.isDarkTheme(display)) {
            return display.getSystemColor(1);
        }
        return display.getSystemColor(2);
    }

    public static Color getCucumberCommentColor() {
        if (ComponentBundleActivator.isDarkTheme(display)) {
            return JFaceColors.getErrorText((Display)display);
        }
        return display.getSystemColor(4);
    }

    public static Color getHyperlinkTextColor() {
        return JFaceColors.getHyperlinkText((Display)display);
    }

    public static boolean isDarkTheme() {
        return ComponentBundleActivator.isDarkTheme(display);
    }

    public static Color themeColor(String lightThemeColor, Color darkThemeColor) {
        return ColorUtil.themeColor(ColorUtil.getColor(lightThemeColor), darkThemeColor);
    }

    public static Color themeColor(Color lightThemeColor, String darkThemeColor) {
        return ColorUtil.themeColor(lightThemeColor, ColorUtil.getColor(darkThemeColor));
    }

    public static Color themeColor(String lightThemeColor, String darkThemeColor) {
        return ColorUtil.themeColor(ColorUtil.getColor(lightThemeColor), ColorUtil.getColor(darkThemeColor));
    }

    public static Color themeColor(Color lightThemeColor, Color darkThemeColor) {
        boolean isDarkTheme = ColorUtil.isDarkTheme();
        return isDarkTheme ? darkThemeColor : lightThemeColor;
    }
}

