/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.util;

import com.kms.katalon.composer.components.controls.TextField;
import com.kms.katalon.core.util.ArrayUtil;
import com.kms.katalon.core.util.ObjectUtil;
import java.util.Timer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ComponentDataUtil {
    private ComponentDataUtil() {
    }

    public static <T> T get(Widget control, String key) {
        return ComponentDataUtil.get(control, key, null);
    }

    public static <T> T get(Widget control, String key, T defaultValue) {
        if (!ComponentDataUtil.isControlAlive(control)) {
            return defaultValue;
        }
        return (T)ObjectUtil.valueOrDefault((Object)control.getData(key), defaultValue);
    }

    public static void set(Widget control, Object data) {
        if (!ComponentDataUtil.isControlAlive(control)) {
            return;
        }
        control.setData(data);
    }

    public static void set(Widget control, String key, Object value) {
        if (!ComponentDataUtil.isControlAlive(control)) {
            return;
        }
        control.setData(key, value);
    }

    public static boolean has(Widget control, String key) {
        if (!ComponentDataUtil.isControlAlive(control)) {
            return false;
        }
        return control.getData(key) != null;
    }

    public static String getText(Widget control, String key) {
        return ComponentDataUtil.getText(control, key, "");
    }

    public static String getText(Widget control, String key, String defaultValue) {
        return ComponentDataUtil.get(control, key, defaultValue);
    }

    public static boolean getBoolean(Widget control, String key) {
        return ComponentDataUtil.getBoolean(control, key, false);
    }

    public static boolean getBoolean(Widget control, String key, boolean defaultValue) {
        return ComponentDataUtil.get(control, key, defaultValue);
    }

    public static long getLong(Widget control, String key) {
        return ComponentDataUtil.get(control, key, 0L);
    }

    public static long getLong(Widget control, String key, long defaultValue) {
        return ComponentDataUtil.get(control, key, defaultValue);
    }

    public static int getInt(Widget control, String key) {
        return ComponentDataUtil.getInt(control, key, 0);
    }

    public static int getInt(Widget control, String key, int defaultValue) {
        return ComponentDataUtil.get(control, key, defaultValue);
    }

    public static float getFloat(Widget control, String key) {
        return ComponentDataUtil.getFloat(control, key, 0.0f);
    }

    public static float getFloat(Widget control, String key, float defaultValue) {
        return ComponentDataUtil.get(control, key, Float.valueOf(defaultValue)).floatValue();
    }

    public static Point getPoint(Widget control, String key, Point defaultValue) {
        return ComponentDataUtil.get(control, key, defaultValue);
    }

    public static Point getPoint(Widget control, String key) {
        return ComponentDataUtil.get(control, key, new Point(0, 0));
    }

    public static int getWidth(Control control) {
        if (control == null) {
            return 0;
        }
        if (control.getSize().x > 0) {
            return control.getSize().x;
        }
        Object layoutData = control.getLayoutData();
        if (layoutData instanceof GridData) {
            int minWidth = ((GridData)layoutData).minimumWidth;
            if (minWidth == 0) {
                minWidth = -1;
            }
            int widthHint = ((GridData)layoutData).widthHint;
            int width = Math.max(minWidth, widthHint);
            if (widthHint >= 0) {
                return width;
            }
            int cacheWidth = (Integer)ObjectUtil.getField((Object)((GridData)layoutData), (String)"cacheWidth", (Object)-1);
            if (cacheWidth >= 0) {
                return cacheWidth;
            }
            return -1;
        }
        if (layoutData instanceof RowData && ((RowData)layoutData).width >= 0) {
            return ((RowData)layoutData).width;
        }
        return -1;
    }

    public static int getHeight(Widget control) {
        if (control == null) {
            return 0;
        }
        Point size = (Point)ObjectUtil.invokeGet((Object)control, (String)"getSize");
        if (size != null && size.y > 0) {
            return size.y;
        }
        Object layoutData = ObjectUtil.invokeGet((Object)control, (String)"getLayoutData");
        if (layoutData != null) {
            if (layoutData instanceof GridData) {
                int heightHint = ((GridData)layoutData).heightHint;
                if (heightHint >= 0) {
                    return ((GridData)layoutData).heightHint;
                }
                int cacheHeight = (Integer)ObjectUtil.getField((Object)((GridData)layoutData), (String)"cacheHeight", (Object)-1);
                if (cacheHeight >= 0) {
                    return cacheHeight;
                }
                return -1;
            }
            if (layoutData instanceof RowData && ((RowData)layoutData).height >= 0) {
                return ((RowData)layoutData).height;
            }
        }
        return -1;
    }

    public static Point computeSize(Control control) {
        return control.computeSize(-1, -1);
    }

    public static int computeWidth(Control control) {
        return control.computeSize((int)-1, (int)-1).x;
    }

    public static int computeHeight(Control control) {
        return control.computeSize((int)-1, (int)-1).y;
    }

    public static Color getColor(Widget control, String key, String defaultKey) {
        return ComponentDataUtil.get(control, key, ComponentDataUtil.get(control, defaultKey, null));
    }

    public static Color getColor(Widget control, String key) {
        return ComponentDataUtil.get(control, key, null);
    }

    public static Image getImage(Widget control, String key) {
        return ComponentDataUtil.get(control, key, null);
    }

    public static Timer getAnimationHandler(Widget control) {
        return ComponentDataUtil.get(control, "control.animation.handler", null);
    }

    public static void setAnimationHandler(Widget control, Timer handler) {
        ComponentDataUtil.set(control, "control.animation.handler", handler);
    }

    public static String translateHotKey(String text) {
        if (StringUtils.isBlank((String)text)) {
            return text;
        }
        text = SystemUtils.IS_OS_MAC ? text.replace("Ctrl", "Command") : text.replace("Command", "Ctrl");
        return text;
    }

    public static String getAnyText(Widget control) {
        String[] nameMethods;
        String text;
        String nameField;
        int n;
        int n2;
        String[] stringArray;
        String[] nameFields = new String[]{"text", "name", "label", "title", "toolTipText"};
        Object modelElement = control.getData("modelElement");
        if (modelElement != null) {
            stringArray = nameFields;
            n2 = nameFields.length;
            n = 0;
            while (n < n2) {
                nameField = stringArray[n];
                text = ObjectUtil.getStringField((Object)modelElement, (String)nameField);
                if (StringUtils.isNotBlank((String)text)) {
                    return text;
                }
                ++n;
            }
        }
        stringArray = nameFields;
        n2 = nameFields.length;
        n = 0;
        while (n < n2) {
            nameField = stringArray[n];
            text = ObjectUtil.getStringField((Object)control, (String)nameField);
            if (StringUtils.isNotBlank((String)text)) {
                return text;
            }
            Object textData = control.getData(nameField);
            if (textData instanceof String && StringUtils.isNotBlank((String)((String)textData))) {
                return (String)textData;
            }
            ++n;
        }
        String[] stringArray2 = nameMethods = new String[]{"getText", "getName", "getLabel", "getTitle", "getToolTipText"};
        int n3 = nameMethods.length;
        n2 = 0;
        while (n2 < n3) {
            String nameMethod = stringArray2[n2];
            text = (String)ObjectUtil.invokeGet((Object)control, (String)nameMethod);
            if (StringUtils.isNotBlank((String)text)) {
                return text;
            }
            ++n2;
        }
        return control.toString();
    }

    public static String getText(Widget control) {
        String text = (String)ObjectUtil.invokeGet((Object)control, (String)"getText");
        if (StringUtils.isEmpty((String)text)) {
            text = ComponentDataUtil.getText(control, "control.text");
        }
        return text;
    }

    public static void setText(Widget control, String text) {
        ObjectUtil.invokeSet((Object)control, (String)"setText", (Object)text, String.class);
        ComponentDataUtil.set(control, "control.text", text);
    }

    public static void setTitle(Widget control, String title) {
        ObjectUtil.invokeSet((Object)control, (String)"setToolTipText", (Object)title, String.class);
        ComponentDataUtil.set(control, "control.title", title);
    }

    public static void setLimit(Widget control, int maxLength) {
        ObjectUtil.invokeSet((Object)control, (String)"setTextLimit", (Object)maxLength, Integer.class);
        ComponentDataUtil.set(control, "control.limit", maxLength);
    }

    public static Image getImage(Widget control) {
        return (Image)ObjectUtil.invokeGet((Object)control, (String)"getImage");
    }

    public static void setImage(Widget control, Image image) {
        ObjectUtil.invokeSet((Object)control, (String)"setImage", (Object)image, Image.class);
    }

    public static void setImageSize(Control control, int width, int height) {
        ComponentDataUtil.setImageSize(control, new Point(width, height));
    }

    public static void setImageSize(Control control, Point size) {
        ComponentDataUtil.set((Widget)control, "control.image.size", size);
    }

    public static Point getImageSize(Control control) {
        return ComponentDataUtil.getPoint((Widget)control, "control.image.size");
    }

    public static void setImageScale(Widget control, float scale) {
        ComponentDataUtil.set(control, "control.image.scale", Float.valueOf(scale));
    }

    public static float getImageScale(Widget control) {
        return ComponentDataUtil.getFloat(control, "control.image.scale", 1.0f);
    }

    public static Object getRadioValue(Widget control) {
        Object data = control.getData();
        return data != null ? data : ComponentDataUtil.getText(control);
    }

    public static boolean isControlAlive(Object control) {
        if (control == null) {
            return false;
        }
        if (control instanceof Widget) {
            return !((Widget)control).isDisposed();
        }
        return true;
    }

    public static MouseTrackListener getMouseTrackListener(Widget control) {
        Listener[] listeners = control.getListeners(6);
        if (listeners == null || listeners.length <= 0) {
            return null;
        }
        return (MouseTrackListener)((TypedListener)listeners[0]).getEventListener();
    }

    public static boolean shouldUseCustomRender(Widget control) {
        if (control instanceof TextField) {
            return false;
        }
        return ComponentDataUtil.shouldTrackMouseMove(control) || ComponentDataUtil.shouldTrackMouseAction(control) || ComponentDataUtil.has(control, "control.border.radius") || ComponentDataUtil.has(control, "control.underline") || ComponentDataUtil.has(control, "control.hover.underline") || control instanceof Canvas && control.getListeners(9).length <= 0;
    }

    public static boolean shouldTrackMouseMove(Widget control) {
        return ComponentDataUtil.has(control, "control.hover.background") || ComponentDataUtil.has(control, "control.hover.color") || ComponentDataUtil.has(control, "control.hover.underline");
    }

    public static boolean shouldTrackMouseAction(Widget control) {
        return ComponentDataUtil.has(control, "control.active.background") || ComponentDataUtil.has(control, "control.active.color");
    }

    public static Control findNextTabControl(Control control) {
        return ComponentDataUtil.findNextTabControl(control, null);
    }

    public static Control findNextTabControl(Control control, Control stopSignal) {
        Control focusableChild;
        if (control == null) {
            return null;
        }
        if (control instanceof Composite && (focusableChild = ComponentDataUtil.findNextTabControl(((Composite)control).getChildren(), 0, stopSignal)) != null) {
            return focusableChild;
        }
        Control anchor = control;
        Composite parent = control.getParent();
        while (parent != null && !(parent instanceof Shell)) {
            int childIndex;
            Object[] siblings = parent.getChildren();
            Control siblingFocusable = ComponentDataUtil.findNextTabControl((Control[])siblings, (childIndex = ArrayUtil.findIndex((Object[])siblings, (Object)anchor)) + 1, control);
            if (siblingFocusable != null) {
                return siblingFocusable;
            }
            anchor = parent;
            parent = parent.getParent();
        }
        if (anchor instanceof Composite) {
            return ComponentDataUtil.findNextTabControl(anchor, control);
        }
        return null;
    }

    public static Control findNextTabControl(Control[] children, int fromIndex, Control stopSignal) {
        int i = fromIndex;
        while (i < children.length) {
            Control focusableControl;
            Control childI = children[i];
            if (childI == stopSignal) {
                return null;
            }
            if (ComponentDataUtil.isFocusable(childI)) {
                return childI;
            }
            if (childI instanceof Composite && (focusableControl = ComponentDataUtil.findNextTabControl(((Composite)childI).getChildren(), 0, stopSignal)) != null) {
                return focusableControl;
            }
            ++i;
        }
        return null;
    }

    public static boolean isFocusable(Control control) {
        return ComponentDataUtil.getTabIndex(control) >= 0;
    }

    public static void setTabIndex(Control control, int index) {
        ComponentDataUtil.set((Widget)control, "control.tabIndex", index);
    }

    public static int getTabIndex(Control control) {
        return ComponentDataUtil.getInt((Widget)control, "control.tabIndex", -1);
    }

    public static void copyToClipboard(String text) {
        Clipboard cb = new Clipboard(Display.getCurrent());
        cb.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
    }

    public static String getShortenText(String textValue, Control control) {
        if (textValue == null) {
            return null;
        }
        GC gc = new GC((Drawable)control);
        int maxExtent = gc.textExtent((String)textValue).x;
        int maxWidth = control.getBounds().width - 25;
        if (maxExtent < maxWidth) {
            gc.dispose();
            return textValue;
        }
        int length = textValue.length();
        int charsToClip = Math.round(0.95f * (float)length * (1.0f - (float)maxWidth / (float)maxExtent));
        int pivot = length / 2;
        int start = pivot - charsToClip / 2;
        int end = pivot + charsToClip / 2 + 1;
        while (start >= 0 && end < length) {
            String s1 = textValue.substring(0, start);
            String s2 = textValue.substring(end, length);
            String s = String.valueOf(s1) + "..." + s2;
            int l = gc.textExtent((String)s).x;
            if (l < maxWidth) {
                gc.dispose();
                return s;
            }
            --start;
            ++end;
        }
        gc.dispose();
        return textValue;
    }
}

