/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.util;

import com.kms.katalon.composer.components.constants.ControlState;
import com.kms.katalon.composer.components.util.ComponentDataUtil;
import com.kms.katalon.core.util.ObjectUtil;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class ControlUtil {
    private static final EnumMap<ControlState, String> BACKGROUND_KEY_BY_STATE_MAP = new EnumMap(ControlState.class);
    private static final EnumMap<ControlState, String> COLOR_KEY_BY_STATE_MAP;
    private static final EnumMap<ControlState, String> BORDER_COLOR_KEY_BY_STATE_MAP;
    private static final EnumMap<ControlState, String> UNDERLINE_KEY_BY_STATE_MAP;

    static {
        BACKGROUND_KEY_BY_STATE_MAP.put(ControlState.NORMAL, "control.background");
        BACKGROUND_KEY_BY_STATE_MAP.put(ControlState.HOVER, "control.hover.background");
        BACKGROUND_KEY_BY_STATE_MAP.put(ControlState.ACTIVE, "control.active.background");
        BACKGROUND_KEY_BY_STATE_MAP.put(ControlState.DISABLED, "control.disabled.background");
        COLOR_KEY_BY_STATE_MAP = new EnumMap(ControlState.class);
        COLOR_KEY_BY_STATE_MAP.put(ControlState.NORMAL, "control.color");
        COLOR_KEY_BY_STATE_MAP.put(ControlState.HOVER, "control.hover.color");
        COLOR_KEY_BY_STATE_MAP.put(ControlState.ACTIVE, "control.active.color");
        COLOR_KEY_BY_STATE_MAP.put(ControlState.DISABLED, "control.disabled.color");
        BORDER_COLOR_KEY_BY_STATE_MAP = new EnumMap(ControlState.class);
        BORDER_COLOR_KEY_BY_STATE_MAP.put(ControlState.NORMAL, "control.border.color");
        BORDER_COLOR_KEY_BY_STATE_MAP.put(ControlState.HOVER, "control.hover.border.color");
        BORDER_COLOR_KEY_BY_STATE_MAP.put(ControlState.ACTIVE, "control.active.border.color");
        BORDER_COLOR_KEY_BY_STATE_MAP.put(ControlState.DISABLED, "control.disabled.border.color");
        UNDERLINE_KEY_BY_STATE_MAP = new EnumMap(ControlState.class);
        UNDERLINE_KEY_BY_STATE_MAP.put(ControlState.NORMAL, "control.underline");
        UNDERLINE_KEY_BY_STATE_MAP.put(ControlState.HOVER, "control.hover.underline");
        UNDERLINE_KEY_BY_STATE_MAP.put(ControlState.ACTIVE, "control.hover.underline");
        UNDERLINE_KEY_BY_STATE_MAP.put(ControlState.DISABLED, "control.underline");
    }

    private ControlUtil() {
    }

    public static Color getCurrentBackground(Control control) {
        return ControlUtil.getColorByState(control, BACKGROUND_KEY_BY_STATE_MAP);
    }

    public static Color getCurrentColor(Control control) {
        return ControlUtil.getColorByState(control, COLOR_KEY_BY_STATE_MAP);
    }

    public static Color getCurrentBorderColor(Control control) {
        return ControlUtil.getColorByState(control, BORDER_COLOR_KEY_BY_STATE_MAP);
    }

    public static Color getColorByState(Control control, Map<ControlState, String> keyMap) {
        ControlState state = ControlUtil.getCurrentState(control);
        String key = keyMap.get((Object)state);
        Color color = ComponentDataUtil.getColor((Widget)control, key);
        while (color == null) {
            ControlState fallbackState = ControlUtil.getFallbackState(state);
            if (fallbackState == null) break;
            state = fallbackState;
            key = keyMap.get((Object)state);
            color = ComponentDataUtil.getColor((Widget)control, key);
        }
        return color;
    }

    private static ControlState getFallbackState(ControlState currentState) {
        switch (currentState) {
            case FOCUS_ACTIVE: {
                return ControlState.FOCUS_HOVER;
            }
            case FOCUS_HOVER: {
                return ControlState.FOCUS;
            }
            case FOCUS: {
                return ControlState.NORMAL;
            }
            case ACTIVE: {
                return ControlState.HOVER;
            }
            case HOVER: {
                return ControlState.NORMAL;
            }
            case DISABLED: {
                return ControlState.NORMAL;
            }
            case NORMAL: {
                return null;
            }
        }
        return null;
    }

    public static boolean getCurrentUnderline(Control control) {
        String colorKey = ControlUtil.getKeyByCurrentState(control, UNDERLINE_KEY_BY_STATE_MAP);
        return ComponentDataUtil.getBoolean((Widget)control, colorKey);
    }

    private static String getKeyByCurrentState(Control control, Map<ControlState, String> keyMap) {
        ControlState state = ControlUtil.getCurrentState(control);
        return keyMap.get((Object)state);
    }

    public static ControlState getCurrentState(Control control) {
        if (ControlUtil.isDisposed((Widget)control)) {
            return null;
        }
        if (!control.isEnabled()) {
            return ControlState.DISABLED;
        }
        return ComponentDataUtil.get((Widget)control, "control.state", ControlState.NORMAL);
    }

    public static boolean isInNormal(Control control) {
        return ControlUtil.getCurrentState(control) == ControlState.NORMAL;
    }

    public static boolean isHovering(Control control) {
        return ControlUtil.getCurrentState(control) == ControlState.HOVER;
    }

    public static boolean isAcivating(Control control) {
        return ControlUtil.getCurrentState(control) == ControlState.ACTIVE;
    }

    public static void setState(Control control, ControlState state) {
        if (ControlUtil.isDisposed((Widget)control)) {
            return;
        }
        ComponentDataUtil.set((Widget)control, "control.state", (Object)state);
        control.redraw();
    }

    public static void setStateNormal(Control control) {
        ControlUtil.setState(control, ControlState.NORMAL);
    }

    public static void setStateHover(Control control) {
        ControlUtil.setState(control, ControlState.HOVER);
    }

    public static void setStateActive(Control control) {
        ControlUtil.setState(control, ControlState.ACTIVE);
    }

    public static void setStateFocus(Control control) {
        ControlUtil.setState(control, ControlState.FOCUS);
    }

    public static void setEnabled(Control control, boolean enabled) {
        if (!ControlUtil.isDisposed((Widget)control)) {
            control.setEnabled(enabled);
        }
    }

    public static void recursiveSetEnabled(Widget control, boolean enabled) {
        Widget[] children;
        if (ControlUtil.isDisposed(control)) {
            return;
        }
        ObjectUtil.invokeSet((Object)control, (String)"setEnabled", (Object)enabled, Boolean.TYPE);
        Widget[] widgetArray = children = ControlUtil.getChildren(control);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Widget child = widgetArray[n2];
            ControlUtil.recursiveSetEnabled(child, enabled);
            ++n2;
        }
    }

    public static boolean getEnabled(Control control) {
        return !ControlUtil.isDisposed((Widget)control) && control.getEnabled();
    }

    public static boolean isHidden(Control control) {
        return !ControlUtil.isVisible(control);
    }

    public static boolean isVisible(Control control) {
        return !ControlUtil.isDisposed((Widget)control) && control.getShell().getAlpha() > 1;
    }

    public static boolean isDisposed(Widget control) {
        return control == null || control.isDisposed();
    }

    public static boolean isDisposed(Resource resource) {
        return resource == null || resource.isDisposed();
    }

    public static boolean isDisposed(Dialog dialog) {
        return dialog == null || ControlUtil.isDisposed((Widget)dialog.getShell());
    }

    public static boolean dispose(Resource resource) {
        if (resource != null && !resource.isDisposed()) {
            resource.dispose();
            return true;
        }
        return false;
    }

    public static boolean dispose(Widget control) {
        if (control != null && !control.isDisposed()) {
            control.dispose();
            return true;
        }
        return false;
    }

    public static Widget getParent(Widget control) {
        if (ControlUtil.isDisposed(control)) {
            return null;
        }
        return (Widget)ObjectUtil.invokeGet((Object)control, (String)"getParent");
    }

    public static Widget[] getChildren(Widget control) {
        if (ControlUtil.isDisposed(control)) {
            return new Widget[0];
        }
        Widget[] children = (Widget[])ObjectUtil.invokeGet((Object)control, (String)"getChildren");
        return children != null ? children : new Widget[]{};
    }

    public static boolean checkStyle(int style, int ... options) {
        return Arrays.stream(options).allMatch(optionI -> (style & optionI) != 0);
    }
}

