/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class InputValidator {
    public static final Pattern VALID_EMAIL_ADDRESS_REGEX = Pattern.compile("^\\s*[A-Z0-9'\"._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,}\\s*$", 2);
    public static Validator<String> EMAIL = email -> VALID_EMAIL_ADDRESS_REGEX.matcher((CharSequence)email).find();
    public static Validator<String> PASSWORD = password -> StringUtils.isNotBlank((String)StringUtils.trim((String)password));
    private boolean isValidated = false;
    private List<FieldValidator<Object>> fields = new ArrayList<FieldValidator<Object>>();
    private List<ValidationListener> validationListeners = new ArrayList<ValidationListener>();

    public boolean isValidated() {
        return this.isValidated;
    }

    public <Type> void register(ValueGetter<Type> getter, Validator<Type> validator) {
        this.fields.add(new FieldValidator<Type>(getter, validator));
    }

    public boolean validate() {
        return this.validate(null);
    }

    public boolean validate(List<String> outErrors) {
        boolean isValidated;
        outErrors.clear();
        this.isValidated = isValidated = this.fields.stream().allMatch(fieldI -> {
            boolean validated = fieldI.validator.validate(fieldI.getter.get());
            if (!validated && outErrors != null && StringUtils.isNotBlank((String)fieldI.errorMessage)) {
                outErrors.add(fieldI.errorMessage);
            }
            return validated;
        });
        return isValidated;
    }

    public ValidationListener asValidationListener(ValidationListener listener) {
        return listener;
    }

    public void onValidation(ValidationListener listener) {
        this.validationListeners.add(listener);
    }

    public void offValidation(ValidationListener listener) {
        this.validationListeners.remove(listener);
    }

    public void triggerValidation() {
        ArrayList<String> errors = new ArrayList<String>();
        boolean validated = this.validate(errors);
        this.validationListeners.forEach(listenerI -> {
            if (listenerI != null) {
                listenerI.call(validated, errors);
            }
        });
    }

    public class FieldValidator<Type> {
        public ValueGetter<Type> getter;
        public Validator<Type> validator;
        public String errorMessage;

        public FieldValidator(ValueGetter<Type> getter, Validator<Type> validator) {
            this.validator = validator;
            this.getter = getter;
        }
    }

    public static interface ValidationListener {
        public void call(boolean var1, List<String> var2);
    }

    public static interface Validator<Type> {
        public boolean validate(Type var1);
    }

    public static interface ValueGetter<Type> {
        public Type get();
    }
}

