/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.util;

import com.kms.katalon.composer.components.constants.ComponentConstants;
import com.kms.katalon.composer.components.util.ComponentDataUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class StyleUtil {
    public static GC setupGC(GC gc) {
        gc.setAdvanced(true);
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        gc.setInterpolation(2);
        return gc;
    }

    public static void customRender(final Control control) {
        StyleUtil.storeControlBuiltInAttrs(control);
        StyleUtil.clearControlBuiltInAttrs(control);
        control.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                Point imageSize;
                Color color;
                if (ControlUtil.isDisposed((Widget)control) || event.gc.isDisposed()) {
                    return;
                }
                GC gc = StyleUtil.setupGC(event.gc);
                gc.setFont(control.getFont());
                Color background = ControlUtil.getCurrentBackground(control);
                if (background != null) {
                    gc.setBackground(background);
                    StyleUtil.updateChildrenBackground(control, background);
                }
                if ((color = ControlUtil.getCurrentColor(control)) != null) {
                    gc.setForeground(color);
                    StyleUtil.updateChildrenColor(control, color);
                }
                boolean hasUnderline = ControlUtil.getCurrentUnderline(control);
                boolean isDisabled = !control.getEnabled();
                Rectangle bounds = control.getBounds();
                int borderRadius = ComponentDataUtil.getInt((Widget)control, "control.border.radius");
                Image image = ComponentDataUtil.getImage((Widget)control, "control.image");
                String textContent = ComponentDataUtil.getText((Widget)control);
                Integer contentAlign = (Integer)control.getData("control.content.align");
                Point textSize = gc.textExtent(StringUtils.defaultString((String)textContent));
                Point contentSize = new Point(textSize.x, textSize.y);
                int spacing = StringUtils.isNotBlank((String)textContent) ? 5 : 0;
                Rectangle imageBounds = new Rectangle(0, 0, 0, 0);
                if (image != null) {
                    imageBounds = image.getBounds();
                    Point imageSize2 = ComponentDataUtil.getImageSize(control);
                    int imageWidth = imageSize2 != null ? imageSize2.x : imageBounds.width;
                    int imageHeight = imageSize2 != null ? imageSize2.y : imageBounds.height;
                    contentSize.x += imageWidth + spacing;
                    contentSize.y = Math.max(contentSize.y, imageHeight);
                }
                if (bounds.width < contentSize.x) {
                    control.setSize(contentSize.x + ComponentUtil.applyZoom(5), bounds.height);
                    bounds = control.getBounds();
                }
                int width = bounds.width;
                int height = bounds.height;
                int borderWidth = ComponentDataUtil.get((Widget)control, "control.border.width", 0);
                gc.fillRoundRectangle(Math.floorDiv(borderWidth, 2), Math.floorDiv(borderWidth, 2), width - borderWidth, height - borderWidth, borderRadius, borderRadius);
                Point anchor = new Point((width - contentSize.x) / 2, (height - contentSize.y) / 2);
                if (contentAlign != null) {
                    switch (contentAlign) {
                        case 16384: {
                            anchor = new Point(10, (height - contentSize.y) / 2);
                            break;
                        }
                        case 131072: {
                            anchor = new Point(width - contentSize.x - 10, (height - contentSize.y) / 2);
                        }
                    }
                }
                int imageWidth = (imageSize = ComponentDataUtil.getImageSize(control)) != null ? imageSize.x : imageBounds.width;
                int imageHeight = imageSize != null ? imageSize.y : imageBounds.height;
                Point textAnchor = new Point(anchor.x, anchor.y + Math.max((imageHeight - textSize.y) / 2, 0));
                if (image != null) {
                    Integer imageAlign = (Integer)control.getData("control.image.align");
                    float imageScale = ComponentDataUtil.getImageScale((Widget)control);
                    imageWidth = (int)((float)imageWidth * imageScale);
                    imageHeight = (int)((float)imageHeight * imageScale);
                    Point imgAnchor = new Point(anchor.x, anchor.y + Math.max((textSize.y - imageHeight) / 2, 0));
                    if (imageAlign == 0x1000000) {
                        imgAnchor.x = Math.max(Math.round((float)(bounds.width - imageWidth) / 2.0f), 0);
                        imgAnchor.y = Math.max(Math.round((float)(bounds.height - imageHeight) / 2.0f), 0);
                    } else if (imageAlign == 131072) {
                        imgAnchor.x += textSize.x + spacing;
                    }
                    Image finalImage = isDisabled ? new Image((Device)control.getDisplay(), image, 2) : image;
                    gc.drawImage(finalImage, 0, 0, imageBounds.width, imageBounds.height, imgAnchor.x, imgAnchor.y, imageWidth, imageHeight);
                    if (finalImage != image) {
                        finalImage.dispose();
                    }
                    if (imageAlign != 131072) {
                        textAnchor.x += imageWidth + spacing;
                    }
                }
                if (StringUtils.isNotBlank((String)textContent)) {
                    boolean isCloseButton = StringUtils.equals((String)textContent, (String)"\u00d7");
                    boolean shouldAdjustPosition = isCloseButton && SystemUtils.IS_OS_WINDOWS;
                    int textX = !shouldAdjustPosition ? textAnchor.x : textAnchor.x + 1;
                    int textY = !shouldAdjustPosition ? textAnchor.y - 1 : textAnchor.y - 4;
                    gc.drawText(textContent, textX, textY, true);
                    if (hasUnderline) {
                        Color curBackground = gc.getBackground();
                        gc.setAlpha(100);
                        gc.setBackground(gc.getForeground());
                        gc.fillRoundRectangle(textX - 1, textY + textSize.y - ComponentUtil.applyZoom(1), textSize.x, ComponentUtil.applyZoom(1), textY, textY);
                        gc.setBackground(curBackground);
                        gc.setAlpha(255);
                    }
                }
                if (borderWidth > 0) {
                    Color borderColor = ControlUtil.getCurrentBorderColor(control);
                    if (borderColor != null) {
                        gc.setForeground(borderColor);
                    } else {
                        gc.setForeground(ComponentConstants.DEFAULT_BORDER_COLOR);
                    }
                    gc.setLineWidth(borderWidth);
                    gc.drawRoundRectangle(Math.floorDiv(borderWidth, 2), Math.floorDiv(borderWidth, 2), width - borderWidth, height - borderWidth, borderRadius, borderRadius);
                }
                gc.dispose();
            }
        });
        if (ComponentDataUtil.shouldTrackMouseMove((Widget)control)) {
            MouseTrackListener mouseTrackListener = new MouseTrackListener(){

                public void mouseHover(MouseEvent e) {
                }

                public void mouseExit(MouseEvent e) {
                    if (ControlUtil.isDisposed((Widget)control)) {
                        return;
                    }
                    ControlUtil.setStateNormal(control);
                }

                public void mouseEnter(MouseEvent e) {
                    if (ControlUtil.isDisposed((Widget)control)) {
                        return;
                    }
                    if (!ControlUtil.isAcivating(control)) {
                        ControlUtil.setStateHover(control);
                    }
                }
            };
            control.addMouseTrackListener(mouseTrackListener);
        }
        if (ComponentDataUtil.shouldTrackMouseAction((Widget)control)) {
            MouseListener mouseListener = new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    if (ControlUtil.isDisposed((Widget)control)) {
                        return;
                    }
                    ControlUtil.setStateHover(control);
                }

                public void mouseDown(MouseEvent e) {
                    if (ControlUtil.isDisposed((Widget)control)) {
                        return;
                    }
                    ControlUtil.setStateActive(control);
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            };
            control.addMouseListener(mouseListener);
            control.setData("control.data.mouseListener", (Object)mouseListener);
        }
        control.redraw();
    }

    private static void storeControlBuiltInAttrs(Control control) {
        Composite parent = control.getParent();
        if (!ControlUtil.isDisposed((Widget)parent) && !control.getBackground().equals((Object)parent.getBackground())) {
            ComponentDataUtil.set((Widget)control, "control.background", control.getBackground());
        }
        if (!ControlUtil.isDisposed((Widget)parent) && control.getForeground().equals((Object)parent.getForeground())) {
            ComponentDataUtil.set((Widget)control, "control.color", control.getForeground());
        }
        if (ComponentDataUtil.getImage((Widget)control) != null) {
            ComponentDataUtil.set((Widget)control, "control.image", ComponentDataUtil.getImage((Widget)control));
        }
    }

    private static void clearControlBuiltInAttrs(Control control) {
        control.setBackground(null);
        control.setForeground(null);
        ComponentDataUtil.setImage((Widget)control, null);
    }

    private static void updateChildrenBackground(Control control, Color background) {
        if (control instanceof Composite && !ControlUtil.isDisposed((Widget)control)) {
            Control[] children;
            Control[] controlArray = children = ((Composite)control).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (!ControlUtil.isDisposed((Widget)child)) {
                    Color oldBackground = child.getBackground();
                    child.setBackground(background);
                    ControlUtil.dispose((Resource)oldBackground);
                    if (child instanceof Composite) {
                        StyleUtil.updateChildrenBackground(child, background);
                    }
                }
                ++n2;
            }
        }
    }

    private static void updateChildrenColor(Control control, Color color) {
        if (control instanceof Composite && !ControlUtil.isDisposed((Widget)control)) {
            Control[] children;
            Control[] controlArray = children = ((Composite)control).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (!ControlUtil.isDisposed((Widget)child)) {
                    Color oldColor = child.getForeground();
                    child.setForeground(color);
                    ControlUtil.dispose((Resource)oldColor);
                    if (child instanceof Composite) {
                        StyleUtil.updateChildrenColor(child, color);
                    }
                }
                ++n2;
            }
        }
    }

    public static void applyMoueseListenerToChildren(Control control) {
        StyleUtil.applyMouseListenerToChildren(control, null);
    }

    private static void applyMouseListenerToChildren(Control control, MouseListener mouseListener) {
        Control[] children;
        if (mouseListener == null && (mouseListener = (MouseListener)control.getData("control.data.mouseListener")) == null) {
            return;
        }
        if (!(control instanceof Composite)) {
            return;
        }
        Control[] controlArray = children = ((Composite)control).getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.addMouseListener(mouseListener);
            StyleUtil.applyMouseListenerToChildren(child, mouseListener);
            ++n2;
        }
    }
}

