/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.steps.jdt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class JavaParser
extends AbstractHandler {
    private ASTParser astParser = ASTParser.newParser((int)8);
    private CompilationUnit compUnit = null;
    private ASTRequestor astRequestor = null;
    private String className = null;
    private String methodBody = null;

    public JavaParser(ICompilationUnit iCompilationUnit, IProgressMonitor progressMonitor) {
        this.astParser.setKind(8);
        this.astParser.setCompilerOptions(Collections.singletonMap("org.eclipse.jdt.core.compiler.problem.unusedImport", "error"));
        this.astParser.setSource(iCompilationUnit);
        this.astParser.setResolveBindings(true);
        this.compUnit = (CompilationUnit)this.astParser.createAST(progressMonitor);
    }

    public List<MethodDeclaration> getAllMethods() throws JavaModelException {
        MethodVisitor visitor = new MethodVisitor();
        this.compUnit.accept((ASTVisitor)visitor);
        return visitor.getMethods();
    }

    public String getMethodBody(MethodDeclaration method) {
        this.methodBody = method.getBody().toString();
        return this.methodBody;
    }

    public String getClassName(ICompilationUnit iCompUnit) {
        this.className = iCompUnit.getResource().getName();
        return this.className;
    }

    public int getLineNumber(Statement statement) {
        return this.compUnit.getLineNumber(statement.getStartPosition());
    }

    public Set<String> getUnusedImports(ICompilationUnit icompUnit) throws JavaModelException {
        final HashSet<String> unusedImports = new HashSet<String>();
        this.astRequestor = new ASTRequestor(){

            public void acceptAST(ICompilationUnit sourceUnit, CompilationUnit compiledUnit) {
                IProblem[] problems = compiledUnit.getProblems();
                boolean onlyUnusedImportErrors = true;
                IProblem[] iProblemArray = problems;
                int n = problems.length;
                int n2 = 0;
                while (n2 < n) {
                    IProblem problem = iProblemArray[n2];
                    int id = problem.getID();
                    if (id != 268435844) {
                        onlyUnusedImportErrors = false;
                        break;
                    }
                    unusedImports.add(problem.getArguments()[0]);
                    ++n2;
                }
                if (!onlyUnusedImportErrors) {
                    List imports = compiledUnit.imports();
                    for (ImportDeclaration importDeclaration : imports) {
                        if (importDeclaration.isStatic() || importDeclaration.isOnDemand()) continue;
                        unusedImports.add(importDeclaration.getName().getFullyQualifiedName());
                    }
                }
            }
        };
        this.astParser.createASTs(new ICompilationUnit[]{icompUnit}, new String[0], this.astRequestor, null);
        return unusedImports;
    }

    public String getClassName(CompilationUnit compUnit) {
        compUnit.accept(new ASTVisitor(){
            String packageName = "";

            public boolean visit(TypeDeclaration node) {
                JavaParser.this.className = node.getName().getFullyQualifiedName();
                if (this.packageName != "") {
                    System.out.println("Fully Qualified ClassName : " + this.packageName + "." + JavaParser.this.className);
                } else {
                    System.out.println("Class Name : " + JavaParser.this.className);
                }
                return false;
            }

            public boolean visit(PackageDeclaration node) {
                this.packageName = node.getName().getFullyQualifiedName();
                return false;
            }
        });
        return this.className;
    }

    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        return null;
    }

    public class MethodVisitor
    extends ASTVisitor {
        List<MethodDeclaration> methods = new ArrayList<MethodDeclaration>();

        public boolean visit(MethodDeclaration node) {
            this.methods.add(node);
            return super.visit(node);
        }

        public List<MethodDeclaration> getMethods() {
            return this.methods;
        }
    }
}

