/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.steps.jdt.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddNatureHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object selection = ((IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event)).getFirstElement();
        IProject project = selection instanceof IAdaptable ? (IProject)((IAdaptable)selection).getAdapter(IProject.class) : null;
        try {
            this.addNature(project);
        }
        catch (CoreException e) {
            throw new ExecutionException("Error adding nature", (Throwable)e);
        }
        return null;
    }

    private void addNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] oldNatures = description.getNatureIds();
        String[] newNatures = new String[oldNatures.length + 1];
        System.arraycopy(oldNatures, 0, newNatures, 1, oldNatures.length);
        newNatures[0] = "cucumber.eclipse.steps.jdt.stepsNature";
        description.setNatureIds(newNatures);
        project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        this.updatePackageExplorer();
    }

    private void updatePackageExplorer() {
        IViewPart foundView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.jdt.ui.PackageExplorer");
        if (foundView instanceof IPackagesViewPart) {
            IPackagesViewPart packageExplorerView = (IPackagesViewPart)foundView;
            TreeViewer treeViewer = packageExplorerView.getTreeViewer();
            treeViewer.refresh();
        }
    }
}

