/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.custom.parser;

import com.kms.katalon.core.annotation.Keyword;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.custom.factory.CustomKeywordPluginFactory;
import com.kms.katalon.custom.factory.CustomMethodNodeFactory;
import com.kms.katalon.custom.factory.PluginTestListenerFactory;
import com.kms.katalon.custom.keyword.CustomKeywordPlugin;
import com.kms.katalon.custom.keyword.KeywordsManifest;
import com.kms.katalon.custom.parser.MethodUtils;
import com.kms.katalon.custom.parser.NamingMethodVisitor;
import com.kms.katalon.logging.LogUtil;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.lang.StringUtils;
import org.assertj.core.internal.bytebuddy.jar.asm.ClassReader;
import org.assertj.core.internal.bytebuddy.jar.asm.ClassVisitor;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;

public class CustomKeywordParser {
    private static final String KATALON_PLUGIN_JSON_FILE = "katalon-plugin.json";
    private static final String CUSTOM_KEYWORDS_FILE_NAME = "CustomKeywords.groovy";
    private static final String TEMPLATE_CLASS_NAME = "com.kms.katalon.custom.generation.CustomKeywordTemplate";
    private static final String GENERATED_KEYWORD_METHOD_NAME = "generateCustomKeywordFile";
    private static CustomKeywordParser _instance;
    private static List<MethodNode> methodNodes;

    static {
        methodNodes = new ArrayList<MethodNode>();
    }

    private CustomKeywordParser() {
    }

    public static CustomKeywordParser getInstance() {
        if (_instance == null) {
            _instance = new CustomKeywordParser();
        }
        return _instance;
    }

    public void parseProjectCustomKeywords(IFolder srcfolder, IFolder libFolder) throws Exception {
        CustomMethodNodeFactory.getInstance().reset();
        List<IFile> customKeywordFiles = this.getProjectCustomKeywordFiles(srcfolder);
        for (IFile file : customKeywordFiles) {
            this.parseCustomKeywordFile(file, libFolder, false);
        }
        this.generateCustomKeywordLibFile(libFolder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasPluginKeywords() {
        List<File> pluginFiles = CustomKeywordPluginFactory.getInstance().getStoredPluginFiles();
        for (File pluginFile : pluginFiles) {
            if (!this.isJarFile(pluginFile)) continue;
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JarFile jar = new JarFile(pluginFile);){
                    InputStreamReader reader;
                    KeywordsManifest manifest;
                    List<String> keywords;
                    ZipEntry jsonEntry = jar.getEntry(KATALON_PLUGIN_JSON_FILE);
                    if (jsonEntry == null || (keywords = (manifest = (KeywordsManifest)JsonUtil.fromJson((Reader)(reader = new InputStreamReader(jar.getInputStream(jsonEntry))), KeywordsManifest.class)).getKeywords()) == null || keywords.isEmpty()) continue;
                    return true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (Exception e) {
                LogUtil.printAndLogError((Throwable)e);
            }
        }
        return false;
    }

    private boolean isJarFile(File file) {
        return StringUtils.endsWith((String)file.getName(), (String)".jar");
    }

    public void parsePluginKeywords(ClassLoader projectClassLoader, List<File> pluginFiles, IFolder libFolder, boolean isDev) throws Exception {
        for (File pluginFile : pluginFiles) {
            JarFile jar;
            block15: {
                CustomKeywordPlugin plugin;
                KeywordsManifest manifest;
                block16: {
                    if (!this.isJarFile(pluginFile)) continue;
                    jar = new JarFile(pluginFile);
                    ZipEntry jsonEntry = jar.getEntry(KATALON_PLUGIN_JSON_FILE);
                    if (jsonEntry == null) break block15;
                    InputStreamReader reader = new InputStreamReader(jar.getInputStream(jsonEntry));
                    manifest = (KeywordsManifest)JsonUtil.fromJson((Reader)reader, KeywordsManifest.class);
                    plugin = null;
                    if (isDev) {
                        plugin = CustomKeywordPluginFactory.getInstance().getDevPlugin();
                        LogUtil.printOutputLine((String)MessageFormat.format("Custom keyword plugin found: {0}. Manifest content:\n{1}", pluginFile.getName(), JsonUtil.toJson((Object)manifest)));
                    } else {
                        plugin = CustomKeywordPluginFactory.getInstance().getByPath(pluginFile.getAbsolutePath());
                    }
                    if (plugin != null) break block16;
                    LogUtil.logErrorMessage((String)("Could not load Custom Keywords for plugin: " + pluginFile.getName()));
                    jar.close();
                    return;
                }
                try {
                    plugin.setKeywordsManifest(manifest);
                    LinkedHashSet<String> keywords = new LinkedHashSet<String>();
                    keywords.addAll(manifest.getKeywords());
                    for (String keyword : keywords) {
                        String filePath = pluginFile.getAbsolutePath();
                        Class<?> clazz = null;
                        try {
                            clazz = projectClassLoader.loadClass(keyword);
                        }
                        catch (ClassNotFoundException e) {
                            LogUtil.logError((Throwable)e, (String)MessageFormat.format("Could not load class: {0} of custom plugin keyword: {1}", keyword, pluginFile.getName()));
                            continue;
                        }
                        ClassNode classNode = new ClassNode(clazz);
                        InputStream stream = projectClassLoader.getResourceAsStream(String.valueOf(keyword.replace('.', '/')) + ".class");
                        ClassReader classReader = new ClassReader(stream);
                        NamingMethodVisitor visitor = new NamingMethodVisitor(clazz);
                        classReader.accept((ClassVisitor)visitor, 4);
                        HashMap<String, List<String>> parametersMap = new HashMap<String, List<String>>();
                        classNode.getMethods().forEach(methodNode -> {
                            String typesClassName = MethodUtils.getParametersDescriptor(methodNode);
                            String methodName = String.valueOf(methodNode.getName()) + "#" + typesClassName;
                            List<String> paramNames = visitor.getParameterNames(methodName);
                            parametersMap.put(methodName, paramNames);
                        });
                        CustomMethodNodeFactory.getInstance().addPluginMethodNodes(classNode.getName(), classNode.getMethods(), filePath, parametersMap);
                    }
                    List<String> listeners = manifest.getListeners();
                    for (String listener : listeners) {
                        PluginTestListenerFactory.getInstance().addListener(listener);
                    }
                }
                catch (Exception e) {
                    LogUtil.printAndLogError((Throwable)e);
                    jar.close();
                    continue;
                }
                catch (NoClassDefFoundError e) {
                    try {
                        LogUtil.printAndLogError((Throwable)e);
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        jar.close();
                    }
                }
            }
            jar.close();
        }
        this.generateCustomKeywordLibFile(libFolder);
    }

    public List<Method> parseProjectCustomKeywordsIntoAst(URLClassLoader classLoader, IFolder srcfolder) throws Exception {
        ArrayList<Method> allMethods = new ArrayList<Method>();
        List<IFile> customKeywordFiles = this.getProjectCustomKeywordFiles(srcfolder);
        for (IFile file : customKeywordFiles) {
            allMethods.addAll(this.parseCustomKeywordFileIntoAst(classLoader, file));
        }
        Collections.sort(allMethods, new Comparator<Method>(){

            @Override
            public int compare(Method methodA, Method methodB) {
                return methodA.getName().compareToIgnoreCase(methodB.getName());
            }
        });
        return allMethods;
    }

    public List<Method> parseCustomKeywordFileIntoAst(URLClassLoader classLoader, IFile file) throws Exception {
        if (file.exists() && classLoader instanceof GroovyClassLoader) {
            IPackageFragment packageFragment;
            String className = file.getName().replace("." + file.getFileExtension(), "");
            IJavaElement javaElement = JavaCore.create((IFile)file);
            String packageName = "";
            if (javaElement.getParent() instanceof IPackageFragment && !(packageName = (packageFragment = (IPackageFragment)javaElement.getParent()).getElementName()).isEmpty()) {
                packageName = String.valueOf(packageName) + ".";
            }
            try {
                Class clazz = ((GroovyClassLoader)classLoader).loadClass(String.valueOf(packageName) + className);
                if (clazz != null) {
                    ArrayList<Method> methods = new ArrayList<Method>();
                    Method[] methodArray = clazz.getMethods();
                    int n = methodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method method = methodArray[n2];
                        Annotation[] annotationArray = method.getDeclaredAnnotations();
                        int n3 = annotationArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Annotation annotation = annotationArray[n4];
                            if (annotation.annotationType().getName().equals(Keyword.class.getName())) {
                                methods.add(method);
                                break;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    return methods;
                }
            }
            catch (ClassNotFoundException ex) {
                LogUtil.printAndLogError((Throwable)ex);
            }
        }
        return Collections.emptyList();
    }

    public List<Method> parsePluginKeywordsIntoAst(URLClassLoader classLoader, IFolder srcfolder) throws Exception {
        File srcDir = srcfolder.getRawLocation().toFile();
        File[] jarFiles = srcDir.listFiles();
        ArrayList<Method> methods = new ArrayList<Method>();
        File[] fileArray = jarFiles;
        int n = jarFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File jarFile = fileArray[n2];
            methods.addAll(this.parsePluginKeywordJarIntoAst(classLoader, jarFile));
            ++n2;
        }
        Collections.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method methodA, Method methodB) {
                return methodA.getName().compareToIgnoreCase(methodB.getName());
            }
        });
        return methods;
    }

    public List<Method> parsePluginKeywordJarIntoAst(URLClassLoader classLoader, File pluginFile) throws Exception {
        ArrayList<Method> methods = new ArrayList<Method>();
        if (pluginFile.exists() && this.isJarFile(pluginFile) && classLoader instanceof GroovyClassLoader) {
            try (JarFile jar = new JarFile(pluginFile);){
                try {
                    ZipEntry jsonEntry = jar.getEntry(KATALON_PLUGIN_JSON_FILE);
                    if (jsonEntry != null) {
                        InputStreamReader reader = new InputStreamReader(jar.getInputStream(jsonEntry));
                        KeywordsManifest manifest = (KeywordsManifest)JsonUtil.fromJson((Reader)reader, KeywordsManifest.class);
                        LinkedHashSet<String> keywords = new LinkedHashSet<String>();
                        keywords.addAll(manifest.getKeywords());
                        for (String keyword : keywords) {
                            Class<?> clazz = classLoader.loadClass(keyword);
                            if (clazz == null) continue;
                            Method[] methodArray = clazz.getMethods();
                            int n = methodArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Method method = methodArray[n2];
                                Annotation[] annotationArray = method.getDeclaredAnnotations();
                                int n3 = annotationArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    Annotation annotation = annotationArray[n4];
                                    if (annotation.annotationType().getName().equals(Keyword.class.getName())) {
                                        methods.add(method);
                                        break;
                                    }
                                    ++n4;
                                }
                                ++n2;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    jar.close();
                }
            }
        }
        return methods;
    }

    public void parseCustomKeywordFile(IFile file, IFolder libFolder, boolean generateLibFile) throws Exception {
        try {
            ICompilationUnit unit = JavaCore.createCompilationUnitFrom((IFile)file);
            if (!(unit instanceof GroovyCompilationUnit)) {
                return;
            }
            GroovyCompilationUnit groovyUnit = (GroovyCompilationUnit)unit;
            String filePath = file.getFullPath().toOSString();
            CustomMethodNodeFactory.getInstance().removeMethodNodes(filePath);
            for (ClassNode classNode : groovyUnit.getModuleNode().getClasses()) {
                CustomMethodNodeFactory.getInstance().addMethodNodes(classNode.getName(), classNode.getMethods(), filePath);
            }
        }
        catch (Exception e) {
            LogUtil.printAndLogError((Throwable)e);
        }
        if (generateLibFile) {
            this.generateCustomKeywordLibFile(libFolder);
        }
    }

    public void parseCustomKeywordFile(ICompilationUnit file, IFolder libFolder, boolean generateLibFile) throws Exception {
        try {
            if (file instanceof GroovyCompilationUnit) {
                String filePath = file.getPath().toOSString();
                GroovyCompilationUnit unit = (GroovyCompilationUnit)file;
                CustomMethodNodeFactory.getInstance().removeMethodNodes(filePath);
                for (ClassNode classNode : unit.getModuleNode().getClasses()) {
                    CustomMethodNodeFactory.getInstance().addMethodNodes(classNode.getName(), classNode.getMethods(), filePath);
                }
            }
        }
        catch (Exception exception) {}
        if (generateLibFile) {
            this.generateCustomKeywordLibFile(libFolder);
        }
    }

    public void parseCustomKeywordInPackage(List<ICompilationUnit> keywordFiles, IFolder libFolder) throws Exception {
        for (ICompilationUnit file : keywordFiles) {
            this.parseCustomKeywordFile(file, libFolder, false);
        }
        this.generateCustomKeywordLibFile(libFolder);
    }

    public void removeMethodNodesCustomKeywordFile(IFile file, IFolder libFolder) throws Exception {
        CustomMethodNodeFactory.getInstance().removeMethodNodes(file.getFullPath().toOSString());
        this.generateCustomKeywordLibFile(libFolder);
    }

    private List<IFile> getProjectCustomKeywordFiles(IFolder folder) throws Exception {
        ArrayList<IFile> children = new ArrayList<IFile>();
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if ("groovy".equals(file.getFileExtension())) {
                    children.add((IFile)resource);
                }
            } else if (resource instanceof IFolder) {
                children.addAll(this.getProjectCustomKeywordFiles((IFolder)resource));
            }
            ++n2;
        }
        return children;
    }

    private void generateCustomKeywordLibFile(IFolder libFolder) throws Exception {
        File libFolderRaw = new File(libFolder.getRawLocation().toString());
        if (!libFolderRaw.exists()) {
            libFolderRaw.mkdirs();
        }
        IFile iFile = null;
        File file = new File(libFolderRaw, CUSTOM_KEYWORDS_FILE_NAME);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        iFile = libFolder.getFile(file.getName());
        iFile.refreshLocal(0, null);
        while (!file.canWrite()) {
            Thread.sleep(5L);
        }
        Class<?> clazz = Class.forName(TEMPLATE_CLASS_NAME);
        GroovyObject object = (GroovyObject)clazz.newInstance();
        object.invokeMethod(GENERATED_KEYWORD_METHOD_NAME, (Object)new Object[]{file});
        iFile.refreshLocal(0, null);
        this.loadAllCustomKeywordProxyMethods(libFolder);
    }

    public List<MethodNode> getAllMethodNodes(IFolder libFolder) {
        if (methodNodes == null || methodNodes.isEmpty()) {
            this.loadAllCustomKeywordProxyMethods(libFolder);
        }
        return methodNodes;
    }

    private void loadAllCustomKeywordProxyMethods(IFolder libFolder) {
        IFile iFile = libFolder.getFile(CUSTOM_KEYWORDS_FILE_NAME);
        GroovyCompilationUnit unit = (GroovyCompilationUnit)JavaCore.createCompilationUnitFrom((IFile)iFile);
        ClassNode classNode = (ClassNode)unit.getModuleNode().getClasses().get(0);
        if (classNode != null && classNode.getModule() != null && classNode.getModule().getMethods() != null) {
            methodNodes = new ArrayList<MethodNode>(classNode.getModule().getMethods());
            Collections.sort(methodNodes, new Comparator<MethodNode>(){

                @Override
                public int compare(MethodNode methodA, MethodNode methodB) {
                    return methodA.getName().compareToIgnoreCase(methodB.getName());
                }
            });
        }
    }
}

