/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.control;

import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class DragableCTabFolder
extends CTabFolder {
    private static final String DRAGED_ITEM_INDEX = "draggedItemIndex";
    private static final String SOURCE_FOLDER = "sourceFolder";
    private static final String IS_SHOWING = "isShowing";
    private static final String ITEM_CAPTION = "itemCaption";
    public int marginWidth = 10;
    public int marginHeight = 10;

    public DragableCTabFolder(Composite parent, int style) {
        super(parent, style | 0x800);
        this.setBorderVisible(true);
        this.enableDrag();
    }

    private void enableDrag() {
        this.addDragListener(this);
        this.addDropListener(this);
    }

    private void enablePopout() {
        this.addPopoutListener(this);
    }

    private void addDragListener(final CTabFolder tabFolder) {
        final LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
        DragSourceAdapter dragAdapter = new DragSourceAdapter(){
            private CTabItem item;

            public void dragStart(DragSourceEvent event) {
                event.doit = tabFolder.getItemCount() != 0;
                Point cursorLocation = tabFolder.getDisplay().getCursorLocation();
                this.item = tabFolder.getItem(tabFolder.toControl(cursorLocation));
                event.doit = this.item != null;
            }

            public void dragSetData(DragSourceEvent event) {
                Control control = this.item.getControl();
                control.setData(DragableCTabFolder.ITEM_CAPTION, (Object)this.item.getText());
                control.setData(DragableCTabFolder.IS_SHOWING, (Object)(tabFolder.getSelectionIndex() == tabFolder.indexOf(this.item) ? 1 : 0));
                control.setData(DragableCTabFolder.SOURCE_FOLDER, (Object)tabFolder);
                control.setData(DragableCTabFolder.DRAGED_ITEM_INDEX, (Object)tabFolder.indexOf(this.item));
                transfer.setSelection((ISelection)new StructuredSelection((Object)control));
                this.item.setControl(null);
                this.item.dispose();
            }
        };
        DragSource dragSource = new DragSource((Control)tabFolder, 2);
        dragSource.setTransfer(new Transfer[]{transfer});
        dragSource.addDragListener((DragSourceListener)dragAdapter);
    }

    private void addDropListener(final CTabFolder tabFolder) {
        final LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
        DropTargetAdapter dragAdapter = new DropTargetAdapter(){
            private int indexToInsert;

            public void dragOver(DropTargetEvent event) {
                if (tabFolder.getDisplay().getCursorControl() instanceof CTabFolder) {
                    event.detail = 2;
                    CTabItem itemUnderCursor = tabFolder.getItem(tabFolder.toControl(tabFolder.getDisplay().getCursorLocation()));
                    this.indexToInsert = tabFolder.indexOf(itemUnderCursor);
                    if (itemUnderCursor == null) {
                        this.indexToInsert = tabFolder.getItemCount() - 1;
                        tabFolder.setInsertMark(this.indexToInsert, true);
                    } else {
                        Rectangle bounds = itemUnderCursor.getBounds();
                        int x = tabFolder.toControl((int)event.x, (int)event.y).x;
                        int middle = bounds.x + bounds.width / 2;
                        if (x <= middle) {
                            --this.indexToInsert;
                            tabFolder.setInsertMark(this.indexToInsert, false);
                        } else {
                            tabFolder.setInsertMark(this.indexToInsert, true);
                        }
                    }
                } else {
                    event.detail = 0;
                    tabFolder.setInsertMark(-1, true);
                }
                if (this.indexToInsert == -1) {
                    tabFolder.redraw();
                }
            }

            public void drop(DropTargetEvent event) {
                Control droppedObj = (Control)((StructuredSelection)transfer.getSelection()).getFirstElement();
                Object source = droppedObj.getData(DragableCTabFolder.SOURCE_FOLDER);
                String itemCaption = (String)droppedObj.getData(DragableCTabFolder.ITEM_CAPTION);
                int dragedItemIndex = (Integer)droppedObj.getData(DragableCTabFolder.DRAGED_ITEM_INDEX);
                if (source == tabFolder) {
                    if (this.indexToInsert < dragedItemIndex) {
                        ++this.indexToInsert;
                    }
                } else {
                    ++this.indexToInsert;
                }
                this.createNewItem(tabFolder, this.indexToInsert, droppedObj, itemCaption, (Boolean)droppedObj.getData(DragableCTabFolder.IS_SHOWING));
            }

            private CTabItem createNewItem(CTabFolder folder, int index, Control droppedObj, String itemCaption, boolean select) {
                CTabItem item = new CTabItem(folder, 0, index);
                item.setText(itemCaption);
                droppedObj.setParent((Composite)folder);
                item.setControl(droppedObj);
                if (select) {
                    folder.setSelection(item);
                }
                return item;
            }
        };
        DropTarget dropTarget = new DropTarget((Control)tabFolder, 2);
        dropTarget.setTransfer(new Transfer[]{transfer});
        dropTarget.addDropListener((DropTargetListener)dragAdapter);
    }

    private void addPopoutListener(final CTabFolder tabFolder) {
        Listener dragListener = new Listener(){
            private CTabItem dragItem;

            public void handleEvent(Event event) {
                Point mouseLocation = new Point(event.x, event.y);
                switch (event.type) {
                    case 29: {
                        CTabItem item = tabFolder.getItem(mouseLocation);
                        if (this.dragItem != null || item == null) break;
                        this.dragItem = item;
                        tabFolder.setCapture(true);
                        break;
                    }
                    case 4: {
                        if (this.dragItem == null || tabFolder.getBounds().contains(mouseLocation)) break;
                        DragableCTabFolder.popOut(this.dragItem, tabFolder.toDisplay(mouseLocation));
                        this.dragItem.dispose();
                        this.dragItem = null;
                    }
                }
            }
        };
        tabFolder.addListener(29, dragListener);
        tabFolder.addListener(4, dragListener);
    }

    private static void popOut(CTabItem tabItem, Point location) {
        Control control = tabItem.getControl();
        tabItem.setControl(null);
        Shell itemShell = new Shell(tabItem.getParent().getShell(), 2160);
        itemShell.setLayout((Layout)new FillLayout());
        control.setParent((Composite)itemShell);
        control.setVisible(true);
        itemShell.pack();
        itemShell.setLocation(location);
        itemShell.open();
    }
}

