/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.control;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.control.CTreeViewer;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.ColorUtil;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class TreeEntitySelectionComposite
extends Composite {
    private Text txtInput;
    private CLabel lblSearch;
    private IEntityLabelProvider labelProvider;
    private AbstractEntityViewerFilter entityViewerFilter;
    private ITreeContentProvider contentProvider;
    private boolean isSearched;
    private TreeViewer treeViewer;
    private int treeViewerStyle;

    public TreeEntitySelectionComposite(Composite parent, int treeViewerStyle, ITreeContentProvider contentProvider, AbstractEntityViewerFilter entityViewerFilter, IEntityLabelProvider labelProvider) {
        super(parent, 0);
        this.treeViewerStyle = treeViewerStyle;
        this.contentProvider = contentProvider;
        this.entityViewerFilter = entityViewerFilter;
        this.labelProvider = labelProvider;
        this.treeViewer = this.createTreeView();
        this.isSearched = false;
        this.updateStatusSearchLabel();
    }

    private TreeViewer createTreeView() {
        this.setLayout((Layout)new GridLayout(1, false));
        Composite searchComposite = new Composite((Composite)this, 2048);
        searchComposite.setBackground(ColorUtil.getWhiteBackgroundColor());
        GridLayout glSearchComposite = new GridLayout(2, false);
        glSearchComposite.verticalSpacing = 0;
        glSearchComposite.horizontalSpacing = 0;
        glSearchComposite.marginWidth = 0;
        glSearchComposite.marginHeight = 0;
        searchComposite.setLayout((Layout)glSearchComposite);
        GridData grSearchComposite = new GridData(768);
        grSearchComposite.heightHint = 24;
        searchComposite.setLayoutData((Object)grSearchComposite);
        this.txtInput = new Text(searchComposite, 0);
        this.txtInput.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.txtInput.setMessage(StringConstants.DIA_SEARCH_TEXT_DEFAULT_VALUE);
        GridData gdTxtInput = new GridData(768);
        gdTxtInput.grabExcessVerticalSpace = true;
        gdTxtInput.verticalAlignment = 0x1000000;
        this.txtInput.setLayoutData((Object)gdTxtInput);
        this.txtInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TreeEntitySelectionComposite.this.filterSearchedText();
            }
        });
        Canvas canvasSearch = new Canvas(searchComposite, 0);
        canvasSearch.setLayout((Layout)new FillLayout(256));
        canvasSearch.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblSearch = new CLabel((Composite)canvasSearch, 0);
        this.lblSearch.setBackground(searchComposite.getBackground());
        this.lblSearch.setCursor(new Cursor((Device)Display.getCurrent(), 21));
        this.lblSearch.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                if (TreeEntitySelectionComposite.this.isSearched) {
                    TreeEntitySelectionComposite.this.isSearched = !TreeEntitySelectionComposite.this.isSearched;
                    TreeEntitySelectionComposite.this.txtInput.setText("");
                }
            }
        });
        CTreeViewer treeViewer = new CTreeViewer(this, this.treeViewerStyle);
        this.expandTreeViewerToInitialElements();
        treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        treeViewer.getTree().setFocus();
        treeViewer.setLabelProvider(this.labelProvider);
        treeViewer.addFilter(this.entityViewerFilter);
        treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        return treeViewer;
    }

    public void setInput(Object[] treeEntities) {
        this.treeViewer.setInput((Object)treeEntities);
    }

    protected void expandTreeViewerToInitialElements() {
        if (this.getInitialElementSelections() != null && !this.getInitialElementSelections().isEmpty()) {
            this.getTreeViewer().expandToLevel((Object)this.getInitialElementSelections().get(0), -1);
        }
    }

    private List<ITreeEntity> getInitialElementSelections() {
        return Collections.emptyList();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private void updateStatusSearchLabel() {
        if (this.isSearched) {
            this.lblSearch.setImage(ImageConstants.IMG_16_CLOSE_SEARCH);
            this.lblSearch.setToolTipText(StringConstants.DIA_IMAGE_CLOSE_SEARCH_TOOLTIP);
        } else {
            this.lblSearch.setImage(ImageConstants.IMG_16_SEARCH);
            this.lblSearch.setToolTipText(StringConstants.DIA_IMAGE_SEARCH_TOOLTIP);
        }
    }

    protected String getSearchMessage() {
        try {
            return String.valueOf(StringConstants.DIA_KEYWORD_SEARCH_ALL) + ":" + this.txtInput.getText();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return "";
        }
    }

    protected void filterSearchedText() {
        final String searchString = this.txtInput.getText();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (TreeEntitySelectionComposite.this.txtInput.isDisposed()) {
                        return;
                    }
                    if (searchString.equals(TreeEntitySelectionComposite.this.txtInput.getText()) && TreeEntitySelectionComposite.this.getTreeViewer().getInput() != null) {
                        String broadcastMessage = TreeEntitySelectionComposite.this.getSearchMessage();
                        TreeEntitySelectionComposite.this.labelProvider.setSearchString(broadcastMessage);
                        TreeEntitySelectionComposite.this.entityViewerFilter.setSearchString(broadcastMessage);
                        TreeEntitySelectionComposite.this.getTreeViewer().refresh();
                        if (searchString != null && !searchString.isEmpty()) {
                            TreeEntitySelectionComposite.this.isSearched = true;
                            TreeEntitySelectionComposite.this.getTreeViewer().expandAll();
                        } else {
                            TreeEntitySelectionComposite.this.isSearched = false;
                            TreeEntitySelectionComposite.this.getTreeViewer().collapseAll();
                        }
                        TreeEntitySelectionComposite.this.updateStatusSearchLabel();
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        });
    }
}

