/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.dialogs;

import com.kms.katalon.application.utils.LicenseUtil;
import com.kms.katalon.composer.components.controls.HelpComposite;
import com.kms.katalon.composer.components.impl.components.ConnectionPropertyTable;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.controller.DatabaseController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.db.ConnectionProperty;
import com.kms.katalon.core.db.DBConnectionProperties;
import com.kms.katalon.core.db.DatabaseConnection;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.tracking.service.Trackings;
import java.io.IOException;
import java.net.URLClassLoader;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class DatabaseConnectionAbstractDialog
extends AbstractDialog {
    private static final String JDBC_PROTOCOL = "jdbc:";
    protected Button chkGlobalDBSetting;
    protected Button chkSecureUserPassword;
    protected Text txtUser;
    protected Text txtPassword;
    protected Button btnTestConnection;
    protected Label lblStatus;
    private Composite compDriverInfo;
    protected Text txtConnectionURL;
    protected Text txtQuery;
    protected Text txtDriverClassName;
    protected boolean isChanged;
    private Composite compDatabase;
    private GridData gdLblOptionsDB;
    private GridData gdTxtDriverClassName;
    private Label lblOptionsDB;
    private IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
    protected ConnectionPropertyTable connectionPropertyTable;
    protected DBConnectionProperties DBConnectionProperties;

    public DatabaseConnectionAbstractDialog(Shell parentShell) {
        super(parentShell);
        this.setDialogTitle(StringConstants.DIA_TITLE_DB_CONNECTION_QUERY_SETTINGS);
        this.connectionPropertyTable = new ConnectionPropertyTable(this, parentShell);
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    @Override
    protected Control createDialogContainer(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 2560);
        Composite main = new Composite((Composite)sc, 0);
        GridLayout glMain = new GridLayout();
        glMain.marginHeight = 0;
        glMain.marginWidth = 0;
        main.setLayout((Layout)glMain);
        this.createDatabasePart(main);
        this.createQueryPart(main);
        sc.setContent((Control)main);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(main.computeSize(-1, -1));
        return parent;
    }

    private void createDatabasePart(Composite parent) {
        this.compDatabase = new Composite(parent, 0);
        this.compDatabase.setLayout((Layout)new GridLayout());
        this.compDatabase.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Group grpDatabase = new Group(this.compDatabase, 0);
        grpDatabase.setLayout((Layout)new GridLayout());
        grpDatabase.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpDatabase.setText(StringConstants.DIA_GRP_DATABASE_CONNECTION);
        Composite databaseComposite = new Composite((Composite)grpDatabase, 0);
        databaseComposite.setLayout((Layout)new GridLayout(2, false));
        databaseComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.chkGlobalDBSetting = new Button(databaseComposite, 32);
        this.chkGlobalDBSetting.setText(StringConstants.DIA_CHK_USE_GLOBAL_DB_SETTINGS);
        this.chkGlobalDBSetting.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        new Label(databaseComposite, 0);
        this.chkSecureUserPassword = new Button(databaseComposite, 32);
        this.chkSecureUserPassword.setText(StringConstants.DIA_CHK_SECURE_USER_PASSWORD);
        this.chkSecureUserPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblUser = new Label(databaseComposite, 0);
        lblUser.setText(StringConstants.DIA_LBL_USER);
        lblUser.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.txtUser = new Text(databaseComposite, 2048);
        this.txtUser.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPassword = new Label(databaseComposite, 0);
        lblPassword.setText(StringConstants.DIA_LBL_PASSWORD);
        lblPassword.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.txtPassword = new Text(databaseComposite, 0x400800);
        this.txtPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblOptionsDB = new Label(databaseComposite, 0);
        this.lblOptionsDB.setText("JDBC driver");
        this.gdLblOptionsDB = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.lblOptionsDB.setLayoutData((Object)this.gdLblOptionsDB);
        this.txtDriverClassName = new Text(databaseComposite, 2048);
        this.gdTxtDriverClassName = new GridData(4, 0x1000000, true, false, 1, 1);
        this.txtDriverClassName.setLayoutData((Object)this.gdTxtDriverClassName);
        new Label(databaseComposite, 0);
        this.compDriverInfo = new Composite(databaseComposite, 0);
        GridLayout glDriverInfo = new GridLayout(2, false);
        glDriverInfo.marginHeight = 0;
        glDriverInfo.horizontalSpacing = 2;
        this.compDriverInfo.setLayout((Layout)glDriverInfo);
        Label lblDriverInfo = new Label(this.compDriverInfo, 0);
        lblDriverInfo.setText(StringConstants.DIA_LBL_DRIVER_INFO);
        ControlUtils.setFontStyle((Control)lblDriverInfo, 2, -1);
        new HelpComposite(this.compDriverInfo, StringConstants.DIA_LINK_DRIVER_INFO);
        Label lblConnectionURL = new Label(databaseComposite, 0);
        lblConnectionURL.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblConnectionURL.setText(StringConstants.DIA_LBL_CONNECTION_URL);
        this.txtConnectionURL = new Text(databaseComposite, 2626);
        GridData layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        layoutData.heightHint = 80;
        this.txtConnectionURL.setLayoutData((Object)layoutData);
        this.connectionPropertyTable.createContent((Composite)grpDatabase);
        this.createTestConnectionComposite(this.connectionPropertyTable.getTableComposite());
        this.createConnectionUrlSample((Composite)grpDatabase);
    }

    private void createTestConnectionComposite(Composite composite) {
        Composite compTestConn = new Composite(composite, 0);
        GridLayout glTestConn = new GridLayout(2, false);
        glTestConn.marginHeight = 0;
        glTestConn.marginWidth = 0;
        compTestConn.setLayout((Layout)glTestConn);
        compTestConn.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnTestConnection = new Button(compTestConn, 0);
        this.btnTestConnection.setText(StringConstants.DIA_BTN_TEST_CONNECTION);
        this.lblStatus = new Label(compTestConn, 0);
        this.lblStatus.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    private void createConnectionUrlSample(Composite parent) {
        Composite databaseComposite = new Composite(parent, 0);
        databaseComposite.setLayout((Layout)new GridLayout(2, false));
        databaseComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite compSample = new Composite(databaseComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        compSample.setLayout((Layout)layout);
        compSample.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lblSampleURL = new Label(compSample, 0);
        lblSampleURL.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblSampleURL.setText(StringConstants.DIA_LBL_CONNECTION_URL_SAMPLE);
        Label separator = new Label(compSample, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.addLink(databaseComposite, StringConstants.DIA_LNK_MYSQL, StringConstants.DIA_LINK_MYSQL_DOC);
        Text txtMySQLURL = new Text(databaseComposite, 8);
        txtMySQLURL.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        txtMySQLURL.setText(StringConstants.DIA_TXT_MYSQL_SAMPLE_LINK);
        this.addLink(databaseComposite, StringConstants.DIA_LNK_SQL_SERVER, StringConstants.DIA_LINK_DB_SETTINGS_DOC);
        Text txtSQLServerURL = new Text(databaseComposite, 8);
        txtSQLServerURL.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        txtSQLServerURL.setText(StringConstants.DIA_TXT_SQL_SERVER_SAMPLE_LINK);
        this.addLink(databaseComposite, StringConstants.DIA_LNK_ORACLE_SQL, StringConstants.DIA_LINK_DB_SETTINGS_DOC);
        Text txtOracleSQLURL1 = new Text(databaseComposite, 74);
        txtOracleSQLURL1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        txtOracleSQLURL1.setText(StringConstants.DIA_TXT_ORACLE_SQL_SAMPLE_THIN_LINK);
        new Label(databaseComposite, 0);
        Text txtOracleSQLURL2 = new Text(databaseComposite, 8);
        txtOracleSQLURL2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        txtOracleSQLURL2.setText(StringConstants.DIA_TXT_ORACLE_SQL_SAMPLE_OCI_LINK);
        this.addLink(databaseComposite, StringConstants.DIA_LNK_POSTGRESQL, StringConstants.DIA_LINK_DB_SETTINGS_DOC);
        Text txtPostgreSQLURL = new Text(databaseComposite, 8);
        txtPostgreSQLURL.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        txtPostgreSQLURL.setText(StringConstants.DIA_TXT_POSTGRESQL_SAMPLE_LINK);
    }

    private void createQueryPart(Composite parent) {
        Composite compQuery = new Composite(parent, 0);
        compQuery.setLayout((Layout)new GridLayout());
        compQuery.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Group grpQuery = new Group(compQuery, 0);
        grpQuery.setLayout((Layout)new GridLayout());
        grpQuery.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpQuery.setText(StringConstants.DIA_LBL_SQL_QUERY);
        this.txtQuery = new Text((Composite)grpQuery, 2626);
        GridData layoutData = new GridData(4, 4, true, true, 1, 1);
        layoutData.minimumHeight = 80;
        this.txtQuery.setLayoutData((Object)layoutData);
    }

    @Override
    protected void registerControlModifyListeners() {
        this.chkGlobalDBSetting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseConnectionAbstractDialog.this.setChanged();
                DatabaseConnectionAbstractDialog.this.enableCustomDBConnection(!DatabaseConnectionAbstractDialog.this.chkGlobalDBSetting.getSelection());
            }
        });
        this.chkSecureUserPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseConnectionAbstractDialog.this.setChanged();
                DatabaseConnectionAbstractDialog.this.enableUserPassword(DatabaseConnectionAbstractDialog.this.chkSecureUserPassword.getSelection());
            }
        });
        ModifyListener textModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatabaseConnectionAbstractDialog.this.setChanged();
            }
        };
        this.txtUser.addModifyListener(textModifyListener);
        this.txtPassword.addModifyListener(textModifyListener);
        this.txtConnectionURL.addModifyListener(textModifyListener);
        this.txtQuery.addModifyListener(textModifyListener);
        this.txtDriverClassName.addModifyListener(textModifyListener);
        this.btnTestConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClassLoader oldClassLoader = null;
                DatabaseConnection dbConn = DatabaseConnectionAbstractDialog.this.getDatabaseConnection();
                try {
                    oldClassLoader = Thread.currentThread().getContextClassLoader();
                    URLClassLoader projectClassLoader = ProjectController.getInstance().getProjectClassLoader(ProjectController.getInstance().getCurrentProject());
                    Thread.currentThread().setContextClassLoader(projectClassLoader);
                    if (DatabaseConnectionAbstractDialog.this.chkGlobalDBSetting.getSelection()) {
                        dbConn = DatabaseController.getInstance().getGlobalDatabaseConnection();
                    }
                    if (dbConn == null) {
                        DatabaseConnectionAbstractDialog.this.setStatusLabel(MessageFormat.format(StringConstants.DIA_LBL_TEST_STATUS_FAIL, StringConstants.DIA_MSG_CONNECTION_EMPTY), ColorUtil.getTextErrorColor());
                        return;
                    }
                    dbConn.getConnection();
                    if (!dbConn.isAlive()) {
                        DatabaseConnectionAbstractDialog.this.setStatusLabel(MessageFormat.format(StringConstants.DIA_LBL_TEST_STATUS_FAIL, StringConstants.DIA_LBL_CONNECTION_CLOSED), ColorUtil.getTextErrorColor());
                        return;
                    }
                    try {
                        DatabaseConnectionAbstractDialog.this.setStatusLabel(StringConstants.DIA_LBL_TEST_STATUS_SUCCESS, ColorUtil.getTextSuccessfulColor());
                    }
                    catch (IOException | SQLException | CoreException ex) {
                        DatabaseConnectionAbstractDialog.this.setStatusLabel(MessageFormat.format(StringConstants.DIA_LBL_TEST_STATUS_FAIL, ex.getMessage()), ColorUtil.getTextErrorColor());
                    }
                }
                finally {
                    if (dbConn != null) {
                        dbConn.close();
                    }
                    if (oldClassLoader != null) {
                        Thread.currentThread().setContextClassLoader(oldClassLoader);
                    }
                }
            }
        });
        this.lblStatus.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (DatabaseConnectionAbstractDialog.this.lblStatus.getText().isEmpty()) {
                    return;
                }
                MessageDialog.openInformation((Shell)DatabaseConnectionAbstractDialog.this.getShell(), (String)StringConstants.DIA_TITLE_STATUS_DETAILS, (String)DatabaseConnectionAbstractDialog.this.lblStatus.getToolTipText());
            }
        });
    }

    private DatabaseConnection getDatabaseConnection() {
        String user = null;
        String password = null;
        String driverClassName = null;
        if (this.chkSecureUserPassword.getSelection()) {
            user = this.txtUser.getText();
            password = this.txtPassword.getText();
            driverClassName = this.txtDriverClassName.getText();
        }
        if (!StringUtils.startsWithIgnoreCase((String)this.txtConnectionURL.getText(), (String)JDBC_PROTOCOL)) {
            return null;
        }
        DatabaseConnection databaseConnection = new DatabaseConnection(this.txtConnectionURL.getText(), user, password, driverClassName);
        databaseConnection.setConnectionProperties(this.connectionPropertyTable.getConnectionProperties());
        return databaseConnection;
    }

    protected Point getInitialSize() {
        return new Point(800, super.getInitialSize().y);
    }

    protected int getShellStyle() {
        return 33888;
    }

    protected void okPressed() {
        String connectionUrl = this.txtConnectionURL.getText();
        boolean useGlobalDBSetting = this.chkGlobalDBSetting.getSelection();
        if (!useGlobalDBSetting) {
            if (this.isOracleSql(connectionUrl) && !this.featureService.canUse(KSEFeature.ORACLE_EXTERNAL_DATA)) {
                KSEFeatureAccessHandler.handleUnauthorizedAccess(KSEFeature.ORACLE_EXTERNAL_DATA);
                return;
            }
            if (this.isMicrosoftSqlServer(connectionUrl) && !this.featureService.canUse(KSEFeature.SQL_SERVER_EXTERNAL_DATA)) {
                KSEFeatureAccessHandler.handleUnauthorizedAccess(KSEFeature.SQL_SERVER_EXTERNAL_DATA);
                return;
            }
            if (StringUtils.isNotBlank((String)this.txtDriverClassName.getText()) && !this.featureService.canUse(KSEFeature.ADDTIONAL_TEST_DATA_SOURCE)) {
                KSEFeatureAccessHandler.handleUnauthorizedAccess(KSEFeature.ADDTIONAL_TEST_DATA_SOURCE);
                return;
            }
        }
        if (!useGlobalDBSetting) {
            if (this.isOracleSql(connectionUrl)) {
                Trackings.trackUseDatabaseConnectionForEnterpriseAccount((String)"oracle");
            }
            if (this.isMicrosoftSqlServer(connectionUrl)) {
                Trackings.trackUseDatabaseConnectionForEnterpriseAccount((String)"mssql");
            }
            if (StringUtils.isNotBlank((String)this.txtDriverClassName.getText())) {
                Trackings.trackUseAdditionalTestDataSource();
            }
        }
        this.updateChanges();
        super.okPressed();
    }

    protected abstract void updateChanges();

    public void setChanged() {
        if (this.isChanged) {
            return;
        }
        this.isChanged = true;
    }

    protected void enableCustomDBConnection(boolean enabled) {
        this.chkSecureUserPassword.setEnabled(enabled);
        this.enableUserPassword(enabled && this.chkSecureUserPassword.getSelection());
        this.txtConnectionURL.setEnabled(enabled);
        this.txtDriverClassName.setEnabled(enabled);
        this.connectionPropertyTable.enableConnectionPropertiesArea(enabled);
    }

    private void enableUserPassword(boolean enabled) {
        this.txtUser.setEnabled(enabled);
        this.txtPassword.setEnabled(enabled);
    }

    private void setStatusLabel(String msg, Color msgColor) {
        this.lblStatus.setCursor(Display.getCurrent().getSystemCursor(21));
        this.lblStatus.setForeground(msgColor);
        this.lblStatus.setText(StringUtils.abbreviate((String)msg, (int)80));
        this.lblStatus.setToolTipText(msg);
    }

    private Link addLink(Composite parent, String label, final String hyperlink) {
        Link link = new Link(parent, 0);
        link.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        link.setText(String.valueOf(label) + " (<a href=\"" + hyperlink + "\">Docs</a>)");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)hyperlink);
            }
        });
        return link;
    }

    protected boolean isEnterpriseAccount() {
        return LicenseUtil.isNotFreeLicense();
    }

    private boolean isOracleSql(String connectionUrl) {
        if (StringUtils.isEmpty((String)connectionUrl)) {
            return false;
        }
        return connectionUrl.startsWith("jdbc:oracle");
    }

    private boolean isMicrosoftSqlServer(String connectionUrl) {
        if (StringUtils.isEmpty((String)connectionUrl)) {
            return false;
        }
        return connectionUrl.startsWith("jdbc:sqlserver");
    }

    protected void showDriverComposite() {
        if (!this.isEnterpriseAccount()) {
            this.gdLblOptionsDB.heightHint = 0;
            this.gdTxtDriverClassName.heightHint = 0;
            this.txtDriverClassName.setVisible(false);
            this.lblOptionsDB.setVisible(false);
            this.compDatabase.layout(true);
        }
    }

    protected void initialInputConnectionProperies(DBConnectionProperties DBConnectionProperties2) {
        this.DBConnectionProperties = DBConnectionProperties2;
        List list = DBConnectionProperties2.getConnectionProperty();
        if (list == null) {
            this.connectionPropertyTable.setTableInput(new ArrayList<ConnectionProperty>());
        } else {
            this.connectionPropertyTable.setTableInput(list);
        }
        this.connectionPropertyTable.redrawTable();
    }

    public void setDBConnectionProperties(DBConnectionProperties dBConnectionProperties) {
        this.DBConnectionProperties = dBConnectionProperties;
    }

    public DBConnectionProperties getDBConnectionProperties() {
        return this.DBConnectionProperties;
    }

    protected abstract void updateConnectionProperties();
}

