/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.editors.extensions;

import com.kms.katalon.composer.components.impl.editors.extensions.ASTNodeFinder;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.CodeSelectRequestor;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.jdt.groovy.model.GroovyClassFileWorkingCopy;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.model.ICodeSelectHelper;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorFactory;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorWithRequestor;

public class CodeSelectHelper
implements ICodeSelectHelper {
    public IJavaElement[] select(GroovyCompilationUnit unit, int start, int length) {
        ModuleNode module;
        char[] contents = unit.getContents();
        if (length == 0) {
            while (start > 0 && Character.isJavaIdentifierPart(contents[start - 1])) {
                --start;
                ++length;
            }
            while (contents.length > start + length && Character.isJavaIdentifierPart(contents[start + length])) {
                ++length;
            }
        }
        if (length > 1 && contents.length > start + 1 && contents[start] == '$' && contents[start + 1] != '{') {
            ++start;
            --length;
        }
        if ((module = unit.getModuleNode()) != null) {
            String event;
            block14: {
                IJavaElement[] iJavaElementArray;
                block17: {
                    Region region;
                    ASTNode node;
                    Region select;
                    block15: {
                        IJavaElement[] iJavaElementArray2;
                        block16: {
                            event = null;
                            if (GroovyLogManager.manager.hasLoggers()) {
                                GroovyLogManager.manager.log(TraceCategory.CODE_SELECT, String.valueOf(unit.getElementName()) + " at [" + start + "," + length + "]");
                                event = "Code select: " + unit.getElementName();
                                GroovyLogManager.manager.logStart(event);
                            }
                            select = new Region(start, length);
                            Object[] result = this.findNodeForRegion(module, select);
                            node = (ASTNode)result[0];
                            region = (Region)result[1];
                            if (!(node instanceof AnnotatedNode) || CodeSelectHelper.isKeyword(node, contents, start, length)) break block14;
                            if (!CodeSelectHelper.isTypeDeclaration(node, module)) break block15;
                            iJavaElementArray2 = CodeSelectHelper.returnThisNode(node, unit);
                            if (event == null) break block16;
                            GroovyLogManager.manager.logEnd(event, TraceCategory.CODE_SELECT);
                        }
                        return iJavaElementArray2;
                    }
                    try {
                        CodeSelectRequestor requestor = this.createRequestor(node, region, select, unit);
                        TypeInferencingVisitorWithRequestor visitor = new TypeInferencingVisitorFactory().createVisitor(unit);
                        visitor.visitCompilationUnit((ITypeRequestor)requestor);
                        iJavaElementArray = requestor.getRequestedElements();
                        if (event == null) break block17;
                    }
                    catch (RuntimeException e) {
                        try {
                            if (event != null) {
                                GroovyLogManager.manager.logException(TraceCategory.CODE_SELECT, (Throwable)e);
                            }
                            throw e;
                        }
                        catch (Throwable throwable) {
                            if (event != null) {
                                GroovyLogManager.manager.logEnd(event, TraceCategory.CODE_SELECT);
                            }
                            throw throwable;
                        }
                    }
                    GroovyLogManager.manager.logEnd(event, TraceCategory.CODE_SELECT);
                }
                return iJavaElementArray;
            }
            if (event != null) {
                GroovyLogManager.manager.logEnd(event, TraceCategory.CODE_SELECT);
            }
        }
        return new IJavaElement[0];
    }

    public ASTNode selectASTNode(GroovyCompilationUnit unit, int start, int length) {
        ModuleNode module = unit.getModuleNode();
        if (module != null) {
            String event;
            block7: {
                ASTNode aSTNode;
                block10: {
                    Region region;
                    ASTNode node;
                    Region select;
                    block8: {
                        ClassNode classNode;
                        block9: {
                            event = null;
                            if (GroovyLogManager.manager.hasLoggers()) {
                                GroovyLogManager.manager.log(TraceCategory.CODE_SELECT, "Code select starting on " + unit.getElementName() + " at [ " + start + "," + length + " ]");
                                event = "Code select: " + unit.getElementName();
                                GroovyLogManager.manager.logStart(event);
                            }
                            try {
                                select = new Region(start, length);
                                Object[] result = this.findNodeForRegion(module, select);
                                node = (ASTNode)result[0];
                                region = (Region)result[1];
                                if (node == null) break block7;
                                if (!CodeSelectHelper.isTypeDeclaration(node, module)) break block8;
                                classNode = ((ClassNode)node).redirect();
                                if (event == null) break block9;
                            }
                            catch (Throwable throwable) {
                                if (event != null) {
                                    GroovyLogManager.manager.logEnd(event, TraceCategory.CODE_SELECT);
                                }
                                throw throwable;
                            }
                            GroovyLogManager.manager.logEnd(event, TraceCategory.CODE_SELECT);
                        }
                        return classNode;
                    }
                    CodeSelectRequestor requestor = this.createRequestor(node, region, select, unit);
                    TypeInferencingVisitorWithRequestor visitor = new TypeInferencingVisitorFactory().createVisitor(unit);
                    visitor.visitCompilationUnit((ITypeRequestor)requestor);
                    aSTNode = requestor.getRequestedNode();
                    if (event == null) break block10;
                    GroovyLogManager.manager.logEnd(event, TraceCategory.CODE_SELECT);
                }
                return aSTNode;
            }
            if (event != null) {
                GroovyLogManager.manager.logEnd(event, TraceCategory.CODE_SELECT);
            }
        }
        return null;
    }

    protected CodeSelectRequestor createRequestor(ASTNode node, Region nodeRegion, Region selectRegion, GroovyCompilationUnit unit) {
        return new CodeSelectRequestor(node, nodeRegion, selectRegion, unit);
    }

    protected Object[] findNodeForRegion(ModuleNode module, Region r) {
        ASTNodeFinder finder = new ASTNodeFinder(r);
        finder.doVisit(module);
        return new Object[]{finder.result, finder.sloc};
    }

    protected static boolean isKeyword(ASTNode node, char[] contents, int start, int length) {
        boolean keyword = false;
        if (node instanceof ConstantExpression && ((ConstantExpression)node).isNullExpression()) {
            keyword = true;
        } else if (node instanceof ConstantExpression && ClassHelper.boolean_TYPE.equals((Object)((ConstantExpression)node).getType())) {
            keyword = true;
        } else if (node instanceof VariableExpression && ((VariableExpression)node).isThisExpression()) {
            keyword = true;
        } else if (node instanceof ClassExpression && length == 5) {
            keyword = String.valueOf(contents, start, length).equals("class");
        } else if (node == ClassHelper.DYNAMIC_TYPE && length == 3) {
            keyword = String.valueOf(contents, start, length).equals("def");
        } else if (node instanceof ConstructorCallExpression && length == 3 && start < ((ConstructorCallExpression)node).getNameStart()) {
            keyword = String.valueOf(contents, start, length).equals("new");
        } else if (node instanceof CastExpression && ((CastExpression)node).isCoerce() && length == 2) {
            keyword = String.valueOf(contents, start, length).equals("as");
        } else if (node instanceof MethodCallExpression && ((MethodCallExpression)node).getMethodAsString().equals("isCase") && length == 2) {
            keyword = String.valueOf(contents, start, length).equals("in");
        } else if (node instanceof ImportNode && length == 6 && (start == node.getStart() || ((ImportNode)node).isStatic() && start < node.getStart() + 14)) {
            keyword = true;
        } else if (node instanceof ImportNode && ((ImportNode)node).getAliasExpr() != null && length == 2) {
            keyword = String.valueOf(contents, start, length).equals("as");
        } else if (node instanceof ImportNode && ((ImportNode)node).isStar() && length == 1 && start == node.getEnd() - 1) {
            keyword = true;
        }
        return keyword;
    }

    protected static boolean isStringLiteral(ASTNode node, char[] contents, int start, int length) {
        if (node instanceof ConstantExpression && ClassHelper.STRING_TYPE.equals((Object)((ConstantExpression)node).getType())) {
            return start > node.getStart() && length < node.getLength();
        }
        return false;
    }

    protected static boolean isTypeDeclaration(ASTNode node, ModuleNode module) {
        if (node instanceof ClassNode && !(node instanceof InnerClassNode)) {
            for (ClassNode clazz : module.getClasses()) {
                if (!clazz.equals((Object)node)) continue;
                return true;
            }
        }
        return false;
    }

    protected static IJavaElement[] returnThisNode(ASTNode node, GroovyCompilationUnit unit) {
        String rawName = ((ClassNode)node).getNameWithoutPackage();
        String[] enclosingTypes = rawName.split("\\$");
        IJavaElement candidate = null;
        int i = 0;
        int n = enclosingTypes.length;
        while (i < n) {
            candidate = i == 0 ? unit.getType(enclosingTypes[i]) : candidate.getType(enclosingTypes[i]);
            ++i;
        }
        IJavaElement result = unit instanceof GroovyClassFileWorkingCopy ? ((GroovyClassFileWorkingCopy)unit).convertToBinary(candidate) : candidate;
        return new IJavaElement[]{result};
    }
}

