/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.installer;

import com.kms.katalon.composer.components.impl.constants.ComposerComponentsImplMessageConstants;
import com.kms.katalon.composer.components.impl.dialogs.ComponentInstallerDialog;
import com.kms.katalon.composer.components.impl.exception.RunInstallationStepException;
import com.kms.katalon.composer.components.impl.installer.CustomTailer;
import com.kms.katalon.composer.components.impl.installer.InstallationStep;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.io.input.TailerListenerAdapter;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class InstallationManager {
    private static final String[] ERROR_SIGNALS = new String[]{"[Error]"};
    private static final String[] WARNING_SIGNALS = new String[]{"[Warn]", "[Warning]"};
    private ComponentInstallerDialog installationDialog;
    private Queue<InstallationStep> installationSteps;
    private String title = "Component Installer";
    private int totalSteps = 0;
    private int worked = 0;
    private Map<File, Thread> trackingThreads;
    private InstallationStep currentStep;
    private boolean hasError;

    public InstallationManager(Shell shell) {
        this(shell, null);
    }

    public InstallationManager(Shell shell, String title) {
        this.setInstallationSteps(new LinkedList<InstallationStep>());
        this.trackingThreads = new HashMap<File, Thread>();
        if (title != null) {
            this.title = title;
        }
        this.setInstallationDialog(new ComponentInstallerDialog(shell, ""));
    }

    public InstallationManager(Shell shell, String title, String troubleshootButtonLink) {
        this.setInstallationSteps(new LinkedList<InstallationStep>());
        this.trackingThreads = new HashMap<File, Thread>();
        if (title != null) {
            this.title = title;
        }
        this.setInstallationDialog(new ComponentInstallerDialog(shell, troubleshootButtonLink));
    }

    public void appendStep(InstallationStep step) {
        this.getInstallationSteps().add(step);
    }

    public void startInstallation() throws InvocationTargetException, InterruptedException {
        this.worked = 0;
        this.totalSteps = this.getInstallationSteps().size();
        this.getInstallationDialog().run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                UISynchronizeService.syncExec(() -> monitor.beginTask(InstallationManager.this.title, InstallationManager.this.totalSteps));
                InstallationManager.this.hasError = false;
                while (!InstallationManager.this.getInstallationSteps().isEmpty()) {
                    InstallationStep step;
                    InstallationManager.this.currentStep = step = InstallationManager.this.getInstallationSteps().poll();
                    try {
                        InstallationManager.this.runStep(step);
                    }
                    catch (RunInstallationStepException error) {
                        Thread.sleep(1000L);
                        InstallationManager.this.handleFailedStep(step, error);
                        if (step.isWarning()) continue;
                        InstallationManager.this.hasError = true;
                        break;
                    }
                }
                InstallationManager.this.stopAllTrackingThreads();
                UISynchronizeService.syncExec(() -> monitor.done());
            }
        });
    }

    private void handleFailedStep(InstallationStep step, RunInstallationStepException error) throws InterruptedException {
        UISynchronizeService.syncExec(() -> {
            if (step.isWarning()) {
                this.handleWarningStep(step, error);
            } else {
                this.handleErrorStep(step, error);
            }
        });
    }

    private void handleWarningStep(InstallationStep step, RunInstallationStepException error) {
        String message = MessageFormat.format(ComposerComponentsImplMessageConstants.MSG_INSTALLATION_WARNING, step.getTitle());
        message = MessageFormat.format("\r\n{0}\r\n", message);
        this.getInstallationDialog().appendWarning(message);
        if (error != null) {
            this.getInstallationDialog().appendWarning(String.valueOf(error.getTargetException().getMessage()) + "\r\n");
            this.getInstallationDialog().setWarningMessage(error.getMessage());
        } else {
            this.getInstallationDialog().setWarningMessage(message);
        }
    }

    private void handleErrorStep(InstallationStep step, RunInstallationStepException error) {
        String message = MessageFormat.format(ComposerComponentsImplMessageConstants.MSG_INSTALLATION_ERROR, step.getTitle());
        message = MessageFormat.format("\r\n{0}\r\n", message);
        this.getInstallationDialog().appendWarning(message);
        if (error != null) {
            this.getInstallationDialog().appendWarning(String.valueOf(error.getTargetException().getMessage()) + "\r\n");
            this.getInstallationDialog().setFailureMessage(error.getMessage());
        } else {
            this.getInstallationDialog().setFailureMessage(message);
        }
    }

    private void runStep(InstallationStep step) throws InvocationTargetException, InterruptedException {
        this.notifyStartNextStep(step);
        this.startLogTrackingThread(step, step.getLogFile());
        this.startErrorLogTrackingThread(step, step.getErrorLogFile());
        IProgressMonitor monitor = this.getInstallationDialog().getProgressMonitor();
        IRunnableWithProgress before = step.getBefore();
        if (before != null) {
            before.run(monitor);
        }
        step.run(monitor);
        IRunnableWithProgress after = step.getAfter();
        if (after != null) {
            after.run(monitor);
        }
        Thread.sleep(1000L);
        this.handleStepResults(null, step);
    }

    private Thread startLogTrackingThread(final InstallationStep step, File logFile) {
        if (this.trackingThreads.containsKey(logFile)) {
            return null;
        }
        Thread trackingThread = new Thread((Runnable)((Object)new CustomTailer(logFile, (TailerListener)new TailerListenerAdapter(){

            public void handle(String line) {
                boolean isWarning = Arrays.stream(WARNING_SIGNALS).anyMatch(signal -> StringUtils.startsWithIgnoreCase((String)line, (String)signal));
                if (isWarning) {
                    UISynchronizeService.syncExec(() -> InstallationManager.this.getInstallationDialog().appendWarning(String.valueOf(line) + "\r\n"));
                } else {
                    boolean isError = Arrays.stream(ERROR_SIGNALS).anyMatch(signal -> StringUtils.startsWithIgnoreCase((String)line, (String)signal));
                    if (isError) {
                        step.markAsWarning();
                        UISynchronizeService.syncExec(() -> InstallationManager.this.getInstallationDialog().appendError(String.valueOf(line) + "\r\n"));
                    } else {
                        UISynchronizeService.syncExec(() -> InstallationManager.this.getInstallationDialog().appendInfo(String.valueOf(line) + "\r\n"));
                    }
                }
            }
        }, 100L, true)));
        this.trackingThreads.put(logFile, trackingThread);
        trackingThread.start();
        return trackingThread;
    }

    private Thread startErrorLogTrackingThread(final InstallationStep step, File errorLogFile) {
        if (this.trackingThreads.containsKey(errorLogFile)) {
            return null;
        }
        Thread trackingThread = new Thread((Runnable)((Object)new CustomTailer(errorLogFile, (TailerListener)new TailerListenerAdapter(){

            public void handle(String line) {
                boolean isWarning = Arrays.stream(WARNING_SIGNALS).anyMatch(signal -> StringUtils.startsWithIgnoreCase((String)line, (String)signal));
                if (isWarning) {
                    UISynchronizeService.syncExec(() -> InstallationManager.this.getInstallationDialog().appendWarning(String.valueOf(line) + "\r\n"));
                } else {
                    step.markAsWarning();
                    UISynchronizeService.syncExec(() -> InstallationManager.this.getInstallationDialog().appendError(String.valueOf(line) + "\r\n"));
                }
            }
        }, 100L, true)));
        this.trackingThreads.put(errorLogFile, trackingThread);
        trackingThread.start();
        return trackingThread;
    }

    private void stopAllTrackingThreads() throws InterruptedException {
        this.trackingThreads.forEach((logFile, trackingThread) -> {
            if (trackingThread != null && trackingThread.isAlive()) {
                trackingThread.interrupt();
            }
            trackingThread = null;
        });
        this.trackingThreads.clear();
    }

    private void notifyStartNextStep(InstallationStep step) {
        UISynchronizeService.syncExec(() -> {
            this.getInstallationDialog().getProgressMonitor().subTask(String.format(String.valueOf(step.getTitle()) + " (%d/%d)", this.worked, this.totalSteps));
            if (this.worked > 0) {
                this.getInstallationDialog().appendInfo("\r\n\r\n----------------------------------------------------\r\n\r\n");
            }
            this.getInstallationDialog().appendInfo(String.valueOf(step.getTitle()) + "\r\n\r\n");
        });
    }

    private void handleStepResults(List<String> results, InstallationStep step) throws InterruptedException, RunInstallationStepException {
        if (results != null) {
            LoggerSingleton.logInfo((String)String.join((CharSequence)"\r\n", results));
        }
        ++this.worked;
        UISynchronizeService.syncExec(() -> {
            this.getInstallationDialog().getProgressMonitor().worked(1);
            this.getInstallationDialog().getProgressMonitor().subTask(String.format(String.valueOf(step.getTitle()) + " (%d/%d)", this.worked, this.totalSteps));
        });
        if (step.isWarning()) {
            throw new RunInstallationStepException(MessageFormat.format(ComposerComponentsImplMessageConstants.MSG_INSTALLATION_WARNING, step.getTitle()), new Exception(""));
        }
        if (this.getInstallationDialog().getProgressMonitor().isCanceled()) {
            throw new InterruptedException(ComposerComponentsImplMessageConstants.MSG_INSTALLATION_CANCELED);
        }
    }

    public ComponentInstallerDialog getInstallationDialog() {
        return this.installationDialog;
    }

    public void setInstallationDialog(ComponentInstallerDialog installationDialog) {
        this.installationDialog = installationDialog;
    }

    private Queue<InstallationStep> getInstallationSteps() {
        return this.installationSteps;
    }

    private void setInstallationSteps(Queue<InstallationStep> installationSteps) {
        this.installationSteps = installationSteps;
    }

    public InstallationStep getCurrentStep() {
        return this.currentStep;
    }

    public boolean hasError() {
        return this.hasError;
    }
}

