/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.overlay;

import com.kms.katalon.composer.components.constants.DialogType;
import com.kms.katalon.composer.components.util.AnimationUtil;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.components.util.FontUtil;
import com.kms.katalon.composer.components.util.StyleContext;
import com.kms.katalon.composer.components.util.UITimeUtil;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Popover
extends Shell {
    protected final int MIN_CONTENT_WIDTH = 250;
    protected final int MAX_CONTENT_WIDTH = 450;
    private Widget target;
    private Listener repositionListener;
    private Listener positionCheckListener;
    private MouseListener parentMouseListener;
    private Rectangle cachedTargetArea;
    private int returnCode;
    private DialogPositionProvider positionProvider;
    private int preferedPosition;
    private boolean hiddenByDefault = false;
    private boolean useCaret = false;
    private Listener onClose;

    public Popover(Control target) {
        this(target.getShell(), (Widget)target);
    }

    public Popover(Shell parent, Widget target) {
        this(parent, target, 8);
    }

    public Popover(Shell parent, Widget target, int style) {
        this(parent, target, style, 0x1000080, true);
    }

    public Popover(Shell parent, Widget target, int style, int preferedPosition) {
        this(parent, target, style, preferedPosition, true);
    }

    public Popover(Shell parent, Widget target, int style, int preferedPosition, boolean useCaret) {
        super(parent, style | 8);
        this.target = target;
        this.preferedPosition = preferedPosition;
        this.useCaret = useCaret;
        super.setAlpha(1);
        DialogUtil.setType((Shell)this.getShell(), (DialogType)DialogType.POPOVER);
    }

    protected void checkSubclass() {
    }

    public void open() {
        if (!this.hiddenByDefault) {
            AnimationUtil.fadeIn((Shell)this);
        } else {
            this.setAlpha(0);
        }
        this.create();
        super.open();
        this.preventEscKey();
        DialogUtil.hideOverlapedPopover((Shell)this.getShell());
    }

    private void preventEscKey() {
        this.getShell().addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    event.doit = false;
                }
            }
        });
    }

    public void close() {
        this.detachFromParent();
        if (this.returnCode <= 0) {
            this.setReturnCode(0);
        }
        AnimationUtil.fadeOut((Shell)this, (long)250L);
        UITimeUtil.setTimeout(() -> {
            if (!this.isDisposed()) {
                super.close();
            }
        }, (long)250L);
        DialogUtil.restoreOverlapedPopover((Shell)this.getShell());
        if (this.onClose != null) {
            this.onClose.handleEvent(null);
        }
    }

    public void closeImmediately() {
        if (!this.isDisposed()) {
            super.close();
        }
    }

    public void fakeOpen() {
        AnimationUtil.fadeIn((Shell)this);
    }

    public void fakeClose() {
        AnimationUtil.fadeOut((Shell)this);
        if (this.getOnClose() != null) {
            this.getOnClose().handleEvent(null);
        }
    }

    private void create() {
        this.attachToParent();
        this.createContent((Composite)this);
        this.pack();
        this.reposition();
    }

    private void attachToParent() {
        this.repositionListener = event -> {
            if (ControlUtil.isDisposed((Widget)this)) {
                return;
            }
            this.reposition();
        };
        Shell parentShell = (Shell)this.getParent();
        parentShell.addListener(10, this.repositionListener);
        parentShell.addListener(11, this.repositionListener);
        this.parentMouseListener = ComponentEventUtil.onMouseUp((Control)parentShell, event -> {
            if (!this.isDisposed()) {
                this.forceFocus();
            }
        });
        Control parent = (Control)ControlUtil.getParent((Widget)this.target);
        this.positionCheckListener = event -> {
            Rectangle targetArea = ComponentUtil.getScreenArea((Widget)this.target, null);
            if (targetArea != null && !targetArea.equals((Object)this.cachedTargetArea)) {
                this.reposition();
            }
        };
        if (!ControlUtil.isDisposed((Widget)parent)) {
            parent.addListener(9, this.positionCheckListener);
        }
    }

    private void detachFromParent() {
        Control parent;
        Shell parentShell = (Shell)this.getParent();
        if (!ControlUtil.isDisposed((Widget)parentShell)) {
            if (this.repositionListener != null) {
                parentShell.removeListener(10, this.repositionListener);
                parentShell.removeListener(11, this.repositionListener);
            }
            if (this.parentMouseListener != null) {
                parentShell.removeMouseListener(this.parentMouseListener);
            }
        }
        if (!ControlUtil.isDisposed((Widget)(parent = (Control)ControlUtil.getParent((Widget)this.target))) && this.positionCheckListener != null) {
            parent.removeListener(9, this.positionCheckListener);
        }
    }

    protected void createContent(Composite parent) {
        StyleContext.begin();
        StyleContext.setBackground((Color)ColorUtil.getCompositeBackgroundColorForDialog());
        StyleContext.setColor((Color)ColorUtil.getTextColor());
        ComponentBuilder.fromGrid((Composite)parent).margin(0).build();
        ComponentUtil.getGridLayout((Composite)parent).numColumns = 1;
        Composite container = this.createContainer(parent);
        this.createInnerContent(container);
        StyleContext.end();
    }

    protected Composite createContainer(Composite parent) {
        int offset = this.useCaret ? 8 : 0;
        int padding = ComponentUtil.applyZoom((int)8);
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).margin(padding + offset, padding, padding, padding + offset).fill().build();
        return container;
    }

    protected void createInnerContent(Composite parent) {
        ComponentBuilder.label((Composite)parent).text("Hello").font(FontUtil.H4).margin(10).fillHorizontal().left().build();
    }

    protected void reposition() {
        Rectangle targetArea;
        if (this.isDisposed()) {
            return;
        }
        this.pack();
        Rectangle dialogArea = ComponentUtil.getScreenArea((Widget)this, null);
        this.cachedTargetArea = targetArea = ComponentUtil.getScreenArea((Widget)this.target, null);
        if (dialogArea == null || targetArea == null) {
            return;
        }
        Rectangle bestArea = DialogUtil.calcBestPopoverPosition((Rectangle)targetArea, (Rectangle)dialogArea, (int)this.preferedPosition);
        if (this.positionProvider != null) {
            Point customPosition = this.positionProvider.compute(this.getShell(), bestArea, dialogArea, targetArea);
            this.setLocation(customPosition.x, customPosition.y);
            bestArea.x = customPosition.x;
            bestArea.y = customPosition.y;
        }
        int curX = bestArea.x;
        int minX = 4;
        int adjustX = Math.max(minX - curX, 0);
        bestArea.x += adjustX;
        bestArea.width -= adjustX;
        int offset = this.useCaret ? 8 : 0;
        Rectangle bounds = new Rectangle(bestArea.x, bestArea.y, bestArea.width + offset, bestArea.height + offset);
        this.setBounds(bounds);
        this.setRegion(bestArea);
    }

    protected void setRegion(Rectangle rect) {
        if (this.useCaret) {
            ComponentUtil.setRegion((Control)this, (Region)ComponentUtil.createRectangleRegion((Rectangle)rect, (Rectangle)this.cachedTargetArea));
        } else {
            Rectangle regionRect = new Rectangle(0, 0, rect.width, rect.height);
            ComponentUtil.setRegion((Control)this, (Region)ComponentUtil.createRectangleRegion((Rectangle)regionRect));
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public DialogPositionProvider getPositionProvider() {
        return this.positionProvider;
    }

    public void setPositionProvider(DialogPositionProvider positionProvider) {
        this.positionProvider = positionProvider;
    }

    public boolean isHiddenByDefault() {
        return this.hiddenByDefault;
    }

    public void setHiddenByDefault(boolean hiddenByDefault) {
        this.hiddenByDefault = hiddenByDefault;
    }

    public int getPreferedPosition() {
        return this.preferedPosition;
    }

    public void setPreferedPosition(int preferedPosition) {
        this.preferedPosition = preferedPosition;
    }

    public boolean isUseCaret() {
        return this.useCaret;
    }

    public void setUseCaret(boolean useCaret) {
        this.useCaret = useCaret;
    }

    public Listener getOnClose() {
        return this.onClose;
    }

    public void setOnClose(Listener onClose) {
        this.onClose = onClose;
    }

    public static interface DialogPositionProvider {
        public Point compute(Shell var1, Object ... var2);
    }
}

