/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.table;

import com.kms.katalon.composer.components.impl.table.ColumnBuilder;
import com.kms.katalon.composer.components.impl.table.CustomColumn;
import com.kms.katalon.composer.components.impl.table.CustomTable;
import com.kms.katalon.composer.components.impl.util.CommonInterfaces;
import com.kms.katalon.composer.components.util.ComponentDataUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class TableBuilder<ItemType> {
    private CustomTable<ItemType> table;

    private TableBuilder(Composite parent, int style) {
        this.table = new CustomTable(parent, style);
    }

    public static <ItemType> TableBuilder<ItemType> create(Composite parent) {
        return TableBuilder.create(parent, 0);
    }

    public static <ItemType> TableBuilder<ItemType> create(Composite parent, int style) {
        return new TableBuilder<ItemType>(parent, style);
    }

    public TableBuilder<ItemType> newRowProvider(CommonInterfaces.ValueProvider<ItemType> newRowProvider) {
        this.table.newRowProvider = newRowProvider;
        return this;
    }

    public TableBuilder<ItemType> cloneProvider(CommonInterfaces.CloneProvider<ItemType> cloneProvider) {
        this.table.cloneProvider = cloneProvider;
        return this;
    }

    public <ColumnType> TableBuilder<ItemType> buildColumn(ComponentColumnBuilder<ItemType, ColumnType> builder) {
        ColumnBuilder columnBuilder = ColumnBuilder.create();
        builder.build(columnBuilder);
        return this.column(columnBuilder.build());
    }

    public <ColumnType> TableBuilder<ItemType> column(CustomColumn<ItemType, ColumnType> column) {
        this.table.createColumn(column);
        return this;
    }

    public TableBuilder<ItemType> rows(List<ItemType> rows) {
        this.table.setRows(rows);
        return this;
    }

    private void adjustColumns() {
        TableColumn[] tableColumns;
        int tableWidth = ComponentDataUtil.getWidth(this.table);
        TableColumnLayout tableColumnLayout = (TableColumnLayout)this.table.getLayout();
        Table rootTable = (Table)this.table.getChildren()[0];
        TableColumn[] tableColumnArray = tableColumns = rootTable.getColumns();
        int n = tableColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn columnI = tableColumnArray[n2];
            CustomColumn columnInfoI = (CustomColumn)columnI.getData();
            int widthInPixels = this.calcSize(columnInfoI.width, tableWidth);
            boolean isFill = widthInPixels == -1;
            tableColumnLayout.setColumnData((Widget)columnI, (ColumnLayoutData)(isFill ? new ColumnWeightData(100, false) : new ColumnPixelData(widthInPixels, true, true)));
            ++n2;
        }
    }

    private int calcSize(String size, int parentSize) {
        boolean isPercent = this.isPercent(size);
        float widthInPercent = isPercent ? this.parsePercent(size) : 0.0f;
        return (int)(isPercent ? widthInPercent * (float)parentSize : (float)this.parsePixel(size));
    }

    private boolean isPercent(String size) {
        return StringUtils.containsIgnoreCase((String)size, (String)"%") || StringUtils.containsIgnoreCase((String)size, (String)".");
    }

    private float parsePercent(String size) {
        if (StringUtils.containsIgnoreCase((String)size, (String)"%")) {
            return Float.parseFloat(this.trimNumber(size)) / 100.0f;
        }
        if (StringUtils.containsIgnoreCase((String)size, (String)".")) {
            return Float.parseFloat(this.trimNumber(size));
        }
        return 0.0f;
    }

    private int parsePixel(String size) {
        return Integer.parseInt(this.trimNumber(size), 10);
    }

    private String trimNumber(String number) {
        return number.replaceAll("[%px]", "");
    }

    public CustomTable<ItemType> build() {
        this.adjustColumns();
        return this.table;
    }

    public static interface ComponentColumnBuilder<ItemType, ColumnType> {
        public void build(ColumnBuilder<ItemType, ColumnType> var1);
    }
}

