/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.util;

import com.kms.katalon.composer.components.impl.constants.ComposerComponentsImplMessageConstants;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.entity.file.FileEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MenuUtils {
    private MenuUtils() {
    }

    public static void createOpenTestArtifactsMenu(HashMap<FileEntity, SelectionAdapter> mapFileEntityToSelectionAdapter, Menu tableContextMenu) {
        MenuItem openMenuItem = new MenuItem(tableContextMenu, 64);
        openMenuItem.setText(ComposerComponentsImplMessageConstants.MENU_OPEN);
        openMenuItem.setID(100);
        Menu subMenu = new Menu(openMenuItem);
        HashMap<FileEntity, String> mapEntityToName = MenuUtils.getListOfDifferentTestArtifactName(mapFileEntityToSelectionAdapter.keySet());
        for (Map.Entry<FileEntity, String> entry : mapEntityToName.entrySet()) {
            FileEntity fileEntity = entry.getKey();
            ControlUtils.createSubMenuOpen(subMenu, fileEntity, mapFileEntityToSelectionAdapter.get(fileEntity), entry.getValue());
        }
        openMenuItem.setMenu(subMenu);
    }

    private static HashMap<FileEntity, String> getListOfDifferentTestArtifactName(Set<FileEntity> entities) {
        HashMap mapNameEntity = new HashMap();
        HashMap<FileEntity, String> mapEntityToName = new HashMap<FileEntity, String>();
        for (FileEntity fileEntity : entities) {
            String fileName = fileEntity.getName();
            if (!mapNameEntity.containsKey(fileName)) {
                ArrayList<FileEntity> list = new ArrayList<FileEntity>();
                list.add(fileEntity);
                mapNameEntity.put(fileName, list);
                continue;
            }
            ((List)mapNameEntity.get(fileName)).add(fileEntity);
        }
        for (Map.Entry entry : mapNameEntity.entrySet()) {
            List fileEntities = (List)entry.getValue();
            if (fileEntities.size() == 1) {
                FileEntity entity = (FileEntity)fileEntities.get(0);
                mapEntityToName.put(entity, (String)entry.getKey());
                continue;
            }
            mapEntityToName.putAll(MenuUtils.getRelativeIDofListSameNameFileEntity(fileEntities));
        }
        return mapEntityToName;
    }

    private static HashMap<FileEntity, String> getRelativeIDofListSameNameFileEntity(List<FileEntity> fileEntities) {
        HashMap<FileEntity, String> mapEntityToName = new HashMap<FileEntity, String>();
        for (FileEntity fileEntity : fileEntities) {
            String displayID = fileEntity.getIdForDisplay();
            mapEntityToName.put(fileEntity, displayID.substring(displayID.indexOf("/") + 1, displayID.length()));
        }
        return mapEntityToName;
    }
}

