/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.checker;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.dsl.checker.IStaticCheckerHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.widgets.Shell;

public class ResourceMarkerHandler
implements IStaticCheckerHandler {
    private IFile resource;
    private int numFound = 0;

    @Override
    public void setResource(IFile resource) {
        this.resource = resource;
    }

    @Override
    public void handleUnknownReference(ASTNode node, Position position, int line) {
        ++this.numFound;
        this.createMarker(position, line, this.createUnknownMessage(node));
    }

    @Override
    public void handleTypeAssertionFailed(ASTNode node, String expectedType, String actualType, Position position, int line) {
        ++this.numFound;
        this.createMarker(position, line, this.createInvalidTypeMessage(node, expectedType, actualType));
    }

    private String createUnknownMessage(ASTNode node) {
        return "Type of expression is statically unknown: " + node.getText();
    }

    private String createInvalidTypeMessage(ASTNode node, String expectedType, String actualType) {
        return "Invalid inferred type.  Expected: " + expectedType + " Actual: " + actualType;
    }

    private void createMarker(Position position, int line, String message) {
        try {
            IMarker marker = this.resource.createMarker("org.codehaus.groovy.eclipse.dsl.inferencing_problem");
            marker.setAttribute("severity", 1);
            marker.setAttribute("charStart", position.offset);
            marker.setAttribute("charEnd", position.offset + position.length);
            marker.setAttribute("lineNumber", line);
            marker.setAttribute("location", (Object)"Type checking");
            marker.setAttribute("sourceId", (Object)"Groovy");
            marker.setAttribute("message", (Object)message);
        }
        catch (CoreException e) {
            GroovyCore.logException((String)("Unable to create marker on " + this.resource.getFullPath()), (Throwable)e);
        }
    }

    @Override
    public int numProblemsFound() {
        return this.numFound;
    }

    @Override
    public void handleResourceStart(IResource resource) throws CoreException {
        resource.deleteMarkers("org.codehaus.groovy.eclipse.dsl.inferencing_problem", true, 0);
    }

    @Override
    public boolean finish(Shell shell) {
        if (shell != null) {
            if (this.numProblemsFound() == 0) {
                MessageDialog.openInformation((Shell)shell, (String)"Static type checking complete", (String)"Static type checking complete. Found no problems.");
            } else if (this.numProblemsFound() == 1) {
                MessageDialog.openInformation((Shell)shell, (String)"Static type checking complete", (String)"Static type checking complete. Found one problem.  See Problems view.");
            } else {
                MessageDialog.openInformation((Shell)shell, (String)"Static type checking complete", (String)("Static type checking complete. Found " + this.numProblemsFound() + " problems.  See Problems view."));
            }
        }
        return this.numFound == 0;
    }
}

