/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.contributions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyMethodProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyNamedArgumentProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.ProposalFormattingOptions;
import org.codehaus.groovy.eclipse.dsl.contributions.ContributionElems;
import org.codehaus.groovy.eclipse.dsl.contributions.IContributionElement;
import org.codehaus.groovy.eclipse.dsl.contributions.ParameterContribution;
import org.codehaus.groovy.eclipse.dsl.lookup.ResolverCache;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.jdt.groovy.ast.MethodNodeWithNamedParams;
import org.eclipse.jdt.groovy.core.util.ArrayUtils;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.AbstractSimplifiedTypeLookup;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;

public class MethodContributionElement
implements IContributionElement {
    private static final ParameterContribution[] NO_PARAMETER_CONTRIBUTIONS = new ParameterContribution[0];
    private final String methodName;
    private final String returnType;
    private final String declaringType;
    private final String provider;
    private final String doc;
    private final ParameterContribution[] namedParams;
    private final ParameterContribution[] optionalParams;
    private final ParameterContribution[] positionalParams;
    private final boolean isDeprecated;
    private final boolean isStatic;
    private final boolean noParens;
    private final int relevanceMultiplier;
    private ClassNode cachedReturnType;
    private ClassNode cachedDeclaringType;
    private Parameter[] cachedNamedParameters;
    private Parameter[] cachedOptionalParameters;
    private Parameter[] cachedPositionalParameters;

    public MethodContributionElement(String methodName, ParameterContribution[] params, String returnType, String declaringType, boolean isStatic, String provider, String doc, boolean useNamedArgs, boolean isDeprecated, int relevanceMultiplier) {
        this(methodName, params, NO_PARAMETER_CONTRIBUTIONS, NO_PARAMETER_CONTRIBUTIONS, returnType, declaringType, isStatic, provider, doc, useNamedArgs, false, isDeprecated, relevanceMultiplier);
    }

    public MethodContributionElement(String methodName, ParameterContribution[] params, ParameterContribution[] namedParams, ParameterContribution[] optionalParams, String returnType, String declaringType, boolean isStatic, String provider, String doc, boolean useNamedArgs, boolean noParens, boolean isDeprecated, int relevanceMultiplier) {
        this.methodName = methodName;
        this.returnType = returnType;
        this.declaringType = declaringType;
        this.namedParams = !useNamedArgs ? namedParams : (!DefaultGroovyMethods.asBoolean((Object[])namedParams) ? params : (ParameterContribution[])ArrayUtils.concat((Object[])params, (Object[])namedParams));
        this.optionalParams = optionalParams;
        this.positionalParams = !useNamedArgs ? params : NO_PARAMETER_CONTRIBUTIONS;
        this.noParens = noParens;
        this.isStatic = isStatic;
        this.isDeprecated = isDeprecated;
        this.relevanceMultiplier = relevanceMultiplier;
        String string = this.provider = provider != null ? ContributionElems.removeJavadocMarkup(provider) : "DSL Descriptor";
        this.doc = doc != null ? doc : "Provided by " + (provider != null ? provider : "DSL Descriptor");
    }

    @Override
    public AbstractSimplifiedTypeLookup.TypeAndDeclaration resolve(String name, ClassNode declaringType, ResolverCache resolver, VariableScope scope) {
        if (name.equals(this.methodName)) {
            boolean variadic;
            ClassNode type;
            MethodNode decl = this.toMethod(declaringType, resolver);
            ClassNode classNode = type = decl instanceof ConstructorNode ? decl.getDeclaringClass() : decl.getReturnType();
            if (!scope.isMethodCall()) {
                return new AbstractSimplifiedTypeLookup.TypeAndDeclaration(type, (ASTNode)decl, decl.getDeclaringClass(), this.doc, TypeLookupResult.TypeConfidence.LOOSELY_INFERRED);
            }
            BiFunction<ClassNode, ClassNode, Boolean> checker = (source, target) -> {
                Boolean result = Boolean.TRUE;
                if (!target.equals(source) && (VariableScope.NULL_TYPE != source || ClassHelper.isPrimitiveType((ClassNode)target))) {
                    result = !GroovyUtils.isAssignable((ClassNode)source, (ClassNode)target) && (!VariableScope.CLOSURE_CLASS_NODE.equals(source) || !ClassHelper.isSAMType((ClassNode)target)) ? Boolean.FALSE : null;
                }
                return result;
            };
            List argumentTypes = scope.getMethodCallArgumentTypes();
            Parameter[] parameters = ((MethodNodeWithNamedParams)decl).getPositionalParams();
            if (!(argumentTypes.isEmpty() || !((ClassNode)argumentTypes.get(0)).equals((Object)VariableScope.MAP_CLASS_NODE) || parameters.length != 0 && parameters[0].getType().equals((Object)VariableScope.MAP_CLASS_NODE))) {
                argumentTypes = argumentTypes.subList(1, argumentTypes.size());
            }
            int nArguments = argumentTypes.size();
            int nthParameter = parameters.length - 1;
            boolean bl = variadic = nthParameter != -1 && parameters[nthParameter].getType().isArray();
            Boolean compat = variadic ? nArguments >= nthParameter : nArguments == parameters.length;
            int i = 0;
            while (i < nArguments && !Boolean.FALSE.equals(compat)) {
                Boolean partialResult;
                ClassNode at = GroovyUtils.getWrapperTypeIfPrimitive((ClassNode)((ClassNode)argumentTypes.get(i)));
                ClassNode pt = GroovyUtils.getWrapperTypeIfPrimitive((ClassNode)parameters[Math.min(i, nthParameter)].getType());
                if (variadic && (i > nthParameter || i == nthParameter && !at.isArray())) {
                    pt = pt.getComponentType();
                }
                if ((partialResult = checker.apply(at, pt)) == null) {
                    compat = null;
                } else if (!partialResult.booleanValue()) {
                    compat = Boolean.FALSE;
                }
                ++i;
            }
            if (!Boolean.FALSE.equals(compat)) {
                return new AbstractSimplifiedTypeLookup.TypeAndDeclaration(type, (ASTNode)decl, decl.getDeclaringClass(), this.doc);
            }
        }
        return null;
    }

    @Override
    public IGroovyProposal toProposal(ClassNode declaringType, ResolverCache resolver) {
        GroovyMethodProposal proposal = new GroovyMethodProposal(this.toMethod(declaringType.redirect(), resolver), this.provider);
        proposal.setProposalFormattingOptions(ProposalFormattingOptions.newFromOptions().newFromExisting(false, this.noParens, proposal.getMethod()));
        proposal.setRelevanceMultiplier((float)this.relevanceMultiplier);
        return proposal;
    }

    @Override
    public List<IGroovyProposal> extraProposals(ClassNode declaringType, ResolverCache resolver, Expression expression) {
        Map<String, ClassNode> availableNamedParams = this.collectAvailableParameters(resolver);
        this.removeUsedParameters(availableNamedParams, expression);
        if (availableNamedParams.isEmpty()) {
            return ProposalUtils.NO_PROPOSALS;
        }
        ArrayList<IGroovyProposal> extraProposals = new ArrayList<IGroovyProposal>(availableNamedParams.size());
        for (Map.Entry<String, ClassNode> available : availableNamedParams.entrySet()) {
            extraProposals.add((IGroovyProposal)new GroovyNamedArgumentProposal(available.getKey(), available.getValue(), this.toMethod(declaringType.redirect(), resolver), this.getContributionName()));
        }
        return extraProposals;
    }

    private Map<String, ClassNode> collectAvailableParameters(ResolverCache resolver) {
        ParameterContribution param;
        HashMap<String, ClassNode> available = new HashMap<String, ClassNode>(this.namedParams.length + this.optionalParams.length);
        ParameterContribution[] parameterContributionArray = this.namedParams;
        int n = this.namedParams.length;
        int n2 = 0;
        while (n2 < n) {
            param = parameterContributionArray[n2];
            available.put(param.name, param.toParameter(resolver).getType());
            ++n2;
        }
        parameterContributionArray = this.optionalParams;
        n = this.optionalParams.length;
        n2 = 0;
        while (n2 < n) {
            param = parameterContributionArray[n2];
            available.put(param.name, param.toParameter(resolver).getType());
            ++n2;
        }
        return available;
    }

    private void removeUsedParameters(Map<String, ClassNode> available, Expression expression) {
        if (expression instanceof MethodCall) {
            MethodCall call = (MethodCall)expression;
            Expression arguments = call.getArguments();
            if (arguments instanceof TupleExpression) {
                for (Expression maybeArg : ((TupleExpression)arguments).getExpressions()) {
                    if (!(maybeArg instanceof MapExpression)) continue;
                    arguments = maybeArg;
                    break;
                }
            }
            if (arguments instanceof MapExpression) {
                MapExpression enclosingCallArgs = (MapExpression)arguments;
                for (MapEntryExpression entry : enclosingCallArgs.getMapEntryExpressions()) {
                    String paramName = entry.getKeyExpression().getText();
                    available.remove(paramName);
                }
            }
        }
    }

    private MethodNode toMethod(ClassNode declaringType, ResolverCache resolver) {
        MethodNodeWithNamedParams method;
        if (this.cachedNamedParameters == null) {
            this.cachedNamedParameters = MethodContributionElement.toParameters(this.namedParams, resolver);
            this.cachedOptionalParameters = MethodContributionElement.toParameters(this.optionalParams, resolver);
            this.cachedPositionalParameters = MethodContributionElement.toParameters(this.positionalParams, resolver);
        }
        if ("<init>".equals(this.methodName)) {
            method = new ConstructorContribution(this.modifiers(), this.cachedNamedParameters, this.cachedOptionalParameters, this.cachedPositionalParameters);
            ClassNode type = this.declaringType(declaringType, resolver);
            if (type == declaringType) {
                type = this.returnType(resolver);
            }
            method.setDeclaringClass(type);
        } else {
            method = new MethodContribution(this.methodName, this.modifiers(), this.returnType(resolver), this.cachedNamedParameters, this.cachedOptionalParameters, this.cachedPositionalParameters);
            method.setDeclaringClass(this.declaringType(declaringType, resolver));
        }
        return method;
    }

    private static Parameter[] toParameters(ParameterContribution[] pcs, ResolverCache resolver) {
        Parameter[] ps;
        if (pcs == null) {
            ps = Parameter.EMPTY_ARRAY;
        } else {
            int n = pcs.length;
            ps = new Parameter[n];
            int i = 0;
            while (i < n) {
                ps[i] = pcs[i].toParameter(resolver);
                ++i;
            }
        }
        return ps;
    }

    private ClassNode declaringType(ClassNode lexicalDeclaringType, ResolverCache resolver) {
        if (this.declaringType != null && this.cachedDeclaringType == null) {
            this.cachedDeclaringType = resolver.resolve(this.declaringType);
        }
        return this.cachedDeclaringType == null ? lexicalDeclaringType : this.cachedDeclaringType;
    }

    private ClassNode returnType(ResolverCache resolver) {
        if (this.cachedReturnType == null) {
            if (resolver != null) {
                this.cachedReturnType = resolver.resolve(this.returnType);
                if (this.returnType.indexOf(60) < 1) {
                    this.cachedReturnType = this.cachedReturnType.getPlainNodeReference();
                }
            } else {
                this.cachedReturnType = ClassHelper.dynamicType();
            }
        }
        return this.cachedReturnType;
    }

    private int modifiers() {
        int modifiers = 1;
        if (this.isStatic) {
            modifiers |= 8;
        }
        if (this.isDeprecated) {
            modifiers |= 0x100000;
        }
        return modifiers;
    }

    @Override
    public String description() {
        return "Method: " + this.declaringType + "." + this.methodName + "(..)";
    }

    @Override
    public String getContributionName() {
        if ("<init>".equals(this.methodName)) {
            return this.getDeclaringTypeName();
        }
        return this.methodName;
    }

    @Override
    public String getDeclaringTypeName() {
        return this.declaringType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("public ");
        if (this.isStatic) {
            sb.append("static ");
        }
        if (this.isDeprecated) {
            sb.append("deprecated ");
        }
        sb.append(this.returnType).append(' ');
        sb.append(this.declaringType);
        sb.append('.').append(this.methodName);
        sb.append('(').append(Arrays.toString(this.positionalParams)).append(')');
        sb.append(' ').append('(').append(this.provider).append(')');
        return sb.toString();
    }

    public static class ConstructorContribution
    extends ConstructorNode
    implements MethodNodeWithNamedParams {
        private final Parameter[] namedParams;
        private final Parameter[] optionalParams;
        private final Parameter[] positionalParams;

        public ConstructorContribution(int modifiers, Parameter[] namedParams, Parameter[] optionalParams, Parameter[] positionalParams) {
            super(modifiers, MethodNodeWithNamedParams.concatParams((Parameter[])positionalParams, (Parameter[])namedParams, (Parameter[])optionalParams), null, null);
            this.namedParams = namedParams;
            this.optionalParams = optionalParams;
            this.positionalParams = positionalParams;
        }

        public Parameter[] getNamedParams() {
            return this.namedParams;
        }

        public Parameter[] getOptionalParams() {
            return this.optionalParams;
        }

        public Parameter[] getPositionalParams() {
            return this.positionalParams;
        }
    }

    public static class MethodContribution
    extends MethodNode
    implements MethodNodeWithNamedParams {
        private final Parameter[] namedParams;
        private final Parameter[] optionalParams;
        private final Parameter[] positionalParams;

        public MethodContribution(String name, int modifiers, ClassNode returnType, Parameter[] namedParams, Parameter[] optionalParams, Parameter[] positionalParams) {
            super(name, modifiers, returnType, MethodNodeWithNamedParams.concatParams((Parameter[])positionalParams, (Parameter[])namedParams, (Parameter[])optionalParams), null, null);
            this.namedParams = namedParams;
            this.optionalParams = optionalParams;
            this.positionalParams = positionalParams;
        }

        public Parameter[] getNamedParams() {
            return this.namedParams;
        }

        public Parameter[] getOptionalParams() {
            return this.optionalParams;
        }

        public Parameter[] getPositionalParams() {
            return this.positionalParams;
        }
    }
}

