/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions;

import java.util.List;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.IValueCheckingRule;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;

public abstract class AbstractJavaTypeVerifiedRule
implements IValueCheckingRule {
    public static final String THE_SPECIFIED_JAVA_TYPES_DO_NOT_EXIST = "The specified Java type(s) does not exist: ";
    public static final String INVALID_JAVA = "Invalid Java type.";
    private IJavaProject project;
    private NameLookup nameLookup;

    public AbstractJavaTypeVerifiedRule(IJavaProject project) {
        this.project = project;
    }

    protected IJavaProject getJavaProject() {
        return this.project;
    }

    protected NameLookup getNameLookup() throws JavaModelException {
        if (this.nameLookup == null && this.project instanceof JavaProject) {
            this.nameLookup = ((JavaProject)this.project).newNameLookup((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
        }
        return this.nameLookup;
    }

    protected IType getActualType(String name) throws JavaModelException {
        NameLookup nameLkUp = this.getNameLookup();
        if (nameLkUp != null) {
            return nameLkUp.findType(name, false, 0x100001E);
        }
        return null;
    }

    protected String composeErrorMessage(List<String> allNonExistantTypes) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(THE_SPECIFIED_JAVA_TYPES_DO_NOT_EXIST);
        int size = allNonExistantTypes.size();
        for (String name : allNonExistantTypes) {
            buffer.append(name);
            if (--size <= 0) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }
}

