/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui;

import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.IValueCheckingRule;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.JavaValidIdentifierRule;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ValueStatus;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.AbstractLabeledDialogueControl;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.IDialogueControlDescriptor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class JavaTextControl
extends AbstractLabeledDialogueControl {
    private String initialValue;
    private Text textControl;
    private IValueCheckingRule cachedValueCheckingRule;

    public JavaTextControl(IDialogueControlDescriptor labelDescriptor, Point offsetLabelLocation, String initialValue) {
        super(labelDescriptor, offsetLabelLocation);
        this.initialValue = initialValue;
    }

    @Override
    protected Control getManagedControl(Composite parent) {
        this.textControl = new Text(parent, 2048);
        if (this.initialValue != null) {
            this.textControl.setText(this.initialValue);
        }
        this.textControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textControl.addModifyListener(e -> this.notifyControlChange(this.textControl.getText(), (Control)this.textControl));
        return this.textControl;
    }

    protected Text getTextControl() {
        return this.textControl;
    }

    @Override
    protected ValueStatus isControlValueValid(Control control) {
        if (control == this.textControl) {
            String stringVal = this.textControl.getText();
            return this.isControlValueValid(stringVal);
        }
        return null;
    }

    protected ValueStatus isControlValueValid(String value) {
        if (this.cachedValueCheckingRule == null) {
            this.cachedValueCheckingRule = this.getCachedValidationRule();
        }
        if (this.cachedValueCheckingRule != null) {
            return this.cachedValueCheckingRule.checkValidity(value);
        }
        return ValueStatus.getValidStatus(value);
    }

    protected IValueCheckingRule getCachedValidationRule() {
        return new JavaValidIdentifierRule();
    }
}

