/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.proposals;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.eclipse.codeassist.processors.IProposalFilterExtension;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class DSLDProposalFilter
implements IProposalFilterExtension {
    private static final Pattern BASE_DESC = Pattern.compile("^.* - (\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");

    public List<IGroovyProposal> filterProposals(List<IGroovyProposal> proposals, ContentAssistContext context, JavaContentAssistInvocationContext javaContext) {
        return null;
    }

    public List<ICompletionProposal> filterExtendedProposals(List<ICompletionProposal> proposals, ContentAssistContext context, JavaContentAssistInvocationContext javaContext) {
        LinkedHashMap<String, ICompletionProposal> map = new LinkedHashMap<String, ICompletionProposal>();
        for (ICompletionProposal proposal : proposals) {
            int r2;
            int r1;
            String key = DSLDProposalFilter.getKeyString(proposal);
            ICompletionProposal previous = map.put(key, proposal);
            if (!(previous instanceof IJavaCompletionProposal) || !(proposal instanceof IJavaCompletionProposal) || (r1 = ((IJavaCompletionProposal)previous).getRelevance()) <= (r2 = ((IJavaCompletionProposal)proposal).getRelevance())) continue;
            map.put(key, previous);
        }
        if (map.size() != proposals.size()) {
            return new ArrayList<ICompletionProposal>(map.values());
        }
        return null;
    }

    private static String getKeyString(ICompletionProposal proposal) {
        String[] tokens;
        String key = proposal.getDisplayString();
        Matcher m = BASE_DESC.matcher(key);
        if (m.find()) {
            key = m.group();
        }
        if ((tokens = key.split("\\(|\\)|,")).length > 1) {
            StringBuilder buf = new StringBuilder(tokens[0]).append('(');
            int i = 1;
            while (i < tokens.length - 1) {
                if (i > 1) {
                    buf.append(',');
                }
                buf.append(tokens[i].replaceFirst(" \\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*$", ""));
                ++i;
            }
            buf.append(')').append(tokens[tokens.length - 1]);
            key = buf.toString();
        }
        return key;
    }
}

