/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.builder;

import org.codehaus.groovy.eclipse.core.builder.GroovyClasspathContainer;
import org.codehaus.groovy.eclipse.core.model.GroovyRuntime;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class GroovyClasspathContainerInitializer
extends ClasspathContainerInitializer {
    public String getDescription(IPath containerPath, IJavaProject javaProject) {
        return "Groovy Libraries for " + javaProject.getElementName();
    }

    public void initialize(IPath containerPath, IJavaProject javaProject) throws CoreException {
        String val;
        if (!(containerPath.segmentCount() != 1 || javaProject.exists() && GroovyRuntime.findClasspathEntry(javaProject, cpe -> "GROOVY_SUPPORT".equals(cpe.getPath().segment(0))).filter(GroovyClasspathContainer::hasLegacyMinimalAttribute).isPresent() || "default".equals(val = GroovyClasspathContainer.getLegacyUserLibsPreference(javaProject)))) {
            containerPath = containerPath.append("user-libs=" + Boolean.valueOf(val).toString());
        }
        JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{new GroovyClasspathContainer(containerPath)}, null);
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject javaProject) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject javaProject, IClasspathContainer containerSuggestion) throws CoreException {
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)javaProject);
        if (container instanceof GroovyClasspathContainer) {
            ((GroovyClasspathContainer)container).reset();
        }
    }
}

