/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.kobiton.driver;

import com.kms.katalon.core.driver.DriverType;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.execution.webui.driver.RemoteWebDriverConnector;
import com.kms.katalon.integration.kobiton.constants.IntegrationKobitonMessages;
import com.kms.katalon.integration.kobiton.entity.KobitonDevice;
import com.kms.katalon.integration.kobiton.preferences.KobitonPreferencesProvider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;

public class KobitonDriverConnector
extends RemoteWebDriverConnector {
    private KobitonDevice kobitonDevice;
    private String apiKey;
    private String userName;

    public KobitonDriverConnector(String projectDir) throws IOException {
        super(projectDir);
        this.remoteWebDriverConnectorType = RemoteWebDriverConnector.RemoteWebDriverConnectorType.Appium;
    }

    public String getRemoteServerUrl() {
        if (this.apiKey == null || this.userName == null || this.kobitonDevice == null) {
            throw new IllegalArgumentException(IntegrationKobitonMessages.MSG_ERR_MISSING_EXECUTION_INFO);
        }
        try {
            return this.buildKobitonUrl();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getServerUrl() {
        return this.getRemoteServerUrl();
    }

    public void setServerUrl(String serverUrl) {
        KobitonPreferencesProvider.saveKobitonServerUrl(serverUrl);
    }

    private String buildKobitonUrl() throws MalformedURLException, URISyntaxException {
        URL serverUrl = new URL(KobitonPreferencesProvider.getKobitonServerUrl());
        URIBuilder builder = new URIBuilder().setScheme(serverUrl.getProtocol()).setUserInfo(this.userName, this.apiKey).setHost(serverUrl.getHost()).setPath("/wd/hub");
        if (serverUrl.getPort() > 0) {
            builder.setPort(serverUrl.getPort());
        }
        return builder.build().toString();
    }

    public DriverType getDriverType() {
        return WebUIDriverType.KOBITON_WEB_DRIVER;
    }

    public KobitonDevice getKobitonDevice() {
        return this.kobitonDevice;
    }

    public void setKobitonDevice(KobitonDevice kobitonDevice) {
        this.kobitonDevice = kobitonDevice;
        this.setMobileDriverType(KobitonDriverConnector.getMobileDriverType(kobitonDevice));
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Map<String, Object> getUserConfigProperties() {
        Map configProperties = super.getUserConfigProperties();
        configProperties.putAll(this.kobitonDevice.toDesireCapabilitiesMap());
        return configProperties;
    }

    public Map<String, Object> getSystemProperties() {
        Map systemProperties = super.getSystemProperties();
        systemProperties.putAll(this.kobitonDevice.getSystemPropertiesMap());
        return systemProperties;
    }

    public static MobileDriverType getMobileDriverType(KobitonDevice kobitonDevice) {
        if (kobitonDevice == null || kobitonDevice.getCapabilities() == null) {
            return null;
        }
        if ("iOS".equals(kobitonDevice.getCapabilities().getPlatformName())) {
            return MobileDriverType.IOS_DRIVER;
        }
        if ("Android".equals(kobitonDevice.getCapabilities().getPlatformName())) {
            return MobileDriverType.ANDROID_DRIVER;
        }
        return null;
    }
}

