/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.search.action;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.handlers.SearchHandler;
import com.kms.katalon.composer.search.constants.StringConstants;
import com.kms.katalon.composer.search.view.QSearchQuery;
import com.kms.katalon.composer.search.view.QSearchQueryBuilder;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.global.GlobalVariableEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;

public class ShowPreferencesAction {
    @Inject
    private ESelectionService selectionService;

    @Execute
    public void showTreeEntityReferences() {
        try {
            Object[] objects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            QSearchQuery query = null;
            if (objects[0] instanceof ITreeEntity) {
                ITreeEntity treeEntity = (ITreeEntity)objects[0];
                ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
                query = QSearchQueryBuilder.getReferenceQueryForTreeEntity(treeEntity, projectEntity);
            }
            if (query != null) {
                SearchHandler.openSearchView();
                NewSearchUI.runQueryInBackground(query, (ISearchResultViewPart)NewSearchUI.getSearchResultView());
            }
        }
        catch (Exception e) {
            MessageDialog.openConfirm(null, (String)StringConstants.ERROR_TITLE, (String)StringConstants.ACT_ERROR_MSG_UNABLE_TO_SHOW_REFERENCES);
            LoggerSingleton.getInstance().getLogger().error((Throwable)e);
        }
    }

    @Inject
    @Optional
    private void showGlobalVariableReferences(@UIEventTopic(value="GLOBAL_VARIABLE/SHOW_REFERENCES") GlobalVariableEntity variable) {
        ProjectEntity projectEntity;
        QSearchQuery query;
        if (variable != null && (query = QSearchQueryBuilder.getGlobalVariablePrefrenceQuery(variable, GroovyUtil.getGroovyProject((ProjectEntity)(projectEntity = ProjectController.getInstance().getCurrentProject())))) != null) {
            SearchHandler.openSearchView();
            NewSearchUI.runQueryInBackground((ISearchQuery)query, (ISearchResultViewPart)NewSearchUI.getSearchResultView());
        }
    }
}

