/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testlistener.dialog;

import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.dialogs.TitleAreaDialog;
import com.kms.katalon.composer.testlistener.constant.ComposerTestListenerMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.core.annotation.AfterTestCase;
import com.kms.katalon.core.annotation.AfterTestSuite;
import com.kms.katalon.core.annotation.BeforeTestCase;
import com.kms.katalon.core.annotation.BeforeTestSuite;
import com.kms.katalon.entity.file.TestListenerEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewTestListenerDialog
extends TitleAreaDialog {
    private static final String NEW_TEST_LISTENER_NAME = "NewTestListener";
    private Text txtName;
    private NewTestListenerResult result;
    private Map<String, Button> generateMethodButtons = new HashMap<String, Button>();
    private List<TestListenerEntity> currentListeners;

    public NewTestListenerDialog(Shell parentShell, List<TestListenerEntity> currentListeners) {
        super(parentShell);
        this.currentListeners = currentListeners;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite nameComposite = new Composite(container, 0);
        nameComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 15;
        nameComposite.setLayout((Layout)layout);
        Label lblName = new Label(nameComposite, 0);
        lblName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblName.setText(GlobalMessageConstants.NAME);
        this.txtName = new Text(nameComposite, 2048);
        GridData gdTxtName = new GridData(4, 0x1000000, true, false, 1, 1);
        gdTxtName.minimumWidth = 200;
        this.txtName.setLayoutData((Object)gdTxtName);
        Composite sampleMethodComposite = new Composite(container, 0);
        sampleMethodComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        sampleMethodComposite.setLayout((Layout)new GridLayout(1, false));
        Button btnGenerateBeforeTC = new Button(sampleMethodComposite, 32);
        btnGenerateBeforeTC.setText(ComposerTestListenerMessageConstants.DIA_LBL_GENERATE_SAMPLE_BEFORE_TEST_CASE);
        this.generateMethodButtons.put(BeforeTestCase.class.getName(), btnGenerateBeforeTC);
        Button btnGenerateAfterTC = new Button(sampleMethodComposite, 32);
        btnGenerateAfterTC.setText(ComposerTestListenerMessageConstants.DIA_LBL_GENERATE_SAMPLE_AFTER_TEST_CASE);
        this.generateMethodButtons.put(AfterTestCase.class.getName(), btnGenerateAfterTC);
        Button btnGenerateBeforeTS = new Button(sampleMethodComposite, 32);
        btnGenerateBeforeTS.setText(ComposerTestListenerMessageConstants.DIA_LBL_GENERATE_SAMPLE_BEFORE_TEST_SUITE);
        this.generateMethodButtons.put(BeforeTestSuite.class.getName(), btnGenerateBeforeTS);
        Button btnGenerateAfterTS = new Button(sampleMethodComposite, 32);
        btnGenerateAfterTS.setText(ComposerTestListenerMessageConstants.DIA_LBL_GENERATE_SAMPLE_AFTER_TEST_SUITE);
        this.generateMethodButtons.put(AfterTestSuite.class.getName(), btnGenerateAfterTS);
        this.setInput();
        this.registerControlModifyListeners();
        return container;
    }

    private void setInput() {
        this.txtName.setText(this.getSuggestion(NEW_TEST_LISTENER_NAME));
        this.txtName.selectAll();
        this.txtName.forceFocus();
        this.setMessage(ComposerTestListenerMessageConstants.DIA_MSG_CREATE_NEW_TEST_LISTENER, 1);
    }

    private boolean isNameDupplicated(String newName) {
        return this.currentListeners.parallelStream().filter(l -> l.getName().equals(newName)).findAny().isPresent();
    }

    private String getSuggestion(String suggestion) {
        String newName = suggestion;
        int index = 0;
        while (this.isNameDupplicated(newName)) {
            newName = String.format("%s_%d", suggestion, ++index);
        }
        return newName;
    }

    private void checkNewName(String newName) {
        if (this.isNameDupplicated(newName)) {
            this.setMessage(StringConstants.DIA_NAME_EXISTED, 3);
            this.getButton(0).setEnabled(false);
            return;
        }
        IStatus status = JavaConventionsUtil.validateJavaTypeName((String)this.txtName.getText(), null);
        switch (status.getSeverity()) {
            case 0: {
                this.setMessage(ComposerTestListenerMessageConstants.DIA_MSG_CREATE_NEW_TEST_LISTENER, 1);
                break;
            }
            case 2: {
                this.setMessage(status.getMessage(), 2);
                break;
            }
            case 4: {
                this.setMessage(status.getMessage(), 3);
            }
        }
        this.getButton(0).setEnabled(status.getSeverity() != 4);
    }

    protected void registerControlModifyListeners() {
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewTestListenerDialog.this.checkNewName(NewTestListenerDialog.this.txtName.getText());
            }
        });
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ComposerTestListenerMessageConstants.ITEM_LBL_NEW_TEST_LISTENER);
    }

    protected int getShellStyle() {
        return 1264;
    }

    protected void okPressed() {
        String newName = this.txtName.getText();
        Map<String, Boolean> sampleMethodAllowed = this.generateMethodButtons.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((Button)e.getValue()).getSelection()));
        this.result = new NewTestListenerResult(newName, sampleMethodAllowed);
        super.okPressed();
    }

    public NewTestListenerResult getResult() {
        return this.result;
    }

    protected Point getInitialSize() {
        return new Point(400, super.getInitialSize().y);
    }

    public class NewTestListenerResult {
        private final String newName;
        private final Map<String, Boolean> sampleMethodAllowed;

        private NewTestListenerResult(String newName, Map<String, Boolean> sampleMethodAllowed) {
            this.newName = newName;
            this.sampleMethodAllowed = sampleMethodAllowed;
        }

        public String getNewName() {
            return this.newName;
        }

        public Map<String, Boolean> getSampleMethodAllowed() {
            return this.sampleMethodAllowed;
        }
    }
}

