/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.project;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.handler.AsyncHandler;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.internal.model.Field;
import org.qas.qtest.api.services.project.ProjectServiceAsync;
import org.qas.qtest.api.services.project.ProjectServiceClient;
import org.qas.qtest.api.services.project.model.CreateCustomFieldRequest;
import org.qas.qtest.api.services.project.model.CreateModuleRequest;
import org.qas.qtest.api.services.project.model.CreateProjectRequest;
import org.qas.qtest.api.services.project.model.GetFieldsRequest;
import org.qas.qtest.api.services.project.model.GetModuleRequest;
import org.qas.qtest.api.services.project.model.GetUserPermissionsRequest;
import org.qas.qtest.api.services.project.model.LinkTestCaseRequirementRequest;
import org.qas.qtest.api.services.project.model.ListModuleRequest;
import org.qas.qtest.api.services.project.model.ListProjectRequest;
import org.qas.qtest.api.services.project.model.ListUserPermissionsRequest;
import org.qas.qtest.api.services.project.model.Module;
import org.qas.qtest.api.services.project.model.Project;
import org.qas.qtest.api.services.project.model.UpdateSystemFieldRequest;
import org.qas.qtest.api.services.project.model.UserPermissions;

public class ProjectServiceAsyncClient
extends ProjectServiceClient
implements ProjectServiceAsync {
    public ProjectServiceAsyncClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration(), Executors.newCachedThreadPool());
    }

    public ProjectServiceAsyncClient(ExecutorService executorService) {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration(), executorService);
    }

    public ProjectServiceAsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public ProjectServiceAsyncClient(ClientConfiguration clientConfiguration, ExecutorService executorService) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration, executorService);
    }

    public ProjectServiceAsyncClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration(), Executors.newCachedThreadPool());
    }

    public ProjectServiceAsyncClient(QTestCredentials credentials, ExecutorService executorService) {
        this(credentials, new ClientConfiguration(), executorService);
    }

    public ProjectServiceAsyncClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        this(credentials, clientConfiguration, Executors.newCachedThreadPool());
    }

    public ProjectServiceAsyncClient(QTestCredentials credentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        this(new StaticQTestCredentialsProvider(credentials), clientConfiguration, executorService);
    }

    public ProjectServiceAsyncClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this(credentialsProvider, clientConfiguration, Executors.newCachedThreadPool());
    }

    public ProjectServiceAsyncClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(credentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    @Override
    public Future<List<Project>> listProjectAsync(final ListProjectRequest listProjectRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<List<Project>>(){

            @Override
            public List<Project> call() throws Exception {
                return ProjectServiceAsyncClient.this.listProject(listProjectRequest);
            }
        });
    }

    @Override
    public Future<List<Project>> listProjectAsync(final ListProjectRequest listProjectRequest, final AsyncHandler<ListProjectRequest, List<Project>> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<List<Project>>(){

            @Override
            public List<Project> call() throws Exception {
                List<Project> result;
                try {
                    result = ProjectServiceAsyncClient.this.listProject(listProjectRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listProjectRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Project> createProjectAsync(final CreateProjectRequest createProjectRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<Project>(){

            @Override
            public Project call() throws Exception {
                return ProjectServiceAsyncClient.this.createProject(createProjectRequest);
            }
        });
    }

    @Override
    public Future<Project> createProjectAsync(final CreateProjectRequest createProjectRequest, final AsyncHandler<CreateProjectRequest, Project> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<Project>(){

            @Override
            public Project call() throws Exception {
                Project result;
                try {
                    result = ProjectServiceAsyncClient.this.createProject(createProjectRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createProjectRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Module> createModuleAsync(final CreateModuleRequest createModuleRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<Module>(){

            @Override
            public Module call() throws Exception {
                return ProjectServiceAsyncClient.this.createModule(createModuleRequest);
            }
        });
    }

    @Override
    public Future<Module> createModuleAsync(final CreateModuleRequest createModuleRequest, final AsyncHandler<CreateModuleRequest, Module> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<Module>(){

            @Override
            public Module call() throws Exception {
                Module result;
                try {
                    result = ProjectServiceAsyncClient.this.createModule(createModuleRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createModuleRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Module> getModuleAsync(final GetModuleRequest getModuleRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<Module>(){

            @Override
            public Module call() throws Exception {
                return ProjectServiceAsyncClient.this.getModule(getModuleRequest);
            }
        });
    }

    @Override
    public Future<Module> getModuleAsync(final GetModuleRequest getModuleRequest, final AsyncHandler<GetModuleRequest, Module> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<Module>(){

            @Override
            public Module call() throws Exception {
                Module result;
                try {
                    result = ProjectServiceAsyncClient.this.getModule(getModuleRequest);
                }
                catch (Exception e) {
                    asyncHandler.onError(e);
                    throw e;
                }
                asyncHandler.onSuccess(getModuleRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<List<Module>> listModuleAsync(final ListModuleRequest listModuleRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<List<Module>>(){

            @Override
            public List<Module> call() throws Exception {
                return ProjectServiceAsyncClient.this.listModule(listModuleRequest);
            }
        });
    }

    @Override
    public Future<List<Module>> listModuleAsync(final ListModuleRequest listModuleRequest, final AsyncHandler<ListModuleRequest, List<Module>> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<List<Module>>(){

            @Override
            public List<Module> call() throws Exception {
                List<Module> result;
                try {
                    result = ProjectServiceAsyncClient.this.listModule(listModuleRequest);
                }
                catch (Exception e) {
                    asyncHandler.onError(e);
                    throw e;
                }
                asyncHandler.onSuccess(listModuleRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> linkTestCaseRequirementAsync(final LinkTestCaseRequirementRequest linkTestCaseRequirementRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ProjectServiceAsyncClient.this.linkTestCaseRequirement(linkTestCaseRequirementRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> linkTestCaseRequirementAsync(final LinkTestCaseRequirementRequest linkTestCaseRequirementRequest, final AsyncHandler<LinkTestCaseRequirementRequest, Void> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    ProjectServiceAsyncClient.this.linkTestCaseRequirement(linkTestCaseRequirementRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(linkTestCaseRequirementRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Field> createCustomFieldAsync(final CreateCustomFieldRequest createCustomFieldRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<Field>(){

            @Override
            public Field call() throws Exception {
                return ProjectServiceAsyncClient.this.createCustomField(createCustomFieldRequest);
            }
        });
    }

    @Override
    public Future<Field> createCustomFieldAsync(final CreateCustomFieldRequest createCustomFieldRequest, final AsyncHandler<CreateCustomFieldRequest, Field> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<Field>(){

            @Override
            public Field call() throws Exception {
                Field result;
                try {
                    result = ProjectServiceAsyncClient.this.createCustomField(createCustomFieldRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createCustomFieldRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Field> updateSystemFieldAsync(final UpdateSystemFieldRequest updateSystemFieldRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<Field>(){

            @Override
            public Field call() throws Exception {
                return ProjectServiceAsyncClient.this.updateSystemField(updateSystemFieldRequest);
            }
        });
    }

    @Override
    public Future<Field> updateSystemFieldAsync(final UpdateSystemFieldRequest updateSystemFieldRequest, final AsyncHandler<UpdateSystemFieldRequest, Field> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<Field>(){

            @Override
            public Field call() throws Exception {
                Field result;
                try {
                    result = ProjectServiceAsyncClient.this.updateSystemField(updateSystemFieldRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateSystemFieldRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<List<Field>> getFieldsAsync(final GetFieldsRequest getFieldsRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<List<Field>>(){

            @Override
            public List<Field> call() throws Exception {
                return ProjectServiceAsyncClient.this.getFields(getFieldsRequest);
            }
        });
    }

    @Override
    public Future<List<Field>> getFieldsAsync(final GetFieldsRequest getFieldsRequest, final AsyncHandler<GetFieldsRequest, List<Field>> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<List<Field>>(){

            @Override
            public List<Field> call() throws Exception {
                List<Field> result;
                try {
                    result = ProjectServiceAsyncClient.this.getFields(getFieldsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getFieldsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UserPermissions> getUserPermissionsAsync(final GetUserPermissionsRequest getUserPermissionsRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<UserPermissions>(){

            @Override
            public UserPermissions call() throws Exception {
                return ProjectServiceAsyncClient.this.getUserPermissions(getUserPermissionsRequest);
            }
        });
    }

    @Override
    public Future<UserPermissions> getUserPermissionsAsync(final GetUserPermissionsRequest getUserPermissionsRequest, final AsyncHandler<GetUserPermissionsRequest, UserPermissions> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<UserPermissions>(){

            @Override
            public UserPermissions call() throws Exception {
                UserPermissions result;
                try {
                    result = ProjectServiceAsyncClient.this.getUserPermissions(getUserPermissionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getUserPermissionsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<List<UserPermissions>> listUserPermissionsAsync(final ListUserPermissionsRequest listUserPermissionsRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<List<UserPermissions>>(){

            @Override
            public List<UserPermissions> call() throws Exception {
                return ProjectServiceAsyncClient.this.listUserPermissions(listUserPermissionsRequest);
            }
        });
    }

    @Override
    public Future<List<UserPermissions>> listUserPermissionsAsync(final ListUserPermissionsRequest listUserPermissionsRequest, final AsyncHandler<ListUserPermissionsRequest, List<UserPermissions>> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<List<UserPermissions>>(){

            @Override
            public List<UserPermissions> call() throws Exception {
                List<UserPermissions> result;
                try {
                    result = ProjectServiceAsyncClient.this.listUserPermissions(listUserPermissionsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listUserPermissionsRequest, result);
                return result;
            }
        });
    }
}

