/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.addons;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.report.handlers.DeleteReportCollectionHandler;
import com.kms.katalon.composer.report.handlers.DeleteReportHandler;
import com.kms.katalon.composer.report.handlers.EvaluateIntegrationContributionViewHandler;
import com.kms.katalon.composer.report.handlers.OpenReportCollectionHandler;
import com.kms.katalon.composer.report.handlers.OpenReportHandler;
import com.kms.katalon.composer.report.handlers.RefreshReportHandler;
import com.kms.katalon.composer.report.handlers.RenameReportHandler;
import com.kms.katalon.composer.report.integration.ReportComposerIntegrationFactory;
import com.kms.katalon.composer.report.platform.ExportReportProviderPlugin;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.reporting.ExportReportProvider;
import com.kms.katalon.custom.factory.CustomKeywordPluginFactory;
import com.kms.katalon.custom.keyword.CustomKeywordPlugin;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ReportInjectionManagerAddon {
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void initHandlers(IEclipseContext context) {
        ContextInjectionFactory.make(DeleteReportHandler.class, (IEclipseContext)context);
        ContextInjectionFactory.make(DeleteReportCollectionHandler.class, (IEclipseContext)context);
        ContextInjectionFactory.make(OpenReportHandler.class, (IEclipseContext)context);
        ContextInjectionFactory.make(OpenReportCollectionHandler.class, (IEclipseContext)context);
        ContextInjectionFactory.make(RefreshReportHandler.class, (IEclipseContext)context);
        ContextInjectionFactory.make(EvaluateIntegrationContributionViewHandler.class, (IEclipseContext)context);
        ContextInjectionFactory.make(RenameReportHandler.class, (IEclipseContext)context);
        this.eventBroker.subscribe("PROJECT/LOAD_CLASS", new EventHandler(){

            public void handleEvent(Event event) {
                ReportInjectionManagerAddon.this.collectReportExportProviders();
            }
        });
        this.eventBroker.subscribe("WORKSPACE/PLUGIN_LOADED", new EventHandler(){

            public void handleEvent(Event event) {
                if (ProjectController.getInstance().getCurrentProject() != null) {
                    ReportInjectionManagerAddon.this.collectReportExportProviders();
                }
            }
        });
        this.eventBroker.subscribe("PLUGIN/BASIC_REPORT_INSTALLED", new EventHandler(){

            public void handleEvent(Event event) {
                if (ProjectController.getInstance().getCurrentProject() != null) {
                    ReportInjectionManagerAddon.this.collectReportExportProviders();
                }
            }
        });
    }

    private void collectReportExportProviders() {
        ReportComposerIntegrationFactory.getInstance().onProjectChanged();
        List plugins = CustomKeywordPluginFactory.getInstance().getPlugins();
        for (CustomKeywordPlugin plugin : plugins) {
            if (plugin.getKeywordsManifest() == null || plugin.getKeywordsManifest().getReport() == null || plugin.getKeywordsManifest().getReport().getExportProviderClassName() == null) continue;
            this.loadExportReportProvider(plugin, plugin.getKeywordsManifest().getReport().getExportProviderClassName());
        }
        this.eventBroker.post("PLUGIN/EXPORT_PROVIDER_COLLECTED", null);
    }

    private void loadExportReportProvider(CustomKeywordPlugin plugin, String exportReportProviderClassName) {
        try {
            URLClassLoader classLoader = ProjectController.getInstance().getProjectClassLoader(ProjectController.getInstance().getCurrentProject());
            Class<?> exportProviderClass = classLoader.loadClass(ExportReportProvider.class.getName());
            Class<?> clazz = classLoader.loadClass(exportReportProviderClassName);
            if (!exportProviderClass.isAssignableFrom(clazz)) {
                LoggerSingleton.logInfo((String)MessageFormat.format("Class {0} is not an instance of ExportReportProvider. Please check again.", exportReportProviderClassName));
                return;
            }
            ReportComposerIntegrationFactory.getInstance().addExportReportProvider(new ExportReportProviderPlugin(plugin, clazz.newInstance()));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | MalformedURLException | CoreException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

