/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.handlers;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.tree.ReportTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.handlers.deletion.IDeleteEntityHandler;
import com.kms.katalon.composer.report.constants.StringConstants;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.report.ReportEntity;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.swt.widgets.Display;

public class DeleteReportHandler
implements IDeleteEntityHandler {
    @Inject
    private UISynchronize sync;
    @Inject
    private IEventBroker eventBroker;

    public Class<? extends ITreeEntity> entityType() {
        return ReportTreeEntity.class;
    }

    public boolean execute(ITreeEntity treeEntity, IProgressMonitor monitor) {
        try {
            if (treeEntity == null || !(treeEntity instanceof ReportTreeEntity)) {
                return false;
            }
            String taskName = "Deleting " + treeEntity.getTypeName() + " '" + treeEntity.getText() + "'...";
            monitor.beginTask(taskName, 1);
            final ReportEntity report = (ReportEntity)treeEntity.getObject();
            if (report == null) {
                return false;
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    EntityPartUtil.closePart((IEntity)report);
                }
            });
            String reportId = report.getId();
            ReportController.getInstance().deleteReport(report);
            this.eventBroker.send("REPORT/DELETED", (Object)reportId);
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            this.sync.syncExec(new Runnable(){

                @Override
                public void run() {
                    MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_DELETE_REPORT, (String)e.getMessage());
                }
            });
            return false;
        }
        finally {
            monitor.done();
        }
    }
}

