/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.handlers;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.tree.ReportCollectionTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.SelectionServiceSingleton;
import com.kms.katalon.composer.report.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.ReportUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportItemDescription;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportTSCollectionHTMLReportHandler {
    @CanExecute
    public boolean canExecute() {
        return true;
    }

    @Execute
    public void execute(Shell shell) {
        DirectoryDialog dirDialog = new DirectoryDialog(shell);
        String exportPath = dirDialog.open();
        if (exportPath == null) {
            return;
        }
        File destDir = new File(exportPath);
        if (destDir == null || !destDir.exists() || !destDir.isDirectory()) {
            return;
        }
        ArrayList<String> exceptions = new ArrayList<String>();
        try {
            ReportCollectionTreeEntity reportTreeEntity = this.getSelectedReport();
            if (reportTreeEntity == null) {
                return;
            }
            ReportCollectionEntity report = reportTreeEntity.getObject();
            if (report == null) {
                return;
            }
            ArrayList tsInfoItems = new ArrayList();
            String projectDirLocation = ProjectController.getInstance().getCurrentProject().getFolderLocation();
            for (ReportItemDescription item : report.getReportItemDescriptions()) {
                try {
                    String reportRelativeLocation = item.getReportLocation();
                    String reportDirLocation = String.valueOf(projectDirLocation) + File.separator + reportRelativeLocation;
                    TestSuiteLogRecord testSuiteLogRecord = ReportUtil.generate((String)reportDirLocation);
                    int reportDirLocationHashCode = reportDirLocation.toString().hashCode();
                    String htmlFileName = String.valueOf(StringUtils.substringAfterLast((String)reportRelativeLocation, (String)"/")) + reportDirLocationHashCode + ".html";
                    File htmlFile = new File(String.valueOf(reportDirLocation) + File.separator + htmlFileName);
                    if (!htmlFile.exists()) {
                        if (testSuiteLogRecord == null) {
                            throw new FileNotFoundException(htmlFile.getPath());
                        }
                        ReportUtil.writeHtmlReportAppendHashCodeToName((TestSuiteLogRecord)testSuiteLogRecord, (File)new File(reportDirLocation), (int)reportDirLocationHashCode);
                    }
                    FileUtils.copyFileToDirectory((File)htmlFile, (File)destDir);
                    HashMap<String, String> tsInfoItem = new HashMap<String, String>();
                    tsInfoItem.put("report_location", reportRelativeLocation);
                    tsInfoItem.put("report", htmlFileName);
                    tsInfoItem.put("id", this.getTestSuiteId(reportRelativeLocation));
                    tsInfoItem.put("environment", item.getRunConfigDescription().getRunConfigurationId());
                    String status = this.getStatus(testSuiteLogRecord);
                    tsInfoItem.put("status", status);
                    tsInfoItem.put("fail_on_total", this.getFailOnTotal(testSuiteLogRecord));
                    tsInfoItem.put("status_color", this.getStatusColor(status));
                    tsInfoItem.put("fail_color", this.getFailColor(testSuiteLogRecord));
                    tsInfoItems.add(tsInfoItem);
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    exceptions.add(e.getMessage());
                }
            }
            ReportUtil.writeTSCollectionHTMLReport((String)reportTreeEntity.getParent().getText(), (String)JsonUtil.toJson(tsInfoItems, (boolean)false), (File)destDir, (boolean)false);
            Program.launch((String)destDir.toURI().toString());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            exceptions.add(e.getMessage());
        }
        if (exceptions.isEmpty()) {
            return;
        }
        String errorMsgDetails = StringUtils.join(exceptions, (String)"\n");
        MultiStatusErrorDialog.showErrorDialog((String)"Unable to export Test Suite Collection report", (String)errorMsgDetails, (String)errorMsgDetails);
    }

    private int getTotalFailedTestCases(TestSuiteLogRecord testSuiteLogRecord) {
        if (testSuiteLogRecord == null) {
            return 0;
        }
        return testSuiteLogRecord.getTotalFailedTestCases() + testSuiteLogRecord.getTotalErrorTestCases();
    }

    private String getFailOnTotal(TestSuiteLogRecord testSuiteLogRecord) {
        if (testSuiteLogRecord == null) {
            return StringConstants.EMPTY;
        }
        return String.valueOf(this.getTotalFailedTestCases(testSuiteLogRecord)) + " / " + testSuiteLogRecord.getTotalTestCases();
    }

    private String getFailColor(TestSuiteLogRecord testSuiteLogRecord) {
        if (testSuiteLogRecord == null) {
            return StringConstants.EMPTY;
        }
        if (this.getTotalFailedTestCases(testSuiteLogRecord) > 0) {
            return "#f19696";
        }
        return StringConstants.EMPTY;
    }

    private String getTestSuiteId(String reportRelativeLocation) {
        String testSuiteId = reportRelativeLocation.replaceFirst(StringConstants.ROOT_FOLDER_NAME_REPORT, StringConstants.ROOT_FOLDER_NAME_TEST_SUITE);
        testSuiteId = StringUtils.substringBeforeLast((String)testSuiteId, (String)"/");
        return testSuiteId;
    }

    private String getStatus(TestSuiteLogRecord logRecord) {
        if (logRecord == null) {
            return StringConstants.NOT_STARTED;
        }
        if (logRecord.getTotalIncompleteTestCases() > 0) {
            return StringConstants.INCOMPLETE;
        }
        return StringConstants.COMPLETE;
    }

    private String getStatusColor(String status) {
        if (StringUtils.equals((CharSequence)status, (CharSequence)StringConstants.NOT_STARTED)) {
            return String.valueOf(15);
        }
        if (StringUtils.equals((CharSequence)status, (CharSequence)StringConstants.INCOMPLETE)) {
            return "#f2bc70";
        }
        return StringConstants.EMPTY;
    }

    public ReportCollectionTreeEntity getSelectedReport() {
        Object o = SelectionServiceSingleton.getInstance().getSelectionService().getSelection("com.kms.katalon.composer.part.explorer");
        if (o == null || !o.getClass().isArray()) {
            return null;
        }
        Object[] selectedObjects = (Object[])o;
        if (selectedObjects.length == 0 || !(selectedObjects[0] instanceof ReportCollectionTreeEntity)) {
            return null;
        }
        return (ReportCollectionTreeEntity)selectedObjects[0];
    }
}

